intialize.push('wizard');

MR_landing.prototype.wizardDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'wizard').addClass('wizard complex-item').attr('id', $t.randString(6));
    
    var div = $t.ce('div');
    $(div).addClass('wizard-holder text-center').appendTo(box);

    $t.addAdminsBtns(box);
    
    $t.customSetting(box, 'fa-magic', $t.lang('COM_MARKETINGROCKET_WIZARD_SETTINGS'));
    
    $t.wizardFunctions(box);
    
    $t.addToParent(box, parent, className);
    
    $t.wizardCreateView(box, 2);
}; 
MR_landing.prototype.wizardCreateView = function(box, length, content){
    var $t = this;
    var $ = jQuery;
    var prefix = $(box).attr('id');
    var box = $(box).find('.wizard-holder');
            
    var defWidth = 1.5;
    length = parseInt(length);
    switch (length){
        case 3 :
        case 4 :
        case 5 : 
        case 6 :
            defWidth = 2;
            break;
    }; 
//    width = width-0.4;
    
    var width = (100/length)-defWidth;
    var leftPercent = (100/length);
    
    var ul = $(box).find(' > ul');
    var allLi = [];
    if(ul.length == 0){
        var ul = $t.ce('ul');
        $(ul).addClass('nav nav-pills nav-wizard').prependTo(box);
        
    }
    else 
        allLi = ul.find('li');
    
    
    
    if(!content){
        box.find('.tab-content').remove();
    } 
    else {
        
        var allPane = [];
        
        if(box.find('.tab-content').length == 0){
            var contentEl = $t.ce('div');
            $(contentEl).addClass('tab-content').appendTo(box);
        }
        else {
            contentEl = box.find('.tab-content');
            allPane = contentEl.find('> .tab-pane');
        }; 
    }; 
    $t.isChildAdded = true;
    for(var i = 0; i < length;i++){
        var left = (i*leftPercent);
        if(left == 0)
            left = defWidth/2;
        if(allLi[i]){
            var li = allLi.eq(i);
            if(pageDirection == 'ltr')
                li.css('width', width+'%').css('left', left+'%');
            else 
                li.css('width', width+'%').css('right', left+'%');
            if(i+1 < length && li.find('.nav-arrow').length == 0){
                var div = $t.ce('div');
                $(div).addClass('nav-arrow').appendTo(li);
            }
            else if(i+1 == length && li.find('.nav-arrow').length > 0)
                li.find('.nav-arrow').remove();
        }
        else {
            var li = $t.ce('li');
            if(pageDirection == 'ltr')
                $(li).css('width', width+'%').css('left', left+'%').appendTo(ul);
            else
                $(li).css('width', width+'%').css('right', left+'%').appendTo(ul);
            var a = $t.ce('a');
            $(a).attr('data-toggle', 'tab').attr('href', '#'+prefix+'-'+i);

            var span = $t.ce('span');
            $(span).addClass('contenteditable').attr('contenteditable', 'true').appendTo(a).text('step '+(i+1));

            if(i == 0){
                $(li).addClass('active');
                $(a).appendTo(li);
            }
            else {
                var div = $t.ce('div');
                $(div).addClass('nav-wedge').appendTo(li);
                $(a).appendTo(li);
            }; 

            if(i+1 < length){
                var div = $t.ce('div');
                $(div).addClass('nav-arrow').appendTo(li);
            }; 
        }; 
        
        if(content){
            if(allPane[i]){
                continue;
            } 
            else {
                var div = $t.ce('div');
                $(div).addClass('tab-pane').attr('id', prefix+'-'+i).appendTo(contentEl);
                if(i == 0){
                    $(div).addClass('active');
                }; 
                
                var row = $t.ce('div');
                $(row).addClass('row row-fluid haschild').appendTo(div);
                
                var articleBox = $t.articleboxDropped(row, 12);
            }; 
        }; 
    }; 
    $t.isChildAdded = false;
    
    var orig = i;
    
    while(allLi[orig]){
        allLi.eq(orig).remove();
        orig++;
    }; 
    
    var orig = i;
    if(content){
        while(allPane[orig]){
            allPane.eq(orig).remove();
            orig++;
        }; 
    }; 
    
}; 
MR_landing.prototype.wizardFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('> .el-button-holder .MR_Custom:first').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpWizard();
        $t.modal('#wizard-setting-template','show');
    })
    
}; 
MR_landing.prototype.beforeShowPopUpWizard = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#jform_wizard_count').val($t.activeEl.find('.wizard-holder > ul > li').length).chosen('destroy').chosen();
    
    if($t.activeEl.find('.tab-content').length > 0){
        $('#jform_wizard_have_desc0').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_wizard_have_desc1').prop('checked', false).next().attr('class', 'btn');
        
    }
    else {
        $('#jform_wizard_have_desc1').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_wizard_have_desc0').prop('checked', false).next().attr('class', 'btn');
    }; 
    
    var className = $t.activeEl.find('.wizard-holder > ul').attr('class').replace('nav nav-pills nav-wizard', '');
    className = $.trim(className);
    $('#jform_wizard_template').val(className).chosen('destroy').chosen();
    
}; 
MR_landing.prototype.wizard = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#jform_wizard_count').change(function(){
        $t.wizardCreateView($t.activeEl, $(this).val(), parseInt($('[name="jform[wizard_have_desc]"]:checked').val()));
    });
    
    $('#jform_wizard_template').change(function(){
        $t.activeEl.find('ul.nav-pills').attr('class', 'nav nav-pills nav-wizard '+$(this).val())
    });
    
    $('#jform_wizard_have_desc0,#jform_wizard_have_desc1').click(function(){
        var val = $(this).val();
        if(val == 1){
            if($t.activeEl.find('.tab-content').length > 0)
                return;
            $t.wizardCreateView($t.activeEl, $('#jform_wizard_count').val(), true);
        }
        else {
            $t.wizardCreateView($t.activeEl, $('#jform_wizard_count').val(), false);
        }; 
    })
    
};