intialize.push('video');
MR_landing.prototype.videoDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'video').addClass('video');
    
    var video = $t.ce('video');
    $(video).text($t.lang('COM_MARKETINGROCKET_YOUR_BROWSER_DOES_NOT_SUPPORT_THE_VIDEO_TAG')).attr('width', '100%').attr('height', '100%').attr('controls', '').appendTo(box);
    
    var source =  $t.ce('source');
    $(source).attr('type', 'video/mp4').appendTo(video);
    
    $t.addAdminsBtns(box);
    
    $t.customSetting(box, 'fa-film', $t.lang('COM_MARKETINGROCKET_VIDEO_SETTINGS'));
    $t.videoFunctions(box);
    
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.videoFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('.MR_Custom:first').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpVideo();
        $t.modal('#video-setting-template','show');
    })
};
MR_landing.prototype.beforeShowPopUpVideo = function(){
    var $t = this;
    var $ = jQuery;
    
    var video = $t.activeEl.find('video')
    
    $('#jform_videoel_file').val(video.find('source').attr('src'));
    var width = $t.getDimension(video.attr('width') ,$('#jform_video_width'));
    $('#jform_videoel_width').val(width);
    
    var h = $t.getDimension(video.attr('height') ,$('#jform_videoel_height'));
    $('#jform_videoel_height').val(h);
    
    if(video.attr('autoplay')){
        $('#jform_videoel_autoplay1').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_videoel_autoplay0').next().attr('class', 'btn');
    }
    else {
        $('#jform_videoel_autoplay1').next().attr('class', 'btn');
        $('#jform_videoel_autoplay0').prop('checked', true).next().attr('class', 'btn active btn-danger');
    }
    
    if(video.attr('controls')){
        $('#jform_videoel_control1').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_videoel_control0').next().attr('class', 'btn');
    }
    else {
        $('#jform_videoel_control1').next().attr('class', 'btn');
        $('#jform_videoel_control0').prop('checked', true).next().attr('class', 'btn active btn-danger');
    }
    
    
    
};
MR_landing.prototype.video = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#jform_videoel_file').keyup(function(){
        $t.activeEl.find('source').attr('src', joomlaHost+$(this).val().substr(1));
        $t.activeEl.find('video')[0].load();
    });
    
    $('#jform_videoel_width').keyup(function(){
        var width =  $t.setDimensionValue($(this).val() ,$(this));
        $t.activeEl.find('video').attr('width', width);
    });
    
    $('#jform_videoel_height').keyup(function(){
        var width =  $t.setDimensionValue($(this).val() ,$(this));
        $t.activeEl.find('video').attr('height', width);
    });
    
    $('#video-setting-template [name="jform[videoel_control]"]').click(function(){
        var val = $(this).val();
        if(val == 1){
            $t.activeEl.find('video').attr('controls', '');
        }
        else {
            $t.activeEl.find('video').removeAttr('controls');
        }
    });
    
    $('#video-setting-template [name="jform[videoel_autoplay]"]').click(function(){
        var val = $(this).val();
        if(val == 1){
            $t.activeEl.find('video').attr('autoplay', '')[0].load();
        }
        else {
            $t.activeEl.find('video').removeAttr('autoplay');
        }
    });
    
};