intialize.push('timer');

MR_landing.prototype.timerDropped = function(parent, className){

    var $t = this;

    var $ = jQuery;

    

    var box = $t.createBox('div', className);

    $(box).attr('aria-type', 'timer').addClass('timer_element');



    var div = $t.ce('div');

    

    var today = new Date();

    var dd = today.getDate()+1;

    var mm = today.getMonth()+1; //January is 0!



    var yyyy = today.getFullYear();

    if(dd<10){

        dd='0'+dd

    } 

    if(mm<10){

        mm='0'+mm

    } 

    var today = yyyy+'-'+mm+'-'+dd+' 00:00:00';

    

    $(div).addClass('timer-holder').attr('id', $t.randString(6)).attr('data-date', today)

            .attr('data-width', 800)

            .attr('data-bigest', 'year')

            .attr('data-background', '#000000')

            .attr('data-color', '#ffffff')

            .attr('data-timer-show', '')

            .attr('data-timer-hide', '')

            .attr('data-timezone', $t.defaultTimeZoneValue)

            .attr('data-timezonestring', $t.defaultTimeZoneString)

            .attr('data-timertype', '')

            .attr('data-seconds', '0')

            .attr('data-text-color', '#000000')

    ;

    $(box).append(div);



    $t.addAdminsBtns(box);



    $t.customSetting(box, 'fa-clock-o', $t.lang('COM_MARKETINGROCKET_TIMER_EDIT_TITLE'));

    $t.timerFunctions(box);





    $t.addToParent(box, parent, className);

    

    $('#jform_bigest').val('year');

    

    $t.createTimer($(div));

    $t.resizeTimer($(div));

}; 

MR_landing.prototype.timerFunctions = function(box){

    var $t = this;

    var $ = jQuery;

    

    $(box).find('a.MR_Custom').click(function(){

        $t.activeEl = $(box).find('.timer-holder');

        $t.beforeShowPopUpTimer();

        $t.modal('#timer_setting','show');

    });

}; 

MR_landing.prototype.beforeShowPopUpTimer = function(){

    var $t = this;

    var $ = jQuery;

    $t.intialize.push('timer');

    var t = $t.activeEl;

    

    

    $('#timer_setting > h3 > small').text('#'+t.attr('id'));

    

    if(t.attr('data-timertype') != undefined && t.attr('data-timertype') == 'timer'){

        $('#jform_timer_type1').next().click();

        $('#jform_timer_type1').click();

        

        var time = t.attr('data-seconds');

        var hour =0;

        var min = 0;

        var sec = 0;

        if(time >= 3600){

            hour = parseInt(time/3600);

            time = time-(hour*3600);

        }; 

        if(time >= 60){

            min = parseInt(time/60);

            time = time-(min*60);

        }; 

        sec = time;

        

        $('#jform_time_hour').val(hour);

        $('#jform_time_minute').val(min);

        $('#jform_time_second').val(sec);

    }

    else {

        $('#jform_timer_type0').next().click();

        $('#jform_timer_type0').click();

        

        $('#jform_time_hour,#jform_time_minute,#jform_time_second').val(0);

    }; 

    

    $('#jform_time').val(t.attr('data-date'));

    $('#jform_bigest').val(t.attr('data-bigest')).chosen('destroy').chosen();

    $('#timer_width').slider('value', t.attr('data-width'));

    $('#timer_width_input').val(t.attr('data-width'));

    

    $('#jform_timer_background').val(t.attr('data-background')).ColorPickerSetColor(t.attr('data-background'));

    $('#jform_timer_color').val(t.attr('data-color')).ColorPickerSetColor(t.attr('data-color'));

    $('#jform_timer_after').val(t.attr('data-action')).change().chosen('destroy').chosen();

    

    $('#jform_timer_show').val(t.attr('data-timer-show'));

    

    $('#jform_timer_hide').val(t.attr('data-timer-hide'));

    

    $('#jform_line_color').val(t.data('line-color'));

    

    $('#jform_text_color').val(t.data('text-color'));

    

};

MR_landing.prototype.timer = function(){

    var $t = this;

   

    var $ = jQuery;

    $('#jform_time_btn').blur(function(){

		$t.activeEl.attr("data-date",$("#jform_time").val());
		/* 
		* Author: Viren Dave
		* Purpose: To resolve Counter issue
		*/
		var date_future = new Date($("#jform_time").val());
		var date_now = new Date();
		
		var diff_date =  date_future - date_now;

		var num_years = Math.floor(diff_date/31536000000);

		var num_months = Math.floor((diff_date % 31536000000)/2628000000);

		var days = Math.floor(((diff_date % 31536000000) % 2628000000)/86400000);

		var h = Math.floor(diff_date / 3600000) % 24;
		diff_date -= h * 3600000;
		
		var m = Math.floor(diff_date / 60000) % 60;
		
		diff_date -= m * 60000;		
		var s = diff_date % 60; 
		var seconds = s;
		var minutes = Math.floor(m);
		var hours = h;	
		/*console.log('num_years'+num_years+' num_months'+num_months+' days'+days+' hours'+hours+' minutes'+minutes+' seconds'+seconds);*/
		var tempCount = 1;

		var CounteractiveEl = $t.activeEl;

			var tempElement = $($t.activeEl).find('.time-row-1');

			$(tempElement).find('span').each(function(i,e){

			

			if(tempCount == 1){ $(this).html(num_years); }

			if(tempCount == 2){ $(this).html(num_months); }

			if(tempCount == 3){ $(this).html(days); }

			if(tempCount == 4){ $(this).html(hours); }

			if(tempCount == 5){ $(this).html(minutes); }

			if(tempCount == 6){ $(this).html(seconds); }					

			tempCount++;

		});

    });

    $('#jform_time').keyup(function(){

        $('#jform_time_btn').blur();

    });
	
	$('#jform_time').blur(function(){

        $('#jform_time_btn').blur();

    });

    $('#timer_width_input').unbind('keyup').keyup(function(){

         $t.activeEl.attr('data-width', $(this).val());

         $t.resizeTimer();

    });

    $('#jform_bigest').change(function(){

         $t.activeEl.attr('data-bigest', $(this).val());

         $t.createTimer();

         $t.resizeTimer();

    });

    $('#jform_timer_background').keyup(function(){

        $t.activeEl.attr('data-background', $(this).val());

        $t.activeEl.find('.time-row-1').css('background-color', $(this).val());

    });

    $('#jform_timer_color').keyup(function(){

        $t.activeEl.attr('data-color', $(this).val());

        $t.activeEl.find('.time-row-1').css('color', $(this).val());

    });

    

    $('#jform_line_color').keyup(function(){

        $t.activeEl.attr('data-line-color', $(this).val());

         $t.activeEl.find('.line').css('background-color', $(this).val());

    })

    

    $('#jform_text_color').keyup(function(){

        $t.activeEl.attr('data-text-color', $(this).val());

        $t.activeEl.find('.time-row-2').css('color', $(this).val());

        

    })

    

    $('#jform_timer_show, #jform_timer_hide').blur(function(){

        var val = $(this).val();

        if(val != ''){

            if(val.substr(0,1) != '#' && val.substr(0,1) != '.')

                val = '#'+val;



            if($(val).length == 0)

            {

                alert($t.lang('COM_MARKETINGROCKET_ELEMENT_NOT_FOUND'));

            }; 

        }; 

        var name = $(this).attr('name');

        name = name.replace('jform[', '');

        name = name.replace(']', '');

        $t.activeEl.attr('data-'+name, val);

    });

    $('#jform_timer_timezone').change(function(){

       $t.activeEl.attr('data-timezonestring', $(this).val());

       $t.activeEl.attr('data-timezone', timeZones[$(this).val()]);

        

    })

    

    $t.defaultTimeZoneString = $('#jform_timer_timezone').val();

    $t.defaultTimeZoneValue = timeZones[$('#jform_timer_timezone').val()];

    

    $('[name="jform[timer_type]"]').click(function(){

        if($(this).val() == 'counter'){

            $('#timer_time_holder').hide();

            $('#jform_time').parents('.control-group:first').show();

            

            $('#jform_timer_timezone').parents('.control-group:first').show();

        }

        else {

            $('#timer_time_holder').show();

            $('#jform_time').parents('.control-group:first').hide();

            $('#jform_timer_timezone').parents('.control-group:first').hide();

        }; 

        

        try {

            $t.activeEl.attr('data-timertype', $(this).val());

        } 

        catch(e){

            

        }; 

        

    });

    

    $('[name="jform[timer_type]"]:checked').click();

    

    $('#jform_time_hour,#jform_time_minute,#jform_time_second').keyup(function(){

        try {
			/* 
			* Author: Viren Dave
			* Purpose: To resolve Counter issue
			*/
            var time=3600*parseInt($("#jform_time_hour").val());

			time+=60*parseInt($("#jform_time_minute").val());
			time+=parseInt($("#jform_time_second").val());
			$t.activeEl.attr("data-seconds",time);

			

			var date_future = new Date();

			var date_now = new Date();

			date_future.setHours(date_future.getHours()+parseInt($("#jform_time_hour").val()));

			date_future.setMinutes(date_future.getMinutes()+parseInt($("#jform_time_minute").val()));

			date_future.setSeconds(date_future.getSeconds()+parseInt($("#jform_time_second").val()));

			

			var diff_date =  date_future - date_now;



			var num_years = Math.floor(diff_date/31536000000);

			var num_months = Math.floor((diff_date % 31536000000)/2628000000);

			var days = Math.floor(((diff_date % 31536000000) % 2628000000)/86400000);
			
			var h = Math.floor(diff_date / 3600000) % 24;
			diff_date -= h * 3600000;
			
			var m = Math.floor(diff_date / 60000) % 60;
			
			diff_date -= m * 60000;		
			var s = diff_date % 60; 
			var seconds = s;
			var minutes = Math.floor(m);
			var hours = h;	

			var tempCount = 1;

			var CounteractiveEl = $t.activeEl;

			var tempElement = $($t.activeEl).find('.time-row-1');

			$(tempElement).find('span').each(function(i,e){

				

				if(tempCount == 1){ $(this).html(num_years); }

				if(tempCount == 2){ $(this).html(num_months); }

				if(tempCount == 3){ $(this).html(days); }

				if(tempCount == 4){ $(this).html(hours); }

				if(tempCount == 5){ $(this).html(minutes); }

				if(tempCount == 6){ $(this).html(seconds); }					

				tempCount++;

			});

			

			


        } 

        catch(e){

            if($t.deBugable)

                console.log(e);

        }; 

        

    })

    

    

    

}; 

MR_landing.prototype.createTimer = function(el){

    var $t = this;

    var $ = jQuery;

    var names = [$t.lang('COM_MARKETINGROCKET_YEAR'), $t.lang('COM_MARKETINGROCKET_MONTHS'), $t.lang('COM_MARKETINGROCKET_DAYS'), $t.lang('COM_MARKETINGROCKET_HOURS'), $t.lang('COM_MARKETINGROCKET_MINUTES'), $t.lang('COM_MARKETINGROCKET_SECONDS')];

    var el = el || $t.activeEl;

    el.html('');

    var div = $t.ce('div');

    $(div).css({

        'overflow' : 'visible',

        'vertical-align' : 'top',

        'font-size' : '100%',

        'position' : 'relative'

    });

    var count = $('#jform_bigest')[0].selectedIndex+3;

    for(var i = 3-$('#jform_bigest')[0].selectedIndex; i < names.length;i++){

       var d = $t.ce('div');

       $(d).css({

           position: 'absolute',

           overflow: 'visible',

           'background-color' : el.attr('data-background'),

           color : el.attr('data-color')

       }).addClass('time-row-1');

       

       var lineHolder = $t.ce('div');

       $(lineHolder).addClass('line').css('background-color', $('#jform_line_color').val()).appendTo(d);

       

       var d2 = $t.ce('div');

       $(d2).css({

           position: 'absolute',

           width : '100%',

           height : '100%',

           left : '0px',

           top : '0px',

           'text-align' : 'center',

           'font-family' : 'Arial',

           'white-space' : 'nowrap',

           'line-height' : '1em'

       });

      var sp = $t.ce('span');

      $(sp).html('00').appendTo(d2);

      $(d).append(d2).appendTo(div);



      var d = $t.ce('div');

       $(d).css({

           position: 'absolute',

           overflow: 'visible',

          'text-align' : 'center',

          'line-height' : '1.25em',

//          'text-transform' : 'uppercase'

       }).addClass('time-row-2');



       var sp = $t.ce('span');

       $(sp).html(names[i]).appendTo(d);

       $(d).appendTo(div);

    }; 

    el.append(div);

    

}; 

MR_landing.prototype.resizeTimer = function(el){

    var $t = this;

    var $ = jQuery;

    var el = el || $t.activeEl;



    var count = $('#jform_bigest')[0].selectedIndex+3;

    var w = el.attr('data-width');

    var h = (parseInt(w)/100)*13.33;

    var borderRadius = h/13;

    

    var margin = (w/count)/20;

    var elW = (w/count)-(margin*2);

    

    var textWidth = w/count;

    

    var secondRowH = h/4.30;

    var secondRowT = (h+5)-secondRowH;

    

    var firstRowH = secondRowT-(secondRowT/7.3);

    

    var fontSize = h/1.45;

    

    var secondRowFontSize = h/5.71;

    

    

    

    el.find(' > div').css({

        width : w,

        height : h

    });

    

    var currentLeft = margin;

    el.find('.time-row-1').each(function(){

        $(this).css({

            'left' : currentLeft,

            'width' : elW,

            'height' : firstRowH,

            'border-radius' : borderRadius,

            'font-size' : fontSize

        });

        currentLeft += elW+(margin*2);

    });

    

    var currentLeft = 0;

    el.find('.time-row-2').each(function(){

        $(this).css({

            'left' : currentLeft,

            'width' : textWidth,

            'height' : secondRowH,

            'top' : secondRowT,

            'font-size' : secondRowFontSize,

            'color' : $('#jform_text_color').val()

        });

        currentLeft += textWidth;

    });

}; 