intialize.push('progress');
colorpickersIds.push('#jform_progress_background_color');
MR_landing.prototype.progressDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'progress').addClass('progress');
    
    var div = $t.ce('div');
    $(div).addClass('bar').css('width', '50%').css('height', '20px').appendTo(box);
    
    $t.addAdminsBtns(box);
    
    $t.customSetting(box, 'fa-tasks', $t.lang('COM_MARKETINGROCKET_PROGRESS'));
    $t.progressFunctions(box);
    
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.progressFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('.MR_Custom').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpProgress();
        $t.modal('#progress-setting-template','show');
    });
};
MR_landing.prototype.beforeShowPopUpProgress = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#progress-setting-template').find('small:first').text('#'+$t.activeEl.attr('id'))
    var bar = $t.activeEl.find('.bar');
    var bg = bar.css('background-color');
    bg = $t.rgb2hex(bg);
    $('#jform_progress_background_color').val(bg).ColorPickerSetColor(bg);
    
    var width = bar.attr('style').match(/\d{1,2}%/);
    width = parseInt(width);
    $('#jform_progress_width').val(width);
    
    if($t.activeEl.hasClass('progress-striped')){
        $('#jform_progress_is_striped0').next().attr('class', 'btn active btn-success').prop('checked', true);
        $('#jform_progress_is_striped1').next().attr('class', 'btn').prop('checked', false);
    }
    else {
        $('#jform_progress_is_striped0').next().attr('class', 'btn').prop('checked', false);
        $('#jform_progress_is_striped1').next().attr('class', 'btn active btn-danger').prop('checked', true);
    }; 
    
    $('#jform_progress_text').val(bar.text());
};
MR_landing.prototype.progress = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#jform_progress_background_color').keyup(function(){
        $t.activeEl.find('.bar').css('background-color', $(this).val());
    });
    
    $('#jform_progress_is_striped0').click(function(){
        $t.activeEl.addClass('progress-striped');
    });
    $('#jform_progress_is_striped1').click(function(){
        $t.activeEl.removeClass('progress-striped');
    });
    $('#jform_progress_text').keyup(function(){
        $t.activeEl.find('.bar').text($(this).val());
    });
    $('#jform_progress_width').keyup(function(){
        $t.activeEl.find('.bar').css('width', $(this).val()+'%');
    }).blur(function(){$(this).keyup()});
};