intialize.push('pricatetable');

colorpickersIds.push('#jform_pricetable_background_0');
colorpickersIds.push('#jform_pricetable_background_1');
colorpickersIds.push('#jform_pricetable_background_2');
colorpickersIds.push('#jform_pricetable_background_3');
colorpickersIds.push('#jform_pricetable_background_4');
colorpickersIds.push('#jform_pricetable_background_5');

colorpickersIds.push('#jform_pricetable_color_0');
colorpickersIds.push('#jform_pricetable_color_1');
colorpickersIds.push('#jform_pricetable_color_2');
colorpickersIds.push('#jform_pricetable_color_3');
colorpickersIds.push('#jform_pricetable_color_4');
colorpickersIds.push('#jform_pricetable_color_5');
MR_landing.prototype.pricatetableDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'pricatetable').addClass('pricatetable complex-item').attr('data-template', '1');
    
    var tableHolder = $t.ce('div');
    $(tableHolder).addClass('pricetable-holder').appendTo(box).attr('id', $t.randString(6));
    
    if($t.tableTemplates[1] == undefined){
        $t.loadTableTemplate(1, box);
    }
    else {
        $t.createPricatetable(box);
    }; 
    
    $t.addAdminsBtns(box);
    
    $t.customSetting(box, 'fa-table', $t.lang('COM_MARKETINGROCKET_PRICETABLE_SETTINGS'));
    $t.pricatetableFunctions(box);
    
    $t.addToParent(box, parent, className);
    
     $t.writeCss();
     $(box).find(' > .el-button-holder .MR_Custom:first').click();
};
MR_landing.prototype.createPricatetable = function(parent){
    var $t = this;
    var $ = jQuery;
    $(parent).find('.pricetable-holder').html($t.tableTemplates[$(parent).data('template')].html).attr('class', 'pricetable-holder table'+$(parent).data('template'));
    
    $t.isChildAdded = true;
    $(parent).find('.add-element').each(function(){
        
        var type = $(this).data('addelement');

        $t.pricatetableCallItemFunction(this, type);

    });
    
    $t.isChildAdded = false;
    
    
    $t.writeCss();
    
    
};
MR_landing.prototype.pricatetableCallItemFunction = function(mainEl, type){
    var $t = this;
    var $ = jQuery;

    try {
        var el = $t[type + "Dropped"]($(mainEl).find('div'), '');
        if (type == 'icon') {
            $(el).find('span.fa').attr('data-size', 2).removeClass('fa-smile-o').addClass('fa-check');
        }
        ;
        return el;
    }
    catch (e){
        console.log(e);
        console.log(type);
    }
}
MR_landing.prototype.pricatetableFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    
    $(box).find(' > .el-button-holder .MR_Custom:first').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPricatetable();
        $t.modal('#pricetable-setting-template','show');
    })
    
};
MR_landing.prototype.beforeShowPricatetable = function(){
    var $t = this;
    var $ = jQuery;
    
    var selectedTemplate = $t.activeEl.data('template');
    var data = $t.tableTemplates[selectedTemplate].data;
    
    $('#pricetable-setting-template').find('small:first').text('#'+$t.activeEl.find('.pricetable-holder').attr('id'))
    var parentId = $t.activeEl.attr('id');
    var colors = $('#pricetable-setting-template .pricetable-color-input');
    for(var i = 0; i < colors.length;i++){
        if(data.colors[i] != undefined){
            var parent = colors.eq(i).parents('.control-group:first');
            parent.find('label').text(data.colors[i].title);
            parent.show();
            colors.eq(i).val('');
            try {
                var color = $t.inlineCss[parentId].pricetables[data.background[i].class]['color'];
                colors.eq(i).val(color).ColorPickerSetColor(color);
            }
            catch(e){
                
            }; 
            
        }
        else {
            colors.eq(i).parents('.control-group:first').hide();
        }; 
    }; 
    
    var colors = $('#pricetable-setting-template .pricetable-background-input');
    for(var i = 0; i < colors.length;i++){
        if(data.background[i] != undefined){
            var parent = colors.eq(i).parents('.control-group:first');
            parent.find('label').text('').text(data.background[i].title);
            parent.show();
            
            colors.eq(i).val('');
            
            try {
                var color = $t.inlineCss[parentId].pricetables[data.background[i].class]['background-color'];
                colors.eq(i).val(color).ColorPickerSetColor(color);
            }
            catch(e){
                
            }; 
            
        }
        else {
            colors.eq(i).parents('.control-group:first').hide();
        }; 
    }; 
    
    $('#jform_pricetable_column_count').val($t.activeEl.find('.repeatable:first').find('.copycell').length).chosen('destroy').chosen();
    $('#jform_pricetable_row_count').val($t.activeEl.find('.repeatable').length).chosen('destroy').chosen();
    
    $('#jform_pricetable_recomended_column').val($t.activeEl.find('tr.repeatable:first').find('td.recommended').index()+1).chosen('destroy').chosen();
    
    
    $('#jform_pricetable_templates').val($t.activeEl.data('template')).chosen('destroy').chosen();

    var type;
    if(typeof(type) == 'undefined'){
        var child = $(this).find('[aria-type]');
        if(child.length > 0)
            type = child.attr('aria-type');
        //alert(type);
    }
    
}; 
MR_landing.prototype.loadTableTemplate = function(template_id, parent, not_creaet){
    var $t = this;
    var $ = jQuery;
    
    if($t.tableTemplates[template_id] != undefined){
        if(not_creaet == undefined){
            $t.createPricatetable(parent);
            $t.activeEl.find(' > .el-button-holder .MR_Custom:first').click();
        }; 
        return;
    }; 
    
    $('#loading-holder').show();
    $.ajax({
        url : 'index.php?option=com_marketingrocket&task=landing.tabletemplate',
        data : {template : template_id},
        dataType : 'json'
    }).done(function(res){
        $t.tableTemplates[template_id] = res.data;
        if(not_creaet == undefined){
            $t.createPricatetable(parent);
        }
        else 
            $t.writeCss();
        try {
            $t.activeEl.find(' > .el-button-holder .MR_Custom:first').click();
        } 
        catch(e){
            
        }; 
        $('#loading-holder').hide();
    });
    
};

MR_landing.prototype.pricatetableCssOverride = function(css){
    var $t = this;
    var $ = jQuery;
    if(typeof(css) == 'string'){
        $('.pricatetable').each(function(){
            css += $t.tableTemplates[$(this).data('template')].css;
        });

        for(var i in $t.inlineCss){
            if($t.inlineCss[i] == undefined)
                continue;
            if($t.inlineCss[i].pricetables == undefined)
                continue;

            if(objectSize($t.inlineCss[i].pricetables) > 0){
                for(var className in $t.inlineCss[i].pricetables){
                    css += '#'+i+' '+className+' {\n';
                    for(var s in $t.inlineCss[i].pricetables[className]){
                        if($t.inlineCss[i].pricetables[className][s] == '')
                            continue;
                        css += s+' : '+$t.inlineCss[i].pricetables[className][s]+';\n';
                    }; 
                    css += '}\n';
                }; 
            }; 
        }; 
    }
    else {
        for(var i in $t.inlineCss){
            if($t.inlineCss[i] == undefined)
                continue;
            if($t.inlineCss[i].pricetables == undefined)
                continue;

            if(objectSize($t.inlineCss[i].pricetables) > 0){
                var obj = css[i];
                obj.pricetables = {};
                for(var className in $t.inlineCss[i].pricetables){
                    obj.pricetables[className] = {};
                    for(var s in $t.inlineCss[i].pricetables[className]){
                        if($t.inlineCss[i].pricetables[className][s] == '')
                            continue;
                        obj.pricetables[className][s] = $t.inlineCss[i].pricetables[className][s];
                    }; 
                }; 
                css[i] = obj;
            }; 
        }; 
    }; 
    
    
    
    
    return css;
}; 
MR_landing.prototype.pricatetable = function(){
    var $t = this;
    var $ = jQuery;
    $t.tableTemplates = {};
    
    $t.cssOverRides.push('pricatetableCssOverride');
    
    $('#jform_pricetable_column_count').change(function(){
        var tr = $t.activeEl.find('tr.repeatable:first');
        var tdLength = tr.find('td.copycell').length;
        var val = parseInt($(this).val());
        if(tdLength > val){
//            val = val+1;
            
            do {
                $t.activeEl.find('tr').each(function(){
                    $(this).find('.copycell').eq(val).remove();
                });
                
                
            }
            while($t.activeEl.find('tr:first').find('.copycell').eq(val).length > 0);
            
        }
        else {
            var mustAdd = val-tdLength;
            var template = $($t.tableTemplates[$t.activeEl.data('template')].html);
            var templateCopyRow = template.find('tr');
            
            $t.isChildAdded = true;
            $t.activeEl.find('tr').each(function(index){
                for(var i = 0;i < mustAdd;i++){
                    var last = $(this).find('.copycell:last');
                    var cl = last.clone();
                    cl.removeClass('recommended').insertAfter(last);
                    cl.find('.add-element').each(function(){
                        $(this).find('> div').html('');

                        var type = $(this).data('addelement');
                        $t.pricatetableCallItemFunction(this, type);

                    });
                }; 
            });
            $t.isChildAdded = false;
        }; 
    });
    
    $('#jform_pricetable_recomended_column').change(function(){
        var val = parseInt($(this).val())-1;
        $t.activeEl.find('.recommended').removeClass('recommended');
        if(val < 0)
            return true;
        $t.activeEl.find('tr').each(function(index){
            $(this).find('.copycell').eq(val).addClass('recommended');
        });
    });
    
    $('#jform_pricetable_row_count').change(function(){
        var trLength = $t.activeEl.find('tr.repeatable').length;
        var val = parseInt($(this).val());
        
        if(trLength > val){
            while($t.activeEl.find('tr.repeatable').eq(val).length > 0){
                $t.activeEl.find('tr.repeatable').eq(val).remove();
            }; 
        } 
        else {
            var mustAdd = val-trLength;
            var template = $t.activeEl.find('tr.repeatable:first');
            for(var i = 0;i < mustAdd;i++){
                var tr = template.clone();
                
                tr.insertAfter($t.activeEl.find('tr.repeatable:last'));
                
                tr.find('.add-element').each(function(){
                    $(this).find('> div').html('');

                    var type = $(this).data('addelement');
                    $t.pricatetableCallItemFunction(this, type);
                });
                
                
            }; 
        }; 
        
    });
    
    $('#pricetable-setting-template .pricetable-background-input,#pricetable-setting-template .pricetable-color-input').keyup(function(){
        var id = $(this).attr('id');
        var index = id.split('_');
        index = index.pop();
        
        var selectedTemplate = $t.activeEl.data('template');
        var data = $t.tableTemplates[selectedTemplate].data;
        
        var aElId = $t.activeEl.attr('id');
        
        var type = 'color';
        var dataType = 'colors';
        if($(this).hasClass('background-color')){
            type = 'background-color';
            dataType = 'background';
        }; 
        
        if(data[dataType][index] != undefined){
            if($t.inlineCss[aElId] == undefined){
                $t.createCssObj(aElId);
            }; 
            if($t.inlineCss[aElId].pricetables == undefined)
                $t.inlineCss[aElId].pricetables = {};
            
            var className = data[dataType][index].class;
            
            if($t.inlineCss[aElId].pricetables[className] == undefined)
                $t.inlineCss[aElId].pricetables[className] = {};
            
            $t.inlineCss[aElId].pricetables[className][type] = $(this).val();
            
            $t.writeCss();
            
                
        } 
        else {
            alert(index);
        }; 
    });
    
    $('#jform_pricetable_templates').change(function(){
        $t.activeEl.attr('data-template', $(this).val()).data('template', $(this).val());
        $t.loadTableTemplate($(this).val(),$t.activeEl);
        
    });
    
    
    $('.pricatetable').each(function(){
        $t.loadTableTemplate($(this).data('template'), '', true);
    });
    
    
};
