var intialize = [];
var colorpickersIds = [];
var MR_landing = function(url, intialize) {
    var $t = this;
    var $ = jQuery;
    $t.intialize = intialize || [];
    $t.cssOverRides = [];
    $t.deBugable = true;
    $t.locationOfJoomla = url;
    $t.joomlaUrl = '';
    $t.activeEl = null;
    $t.canDrop = true;
    $t.inlineCss = {};
    $t.mainElements = '#MarketingRocketMain,#MarketingRocketSide,#MarketingRocketSide_left,#MarketingRocketSide_right';
    $t.dropObj = {
        hoverClass: "dropable-hover",
        drop: function(event, ui) {
            $t.dropFunction(event, ui, this)
        },
        over: function(event, ui) {
            $t.overFunction(event, ui, this)
        },
        out: function(event, ui) {
            $t.outFunction(event, ui, this)
        },
    };
    $t.editorInit = false;
    $t.editorCounter = 0;
    $t.isModalResizeDone = 0;
    $t.history = [];
    $t.dontAddToHistory = false;
    $t.isChildAdded = false;
    $t.reservedId = false;
    $t.isReplace = false;
    $t.isFillPopUpCss = false;
};
MR_landing.prototype.catchElements = function() {
    var $t = this;
    var $ = jQuery;
    $('#MarketingRocket, #MR_Modal_View, #MR_Exit_View_Holder').find('.row-fluid').each(function() {
        $(this).find('.MR_Admin').attr('data-original-title', COM_MARKETINGROCKET_SETTING);
        $(this).find('.MR_remove').attr('data-original-title', COM_MARKETINGROCKET_REMOVE);
    })
    $t.adminsBtnsFuntions($('#MarketingRocket').find('div:first'));
    $t.adminsBtnsFuntions($('#MR_Modal_View').find('div:first'));
    $('.row-fluid,.container-fluid,.added-element').each(function() {
        var as = $(this).find(' > a.MR_Admin, > a.MR_remove, > a.MR_Custom, > a.MR_SORT_UP , > a.MR_SORT_DOWN, > a.MR_SORT_LEFT, > a.MR_SORT_RIGHT, > a.MR_duplicate');
        if (as.length == 0)
            return true;
        var div = $t.ce('div');
        $(div).addClass('el-button-holder').appendTo($(this));
        as.appendTo(div);
    });
    if ($('#MR_form_submit').find('.el-button-holder').length == 0) {
        var div = $t.ce('div');
        $(div).addClass('el-button-holder').appendTo($('#MR_form_submit'));
        $('#MR_form_submit').addClass('added-element');
        $('#MR_form_submit').find('.MR_Admin').appendTo(div);
    }
    $('.imagebox').each(function() {
        var image = $(this).find('.inside-item');
        if (image.length > 0)
            return true;
        $(this).find('img').addClass('inside-item');
        $t.customSetting(this, 'fa-gear', $t.lang('COM_MARKETINGROCKET_IMAGEBOX_STYLE_SETTINGS'));
    });
    $('#MarketingRocket [aria-type], #MR_Modal_View [aria-type], #MR_Exit_View_Holder [aria-type],.row-fluid').each(function() {
        var type = $(this).attr('aria-type');
        $t.adminsBtnsFuntions(this);
        if ($(this).hasClass('droppable')) {
            $(this).find('> a.MR_remove').remove();
        };
        if ($t[type + 'Functions'] != undefined)
            $t[type + 'Functions'](this);
        $(this).find('.hasTooltip').tooltip({
            container: 'body'
        });
    });
    $t.adminsBtnsFuntions($('#MarketingRocketMain').find('.container-fluid'));
    $t.sortBtnFunctions($('#MarketingRocketMain').find('.container-fluid'));
    $t.adminsBtnsFuntions($('#MarketingRocketSide').find('.container-fluid'));
    $t.sortBtnFunctions($('#MarketingRocketSide').find('.container-fluid'));
    $t.adminsBtnsFuntions($('#MarketingRocketSide_left').find('.container-fluid'));
    $t.sortBtnFunctions($('#MarketingRocketSide_left').find('.container-fluid'));
    $t.adminsBtnsFuntions($('#MarketingRocketSide_right').find('.container-fluid'));
    $t.sortBtnFunctions($('#MarketingRocketSide_right').find('.container-fluid'));
    $t.adminsBtnsFuntions($('#MR_Modal_View').find('.container-fluid'));
    $t.sortBtnFunctions($('#MR_Modal_View').find('.container-fluid'));
    $t.adminsBtnsFuntions($('#MR_Exit_View_Holder').find('.container-fluid'));
    $t.sortBtnFunctions($('#MR_Exit_View_Holder').find('.container-fluid'));
    $(".droppable").droppable($t.dropObj);
    $('.added-element[aria-type]').each(function() {
        $t.makeDraggable(this);
    });
    $('.ui-resizable').each(function() {
        if ($(this).is(':visible')) {
            $(this).find('.ui-resizable-handle').remove();
            $t.makeResizable(this);
        };
    })
    $('.button-container a').click(function() {
        var curClass = $t.activeEl.attr('aria-mainclass');
        $t.activeEl.attr('aria-mainclass', $(this).attr('class'));
        if ($(this).data('type') == 'text') {
            $t.activeEl.find(' > i').attr('class', $(this).find('i:first').attr('class'));
        } else {
            $t.activeEl.find('img').attr('src', $(this).find('img').attr('src'));
        }
        $t.inlineCss[$t.activeEl.attr('id')] = undefined;
        $t.writeCss();
        $t.buttonFillPopCss();
        $t.saveButtonCss();
        $t.activeEl.removeClass(curClass).addClass($(this).attr('class'));
    });
    $('#MR-Save-Button-CSS').click(function() {
        $t.saveButtonCss();
    });
    $('.input-prepend,.input-append').find('.modal').each(function() {
        var rel = $(this).attr('rel');
        rel = rel.substr(0, rel.length - 1);
        var prevId = $(this).prev().attr('id');
        rel += ',onClose:function(){jQuery("#' + prevId + '").blur();}}';
        $(this).attr('rel', rel);
    });
    $('[data-slider]').each(function() {
        $(this).slider({
            max: (parseInt($(this).attr('data-max')) || 100),
            min: (parseInt($(this).attr('data-min')) || -100),
            step: (parseInt($(this).attr('data-step')) || 1),
            value: (parseInt($(this).attr('data-value')) || 0),
            slide: function(event, ui) {
                $(this).parent().css({
                    height: 'auto',
                    overflow: 'visible'
                });
                $(this).css({
                    overflow: 'visible',
                    margin: '0px'
                });
                $(this).parents('.control-group:first').find('input[data-boxshaow]').val(ui.value);
                if ($(this).attr('id') == 'icon_size' || $(this).attr('id') == 'timer_width' || $(this).attr('id') == 'button_width' || $(this).attr('id') == 'jform_exit_popup_size_slider')
                    $(this).parents('.control-group:first').find('input[data-boxshaow]').keyup();
            },
            change: function(event, ui) {
                if ($(this).attr('id') != 'icon_size' && $(this).attr('id') != 'timer_width' && $(this).attr('id') != 'button_width' && $(this).attr('id') != 'jform_exit_popup_size_slider')
                    $t.setBoxShadow($(this).parents('.accordion-body:first'));
            }
        });
        $(this).parents('.control-group:first').find('input[data-boxshaow]').keyup(function() {
            if ($t.deBugable)
                console.log($(this).parents('.control-group:first').find('.ui-slider:first').attr('id') + ' : ' + $(this).val());
            $(this).parents('.control-group:first').find('.ui-slider:first').slider('value', $(this).val());
        });
    });
    $('[data-boxshaow="color"]').keyup(function() {
        $t.setBoxShadow($(this).parents('.accordion-body:first'));
    });
    $('#jform_background_color,#jform_color,#jform_border_color,#jform_button_color,' + '#jform_button_icon_color,#jform_button_color_hover,#jform_button_icon_color_hover,#jform_button_border_color,' + '#jform_button_border_color_hover,[data-boxshaow="color"],#list_item_color,' + '#jform_button_background_color,#jform_button_background_color_hover, #jform_container_background_color,' + '#jform_container_border_color,#list_item_color,#jform_icon_color, #jform_icon_hover_color , #jform_timer_background, ' + '#jform_timer_color, #jform_line_color, #jform_text_color' + ((colorpickersIds.length > 0) ? ',' + colorpickersIds.join(',') : '')).each(function() {
        var f = function(hsb, hex, rgb, opacity) {
            if (opacity == 100) {
                arguments.callee.i.val('#' + hex).keyup();
            } else {
                var s = 'rgba(' + rgb.r + ',' + rgb.g + ',' + rgb.b + ',' + (opacity / 100) + ')';
                arguments.callee.i.val(s).keyup();
            };
        };
        f.i = $(this);
        $(this).ColorPicker({
            'onChange': f
        })
    });
    $('.gradient').each(function() {
        var el = $(this);
        el.ClassyGradient({
            onChange: function(stringGradient, cssGradient) {
                el.parent().find('textarea').val(cssGradient.replace('background: ', '')).keyup();
            }
        });
    })
    $('.gradient-orientation').change(function() {
        $(this).parent().find('.gradient').data('ClassyGradient').setOrientation($(this).val());
    })
    $('.clear-gradient').click(function() {
        $(this).parent().find('textarea').val('').keyup();
    });
    $('[aria-type="form"]').each(function() {
        $(this).find('[aria-type="button"]').attr('onclick', 'document.getElementById(\'front-landing-form\').submit()');
    })
    $('[class*="span-"]').each(function() {
        var c = $(this).attr('class');
        c = c.replace(/span-(\d{1,2})/, "span$1");
        c.replace(/col-md--(\d{1,2})/, "col-md-$1");
        $(this).attr('class', c);
    })
    $('#jform_button_change_item_type,#jform_change_item_type').change(function() {
        if ($t.isFillPopUpCss) {
            return true;
        };
        var el = $t.activeEl;
        var id = el.attr('id');
        $t.reservedId = id;
        $t.isReplace = true;
        var rowClass = el.attr('class');
        var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
        if (res && res[3])
            res = parseInt(res[3]);
        else
            res = 12;
        var val = $(this).val() + 'Dropped';
        $t[val](el, res);
        $t.isReplace = $t.reservedId = false;
        $t.activeEl.find('.MR_Admin').click();
    });
    $('.added-element, #MR-workaround .row-fluid, #MR-workaround .container,#MR-workaround .container-fluid').each(function() {
        var id = $(this).attr('id');
        if (id == undefined || id == '')
            $(this).attr('id', $t.randString(6))
    });
    $('#MR-workaround .added-element').each(function() {
        var type = $(this).attr('aria-type');
        if ($(this).find('.drag-point').length == 0 && ($('.elemnts[aria-type="' + type + '"]:first').length > 0 || type == 'box-container')) {
            $t.createDragPoint(this);
            $(this).addClass('cant_drag');
        } else if ($(this).find('.drag-point').length > 0) {
            $t.dragPointFunctions($(this).find('.drag-point:first'));
        }
        if ($(this).find('.element-type-holder').length > 0)
            return true;
        var div = $t.ce('div');
        if ($('.elemnts[aria-type="' + type + '"]:first').length > 0) {
            type = $.trim($('.elemnts[aria-type="' + type + '"]').text())
            $(div).addClass('element-type-holder').html(type).prependTo(this);
        };
    });
    if ($('#MR_Modal_View_Modal').find('.modal-header').length == 0) {
        $('#MR_Modal_View_Modal').prepend('<div class="container-fluid haschild"><div class="row-fluid haschild"><div class="modal-header added-element">' + '<button aria-hidden="true" data-dismiss="modal" class="close" type="button">  </button><input class="h3Like inputlike replace h3" placeholder="Enter Title Here..." aria-replace="h3">' + '</div></div><a class="MR_Admin hasTooltip btn-mini btn btn-primary" data-original-title="Item Settings"><i class="fa fa-gear"></i></a></div>');
    };
    $('#MR_Modal_View_Modal').find('.modal-header').parents('.container-fluid:first').remove();
    $('[aria-type="button"]').addClass('MR-button');
    $('.listbox').find('span').attr('contenteditable', 'true');
    $('article[aria-type="articlebox"]').find('i.fa-code').each(function() {
        $(this).parent().remove();
    })
};
MR_landing.prototype.run = function() {
    var $t = this;
    var $ = jQuery;
    $t.loadInlineCss();
    $t.fixImageSrcOnRun('#MR-workaround');
    var style = $t.ce('style');
    $(style).attr('id', 'inlineCss').appendTo('head');
    $($t.intialize).each(function() {
        $t[this]();
    });
    try {
        $t.inlineCss.MR_form_submit.styles.display = '';
    } catch (e) {}
    $t.writeCss();
    $t.applyCss();
    $('.elemnts[aria-type]').draggable({
        revert: "invalid",
        appendTo: "body",
        helper: "clone",
        distance: 30,
        start: function(event, ui) {
            $('.droppable').addClass('active');
            $t.lastParent = ui.helper.parents('.droppable:first');
            $('[aria-type="videobox"]').each(function() {
                $(this).append('<div class="over-holder" style="width: 100%; height: 100%; position: absolute; top: 0px; left: 0px; background: none repeat scroll 0% 0% rgba(255, 255, 255, 0);"></div>');
            })
        },
        stop: function(event, ui) {
            $('.droppable,.row-fluid').removeClass('active');
            $('.over-holder').remove();
        }
    });
    $('#jform_background_color_transparent,#jform_button_background_color_transparent,#jform_button_background_color_transparent_hover,#jform_container_background_color_transparent').change(function() {
        if ($(this).is(':checked')) {
            $(this).parents('.control-group').prev().find('input[type="text"]').attr('disabled', true)
        } else {
            $(this).parents('.control-group').prev().find('input[type="text"]').attr('disabled', false)
        };
    });
    $('.sidebar-close').click(function() {
        $(this).toggleClass('open');
        $('#MR-SideBar').toggleClass('open');
    });
    $t.buttonBoxSetting = $('#buttonbox-setting-template').clone();
    $t.buttonBoxSetting.find('select').show().next().remove();
    $($t.buttonBoxSetting).show();
    $('#buttonbox-setting-template').remove();
    $t.catchElements();
    $(document).on('mouseenter', '.MR_Admin, .MR_remove, .MR_SORT_UP, .MR_SORT_DOWN, .MR_duplicate', function() {
        if ($(this).parent().parent().hasClass('container-fluid') && $(this).parent().parent().parent().hasClass('container-fluid')) {
            $(this).parent().parent().parent().addClass('hovered');
        } else
            $(this).parent().parent().addClass('hovered');
    }).on('mouseleave', '.MR_Admin, .MR_remove, .MR_SORT_UP, .MR_SORT_DOWN, .MR_duplicate', function() {
        if ($(this).parent().parent().hasClass('container-fluid') && $(this).parent().parent().parent().hasClass('container-fluid')) {
            $(this).parent().parent().parent().removeClass('hovered');
        } else
            $(this).parent().parent().removeClass('hovered');
    });
    $('#background,#border,#box_shadow,#button_background,#button_boders,#button_box_shadow').each(function() {
        var boxSwitch = $('.onoffswitch:first').clone();
        boxSwitch.find('input').attr('id', $(this).attr('id') + '-switch').attr('data-id', $(this).attr('id'));
        boxSwitch.find('label').attr('for', $(this).attr('id') + '-switch');
        boxSwitch.find('input').change(function() {
            var id = $t.activeEl.attr('id');
            var target = $(this).parents('.accordion-group:first').find('.accordion-body');
            var targetId = target.attr('id');
            if (!$(this).is(':checked')) {
                var div = $t.ce('div');
                $(div).addClass('slide-shadow').appendTo(target);
                if ($t.inlineCss[id] != undefined) {
                    if ($t.inlineCss[id].temp == undefined) {
                        $t.inlineCss[id].temp = {};
                    };
                    $t.inlineCss[id].temp[targetId] = {};
                    target.find('input[type="text"],textarea,select').each(function() {
                        $t.inlineCss[id].temp[targetId][$(this).attr('id')] = $(this).val();
                    });
                };
                target.find('input[type="text"],textarea,select').val('').blur().change();
                if (target.attr('id') == 'background' || target.attr('id') == 'button_background') {
                    target.find('input[type="checkbox"]').prop('checked', false).click();
                } else if (target.attr('id') == 'border') {
                    $('#jform_border_radius').val('0px').blur();
                } else if (target.attr('id') == 'button_boders') {
                    $('#jform_button_border_radius').val('0px').blur();
                } else if (target.attr('id') == 'box_shadow' || target.attr('id') == 'button_box_shadow') {
                    target.find('input.span2').val('0');
                };
            } else {
                target.find('.slide-shadow').remove();
                if ($t.inlineCss[id] != undefined && $t.inlineCss[id].temp != undefined && $t.inlineCss[id].temp[targetId] != undefined) {
                    target.find('input[type="text"],textarea,select').each(function() {
                        if ($t.inlineCss[id].temp[targetId][$(this).attr('id')] != undefined)
                            $(this).val($t.inlineCss[id].temp[targetId][$(this).attr('id')]).blur();
                    });
                };
                try {
                    $t.inlineCss[id].temp[targetId] = undefined;
                } catch (e) {};
                target.find('input[type="checkbox"]').prop('checked', false).change();
            };
        })
        var div = $t.ce('div');
        $(div).addClass('slide-toggle-holders').append(boxSwitch);
        $(this).prev().append(div);
    });
    $('#jform_animation').change(function() {
        $t.activeEl.removeClass('animated');
        if ($t.activeEl.data('animation') != '') {
            $t.activeEl.removeClass($t.activeEl.data('animation'));
        };
        if ($(this).val() !== '')
            $t.activeEl.addClass($(this).val()).addClass('animated').attr('data-animation', $(this).val()).data('animation', $(this).val());
        else
            $t.activeEl.removeAttr('data-animation');
    });
    $('.ui-droppable-disabled').each(function() {
        try {
            $(this).droppable("disable");
        } catch (e) {}
    })
};
MR_landing.prototype.loadInlineCss = function() {
    var $t = this;
    var $ = jQuery;
    try {
        $t.inlineCss = JSON.parse($('#jform_hidden_css').val());
    } catch (e) {
        $t.inlineCss = {};
    };
};
MR_landing.prototype.fixImageSrcOnRun = function(parent, fixCss) {
    var $t = this;
    var $ = jQuery;
    if ($t.locationOfJoomla != '' && landingId == 0) {
        $(parent).find('img').each(function() {
            $(this).attr('src', $t.fixImageSrc($(this).attr('src')));
        });
        $t.inlineCss = $t.fixCssImgSrc($t.inlineCss);
        $t.validateCss();
    };
    return parent;
};
MR_landing.prototype.fixCssImgSrc = function(parent) {
    var $t = this;
    var $ = jQuery;
    for (var i in parent) {
        try {
            var bakgroundImage = parent[i].styles['background-image'];
            if (bakgroundImage != undefined && bakgroundImage != '') {
                bakgroundImage = bakgroundImage.replace('url("', '');
                bakgroundImage = bakgroundImage.replace('")', '');
                bakgroundImage = 'url("' + $t.fixImageSrc(bakgroundImage) + '")';
                parent[i].styles['background-image'] = bakgroundImage;
            };
        } catch (e) {
            if ($t.debugable)
                console.log(e);
        };
        try {
            var bakgroundImage = parent[i].hover['background-image'];
            if (bakgroundImage != undefined && bakgroundImage != '') {
                bakgroundImage = bakgroundImage.replace('url("', '');
                bakgroundImage = bakgroundImage.replace('")', '');
                bakgroundImage = 'url("' + $t.fixImageSrc(bakgroundImage) + '")';
                parent[i].hover['background-image'] = bakgroundImage;
            };
        } catch (e) {
            if ($t.debugable)
                console.log(e);
        };
    };
    return parent;
};
MR_landing.prototype.simpleboxDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    var id = $t.randString(6);
    $(box).attr('aria-type', 'simplebox').attr('id', id);
    var div = $t.ce('div');
    $(div).addClass('simple-box-headline').html('<h2>....</h2>');
    $(box).append(div);
    var div = $t.ce('div');
    $(div).addClass('simple-box-subheadline').html('<small>...</small>');
    $(box).append(div);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-file-text ', COM_MARKETINGROCKET_SIMPLEBOX_EDIT_TEXT);
    $t.simpleboxFunctions(box);
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.simpleboxFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    var content = '';
    var saveFunction = function() {
        $t.saveCustomSimpleBox();
    };
    var beforeShowFunction = function() {
        $t.beforeShowPopUpSimpleBox();
    };
    $t.customSettingFunctions(box, COM_MARKETINGROCKET_SIMPLEBOX_EDIT_TEXT, content, saveFunction, beforeShowFunction)
};
MR_landing.prototype.beforeShowPopUpSimpleBox = function() {
    var $t = this;
    var $ = jQuery;
    var fTextBox = $t.ce('textarea');
    $(fTextBox).attr('id', $t.randString()).css('width', '97%').appendTo($('#MR-CM').find('.modal-body:first'));
    $t.firstSimpleBoxTextAreaId = $(fTextBox);
    var tTextBox = $t.ce('textarea');
    $(tTextBox).attr('id', $t.randString()).css('width', '97%').appendTo($('#MR-CM').find('.modal-body:first'));
    $t.secondSimpleBoxTextAreaId = $(tTextBox);
    $t.firstSimpleBoxTextAreaId.val($t.activeEl.find('.simple-box-headline').html());
    $t.secondSimpleBoxTextAreaId.val($t.activeEl.find('.simple-box-subheadline').html());
    setTimeout(function() {
        $($t.firstSimpleBoxTextAreaId).cleditor({
            controls: "bold italic underline strikethrough | font size " + "style | color highlight removeformat | " + "alignleft center alignright justify | undo redo "
        });
        $($t.secondSimpleBoxTextAreaId).cleditor({
            controls: "bold italic underline strikethrough | font size " + "style | color highlight removeformat | " + "alignleft center alignright justify | undo redo "
        });
    }, 300);
    $('#MR-DONE').text('Save')
};
MR_landing.prototype.saveCustomSimpleBox = function() {
    var $t = this;
    var $ = jQuery;
    $t.activeEl.find('.simple-box-headline').html($t.firstSimpleBoxTextAreaId.val());
    $t.activeEl.find('.simple-box-subheadline').html($t.secondSimpleBoxTextAreaId.val());
    $t.modal('#MR-CM', 'hide');
};
MR_landing.prototype.createBox = function(elType, className) {
    var $t = this;
    var $ = jQuery;
    if (elType)
        var box = $t.ce(elType);
    else
        var box = $t.ce('div');
    if (isInt(className))
        $(box).addClass('col-md-' + className + ' span' + className + ' simplebox added-element');
    else
        $(box).addClass('simplebox added-element ' + className);
    return box;
};
MR_landing.prototype.articleboxDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('article', className);
    $(box).attr('aria-type', 'articlebox');
    $t.addAdminsBtns(box);
    var div = $t.ce('div');
    $(div).addClass('content first-time code-holder').attr('contenteditable', true);
    $(box).append(div);
    $t.addToParent(box, parent, className);
    $t.articleboxFunctions(box);
    return box;
};
MR_landing.prototype.articleboxFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    var content = "";
    var ed = $(box).find('.content:first').attr('contenteditable', 'true').ckeditor({
        customConfig: configUrl
    }).editor;
    ed.on('instanceReady', function(ev) {
        var editor = ev.editor;
        editor.setReadOnly(false);
    });
    $(box).find('.content:first').attr('data-editor', ed.name).dblclick(function() {
        $(this).focus();
    }).focus(function() {
        if ($(this).hasClass('first-time')) {
            $(this).removeClass('first-time');
        };
        $(this).parents('.ui-draggable').draggable("disable");
        $(this).parent().find('.element-type-holder').hide();
    }).blur(function() {
        $(this).parents('.ui-draggable').draggable("enable");
        $(this).parent().find('.element-type-holder').removeAttr('style');
    });
    $(box).find('a.MR_Custom').click(function() {
        $(box).find('.content:first').removeClass('first-time');
        $t.activeEl = $(box);
        $t.beforeShowPopUpCodebox();
        $t.modal('#code_editor_modal', 'show');
    })
};
MR_landing.prototype.listboxDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.ce('div');
    $(box).attr('aria-type', 'listbox');
    $(box).addClass('col-md-' + className + ' span' + className + ' listbox added-element');
    var ul = $t.ce('ul');
    $(ul).addClass('iconed-list list_type1');
    var li = $t.ce('li');
    var i = $t.ce('i');
    $(i).addClass('fa fa-2x pull-left').appendTo(li);
    var span = $t.ce('span');
    $(span).attr('contenteditable', 'true');
    var div = $t.ce('div');
    $(div).addClass('clearfix');
    $(li).append(span);
    $(li).append(div);
    $(ul).append(li);
    $(box).append(ul);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-list', COM_MARKETINGROCKET_LIST_SETTING);
    $t.listboxFunctions(box);
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.listboxFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('.MR_Custom').click(function() {
        $t.activeEl = box;
        $t.beforeShowPopUpListBox();
        $t.modal('#listbox-template', 'show');
    })
};
MR_landing.prototype.saveCustomPopUpListBox = function(element) {
    var $t = this;
    var $ = jQuery;
    var id = element.attr('id');
    if (id == 'list_number_of_item') {
        var number = parseInt($('#list_number_of_item').val());
        var currentNumber = $($t.activeEl).find('ul li').length;
        if (number < currentNumber) {
            while (number < $($t.activeEl).find('ul li').length) {
                $($t.activeEl).find('ul li:last').remove();
            };
        } else if (number > currentNumber) {
            while (number > $($t.activeEl).find('li').length) {
                var li = $($t.activeEl).find('ul li:last').clone();
                $($t.activeEl).find('ul').append(li);
            };
        };
    } else if (id == 'list_item_color') {
        $($t.activeEl).find('ul li i').css('color', $('#list_item_color').val());
    } else {
        $($t.activeEl).find('ul').attr('class', 'iconed-list ' + $('input[type="radio"][name="list_type"]:checked').val());
    };
};
MR_landing.prototype.beforeShowPopUpListBox = function() {
    var $t = this;
    var $ = jQuery;
    var currentNumber = $($t.activeEl).find('ul li').length;
    $('#list_number_of_item').val(currentNumber).unbind('change').change(function() {
        $t.saveCustomPopUpListBox($(this));
    });
    var cssClass = $($t.activeEl).find('ul').attr('class');
    cssClass = cssClass.split(' ');
    $('#' + cssClass[1]).prop('checked', true);
    $('input[name="list_type"]').unbind('click').click(function() {
        $t.saveCustomPopUpListBox($(this));
    });
    var color = $($t.activeEl).find('ul li').find('i:first').css('color');
    $t.setColor(color, '#list_item_color');
    $('#list_item_color').unbind('keyup').keyup(function() {
        $t.saveCustomPopUpListBox($(this));
    });
};
MR_landing.prototype.customSetting = function(el, icon, title) {
    var $t = this;
    var $ = jQuery;
    var a = $t.ce('a');
    var i = $t.ce('i');
    $(i).addClass('fa ' + icon).appendTo(a);
    $(a).attr('data-original-title', title).addClass('MR_Custom hasTooltip  btn-mini btn')
    $(a).insertAfter($(el).find('> .el-button-holder .MR_SORT_RIGHT'));
    $(a).tooltip({
        container: 'body'
    });
};
MR_landing.prototype.customSettingFunctions = function(el, title, content, saveFuntion, beforeShowFunction, a) {
    var $t = this;
    var $ = jQuery;
    if (a != undefined)
        var clickable = a;
    else
        var clickable = $(el).find('a.MR_Custom:first');
    clickable.click(function() {
        $t.activeEl = $(this).parent();
        $t.showCustomPopup(title, content, saveFuntion, beforeShowFunction);
    });
};
MR_landing.prototype.showCustomPopup = function(title, content, saveFuntion, beforeShowFunction) {
    var $t = this;
    var $ = jQuery;
    $('#MR-CM').find('h3').html(title);
    if (typeOf(content) == 'string')
        $('#MR-CM').find('.modal-body:first').html(content);
    else
        $('#MR-CM').find('.modal-body:first').html('').append(content);
    $('#MR-DONE').unbind('click').click(saveFuntion);
    $('#MR-CM').find('div.main:first').show();
    $('#MR-CM').find('div.article:first').hide();
    beforeShowFunction();
    $t.modal('#MR-CM', 'show');
};
MR_landing.prototype.dropFunction = function(event, ui, el) {
    var $t = this;
    var $ = jQuery;
    if ($(ui.draggable).hasClass('row-fluid')) {
        return false;
    };
    $('#MarketingRocketMain').removeClass('preview');
    if ($t.canDrop) {
        setTimeout(function() {
            $t.canDrop = true;
        }, 500);
        $t.canDrop = false;
    } else
        return false;
    if ($(el).hasClass('temp-div')) {
        $t.activeEl = $(el).parent();
        el = $t.activeEl;
    } else
        $t.activeEl = $(el);
    var className = 12;
    if ($t.history.length > 3)
        $t.history.pop();
    if ($(ui.draggable).hasClass('added-element')) {
        if ($t.dontAddToHistory === false) {
            var obj = {
                type: 'drop',
                lastParent: $t.lastParent.parents('.container-fluid.haschild:last').clone(),
                newParent: $t.activeEl.parents('.container-fluid.haschild:last').clone(),
                parentIndex: $t.lastParent.parents('.container-fluid.haschild:last').index(),
                lastParentParent: $t.lastParent.parents('.container-fluid.haschild:last').parent(),
                element: ui.draggable
            };
            $t.history.unshift(obj);
            $('[onclick="Joomla.submitbutton(\'landing.undomove\')"]').removeClass('disabled');
        };
    };
    className = $t.getChildWithSize($t.activeEl);
    if (className == 0 && ($($t.activeEl).find('.row-fluid').length == 0 || $($t.activeEl).parent().attr('aria-type') == 'box-container'))
        className = 12;
    else if (className == 0 && $($t.activeEl).find('.row-fluid').length > 0) {
        className = 12;
        $($t.activeEl).find('.row-fluid:last .added-element').each(function() {
            var rowClass = $(this).attr('class');
            var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
            if (res && res[3])
                res = parseInt(res[3]);
            else
                res = 12;
            className = className - res;
        })
        if (className == 0 || className < 0)
            className = 12;
    };
    if (!$(ui.draggable).hasClass('added-element')) {
        var type = $(ui.draggable).attr('aria-type');
        type = type + "Dropped";
        try {
            $t[type](el, className);
        } catch (e) {
            console.log(e);
            if ($t[type] == undefined)
                console.log(type + ' Module Is Not Imported');
        };
        var obj = {
            type: 'first_drop',
            lastParent: false,
            element: el
        };
        $t.history.unshift(obj);
        $('[onclick="Joomla.submitbutton(\'landing.undomove\')"]').removeClass('disabled');
    } else {
        var rowClass = $(ui.draggable).attr('class');
        try {
            var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
            res = parseInt(res[3]);
        } catch (e) {
            if ($t.deBugable) {
                console.log(e);
            };
            return;
        };
        $(ui.draggable).removeClass('col-md-' + res).removeClass('span' + res);
        $(ui.draggable).addClass('col-md-' + className).addClass('span' + className);
        $t.addToParent(ui.draggable, $t.activeEl, className);
        if ($t.lastParent[0] != $t.activeEl) {
            $t.lastParent.find('temp-div').remove();
            var size = $t.makeTempDiv($t.lastParent, true);
            if (size == 12) {
                if ($t.lastParent.parents('.container-fluid:first').find('.added-element').length == 0) {
                    var parent = $t.lastParent.parents('.container-fluid:first');
                    if (parent.parent().hasClass('container-fluid') && parent.parent().hasClass('haschild'))
                        parent.parent().remove();
                    else
                        parent.remove();
                } else if ($t.lastParent.find('.added-element').length == 0) {
                    var parent = $t.lastParent;
                    if (parent.parent().hasClass('container-fluid') && parent.parent().hasClass('haschild'))
                        parent.parent().remove();
                    else
                        parent.remove();
                } else {
                    $t.lastParent.parents('.container-fluid:first').find('div.haschild').each(function() {
                        if ($(this).find('.added-element').length == 0) {
                            var parent = $(this);
                            if (parent.parent().hasClass('container-fluid') && parent.parent().hasClass('haschild'))
                                parent.parent().remove();
                            else
                                parent.remove();
                        };
                    })
                };
            };
        } else {
            $t.makeTempDiv($t.activeEl, true);
        };
        $('.added-element').css({
            position: '',
            left: '',
            top: ''
        });
        $('.droppable.active').removeClass('active');
        $('.hovered').removeClass('hovered');
        $t.lastParent.parent().find('.haschild').each(function() {
            if ($(this).find('.added-element').length == 0)
                $(this).remove();
        })
    };
    $('.dropable-hover').removeClass('dropable-hover');
    $t.togglePreviewEl();
    $t.activeEl = null;
    $t.modal('', 'hide');
};
MR_landing.prototype.overFunction = function(event, ui, el) {
    var $t = this;
    var $ = jQuery;
    if ($(el).parent().hasClass('box-container')) {
        $(el).parents('.row-fluid.droppable:last').droppable('disable');
    };
};
MR_landing.prototype.outFunction = function(event, ui, el) {
    var $t = this;
    var $ = jQuery;
    if ($(el).parent().hasClass('box-container')) {
        $(el).parents('.row-fluid.droppable:last').droppable('enable');
    };
};
MR_landing.prototype.addAdminsBtns = function(el, allBtns) {
    var $t = this;
    var $ = jQuery;
    var additionalClass = '';
    var buttonHolder = $t.ce('div');
    $(buttonHolder).addClass('el-button-holder').appendTo(el);
    if ($(el).hasClass('container-fluid'))
        additionalClass = ' btn-primary';
    if ($(el).hasClass('box-container'))
        additionalClass = ' btn-inverse';
    if ($(el).hasClass('added-element') && !$(el).hasClass('container-fluid') && !$(el).hasClass('container') && $(el).parents('.box-container').length == 0) {
        $(el).addClass('cant_drag');
        var a = $t.ce('a');
        var i = $t.ce('i');
        $(i).addClass('fa fa-chevron-left').appendTo(a);
        var title = COM_MARKETINGROCKET_MOVE_LEFT;
        $(a).attr('data-original-title', title).addClass('MR_SORT_LEFT hasTooltip btn-mini btn ');
        $(buttonHolder).append(a);
        $(a).tooltip({
            container: 'body'
        });
        var a = $t.ce('a');
        var i = $t.ce('i');
        $(i).addClass('fa fa-chevron-right').appendTo(a);
        var title = COM_MARKETINGROCKET_MOVE_RIGHT;
        $(a).attr('data-original-title', title).addClass('MR_SORT_RIGHT hasTooltip btn-mini btn ');
        $(buttonHolder).append(a);
        $(a).tooltip({
            container: 'body'
        });
        var div = $t.ce('div');
        var type = $(el).attr('aria-type');
        if ($('.elemnts[aria-type="' + type + '"]:first').length > 0 || type == 'box-container') {
            if (type != 'box-container') {
                type = $.trim($('.elemnts[aria-type="' + type + '"]:first').text());
                $(div).addClass('element-type-holder').html(type).prependTo(el);
            };
            $t.createDragPoint(el);
        };
    };
    var a = $t.ce('a');
    var i = $t.ce('i');
    $(i).addClass('fa fa-gear').appendTo(a);
    if ($(el).hasClass('box-container'))
        var title = COM_MARKETINGROCKET_CONTAINER_SETTING;
    else
        var title = COM_MARKETINGROCKET_SETTING;
    if ($(el).parent().attr('id') == 'MarketingRocket')
        title = COM_MARKETINGROCKET_PAGE_SETTING;
    else if ($(el).hasClass('container-fluid'))
        title = COM_MARKETINGROCKET_CONTAINER_SETTING;
    else if ($(el).hasClass('row-fluid'))
        title = COM_MARKETINGROCKET_ROW_SETTING;
    else if ($(el).hasClass('added-element'))
        title = COM_MARKETINGROCKET_ITEM_SETTING;
    $(a).attr('data-original-title', title).addClass('MR_Admin hasTooltip btn-mini btn' + additionalClass);
    $(buttonHolder).append(a);
    $(a).tooltip({
        container: 'body'
    });
    var a = $t.ce('a');
    var i = $t.ce('i');
    if (allBtns !== false) {
        $(i).addClass('fa fa-times').appendTo(a);
        var title = COM_MARKETINGROCKET_REMOVE;
        if ($(el).hasClass('added-element'))
            title = COM_MARKETINGROCKET_ITEM_REMOVE;
        else if ($(el).hasClass('container-fluid'))
            title = COM_MARKETINGROCKET_CONTAINER_REMOVE;
        $(a).attr('data-original-title', title).addClass('MR_remove btn-mini btn hasTooltip' + additionalClass);
        $(buttonHolder).append(a);
        $(a).tooltip({
            container: 'body'
        });
        var type = $(el).attr('aria-type');
        if (type != 'form') {
            var a = $t.ce('a');
            var i = $t.ce('i');
            if ($(el).hasClass('container-fluid')) {
                var title = COM_MARKETINGROCKET_ADD_SECTION;
                $(i).addClass('fa fa-plus').appendTo(a);
            } else {
                var title = COM_MARKETINGROCKET_DUPLICATE;
                $(i).addClass('fa fa-files-o').appendTo(a);
            }
            $(a).attr('data-original-title', title).addClass('MR_duplicate btn-mini btn hasTooltip' + additionalClass);
            $(buttonHolder).append(a);
            $(a).tooltip({
                container: 'body'
            });
        };
    };
    $t.adminsBtnsFuntions(el);
    var type = $(el).attr('aria-type');
    if (type != undefined && $t[type + 'AfterAddAdminBtns'] != undefined)
        $t[type + 'AfterAddAdminBtns'](el);
};
MR_landing.prototype.adminsBtnsFuntions = function(el) {
    var $t = this;
    var $ = jQuery;
    $(el).find(' > .el-button-holder > a.MR_Admin:first, > a.MR_Admin:first').click(function() {
        $t.activeEl = $(this).parent().parent();
        $t.showAdminPopup();
    });
    $(el).find(' > .el-button-holder > a.MR_remove').click(function() {
        $t.activeEl = $(this).parent().parent().parent();
        $t.removeEl();
    });
    $(el).find(' > .el-button-holder > a.MR_SORT_LEFT').click(function() {
        $t.activeEl = $(this).parent().parent();
        $t.moveLeft();
    });
    $(el).find(' > .el-button-holder > a.MR_SORT_RIGHT').click(function() {
        $t.activeEl = $(this).parent().parent();
        $t.moveRight();
    });
    $(el).find(' > .el-button-holder > a.MR_duplicate').click(function() {
        var parent = $(this).parent().parent();
        if (parent.hasClass('container-fluid') || parent.hasClass('container')) {
            if (parent.parent().hasClass('container-fluid'))
                parent = parent.parent();
            var div = $t.createRow(parent.parent(), false);
            $(div).parent().parent().insertAfter(parent);
        } else
            $t.duplicateEl($(this).parent().parent());
    })
};
MR_landing.prototype.moveLeft = function() {
    var $t = this;
    var $ = jQuery;
    var prevEl = $t.activeEl.prev();
    $('.tooltip').remove();
    if (prevEl.length > 0) {
        $t.activeEl.insertBefore(prevEl);
        return;
    } else {
        var parentPrev = $t.activeEl.parent().prev();
        if (parentPrev.length > 0 && parentPrev.hasClass('el-button-holder'))
            parentPrev = parentPrev.prev();
        var rowClass = $t.activeEl.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
        rowClass = parseInt(rowClass[3]);
        if (parentPrev.length > 0 && parentPrev.hasClass('row-fluid')) {
            var prevSize = $t.getChildWithSize(parentPrev);
            if (prevSize - rowClass >= 0) {
                $t.activeEl.appendTo(parentPrev);
            } else {
                var element = parentPrev.find('.added-element:last');
                if (element.length > 0)
                    $t.swapNodes($t.activeEl, element);
                else
                    alert(COM_MARKETINGROCKET_NO_ENOUGH_ROOM_PREV);
            }
            return;
        } else {
            if (!$t.activeEl.hasClass('box-container')) {
                var f = function(i, el) {
                    var $ = jQuery;
                    if ($(el).parents('.complex-item').length > 0) {
                        return true;
                    };
                    return false;
                };
                if ($('#MarketingRocket').is(':visible')) {
                    var elList = $('#MarketingRocket .added-element[aria-type]').not('.box-container').not(f);
                } else if ($('#MR_Modal_View').is(':visible')) {
                    var elList = $('#MR_Modal_View .added-element[aria-type]').not('.box-container').not(f);
                } else {
                    var elList = $('#MR_Exit_View_Holder .added-element[aria-type]').not('.box-container').not(f);
                };
                var cIndex = elList.index($t.activeEl);
                if ($(elList.get(cIndex - 1)).length > 0) {
                    $t.swapNodes($t.activeEl, $(elList.get(cIndex - 1)));
                } else {
                    alert(COM_MARKETINGROCKET_CANT_MOVE);
                };
                return;
            };
            var twoLevelParent = $t.activeEl.parent().parent();
            if (twoLevelParent.hasClass('droppable')) {
                var parentCurrentSize = $t.getChildWithSize(twoLevelParent);
                alert(parentCurrentSize);
                if (parentCurrentSize - rowClass >= 0) {
                    $t.activeEl.insertBefore(twoLevelParent.find(' > .el-button-holder'));
                } else {
                    if (twoLevelParent.hasClass('row-fluid')) {
                        $t.swapNodes($t.activeEl, twoLevelParent.find(' > .added-element:last'));
                    } else {
                        $t.dropFunction('', {
                            draggable: $t.activeEl
                        }, twoLevelParent);
                    };
                };
                return;
            } else if (twoLevelParent.hasClass('container-fluid')) {
                while (!twoLevelParent.parent().hasClass('sortable')) {
                    twoLevelParent = twoLevelParent.parent()
                };
                var prevMainParent = twoLevelParent.prev();
                if (prevMainParent.length > 0) {
                    var element = prevMainParent.find('.added-element:last');
                    var tempDiv = element.parent().find('.temp-div');
                    if (tempDiv.length > 0) {
                        var tempClass = tempDiv.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
                        tempClass = parseInt(tempClass[3]);
                    };
                    if (tempDiv.length > 0 && tempClass >= rowClass) {
                        $t.dropFunction('', {
                            draggable: $t.activeEl
                        }, tempDiv);
                    } else {
                        $t.swapNodes($t.activeEl, element);
                    };
                    return;
                };
            };
        };
    };
    alert(COM_MARKETINGROCKET_CANT_MOVE);
};
MR_landing.prototype.moveRight = function() {
    var $t = this;
    var $ = jQuery;
    $('.tooltip').remove();
    var nextEl = $t.activeEl.next();
    var rowClass = $t.activeEl.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
    rowClass = parseInt(rowClass[3]);
    if (nextEl.length > 0 && nextEl.hasClass('added-element')) {
        $t.activeEl.insertAfter(nextEl);
        return;
    } else if (nextEl.length > 0) {
        while (nextEl.length > 0) {
            if (nextEl.hasClass('row-fluid')) {
                var nextSize = $t.getChildWithSize(nextEl);
                if (nextSize - rowClass >= 0) {
                    var parent = $t.activeEl.parent();
                    $t.activeEl.prependTo(nextEl);
                    $t.makeTempDiv(parent, true);
                } else {
                    $t.dropFunction('', {
                        draggable: $t.activeEl
                    }, nextEl);
                }
                return;
                break;
            };
            nextEl = nextEl.next();
        };
    };
    if (!$t.activeEl.hasClass('box-container')) {
        var f = function(i, el) {
            var $ = jQuery;
            if ($(el).parents('.complex-item').length > 0) {
                return true;
            };
            return false;
        };
        if ($('#MarketingRocket').is(':visible')) {
            var elList = $('#MarketingRocket .added-element[aria-type]').not('.box-container').not(f);
        } else if ($('#MR_Modal_View').is(':visible')) {
            var elList = $('#MR_Modal_View .added-element[aria-type]').not('.box-container').not(f);
        } else {
            var elList = $('#MR_Exit_View_Holder .added-element[aria-type]').not('.box-container').not(f);
        };
        var cIndex = elList.index($t.activeEl);
        if ($(elList.get(cIndex + 1)).length > 0) {
            $t.swapNodes($t.activeEl, $(elList.get(cIndex + 1)));
        } else {
            alert(COM_MARKETINGROCKET_CANT_MOVE);
        }
        return;
    };
    var parentNext = $t.activeEl.parent().next();
    if (parentNext.length > 0 && parentNext.hasClass('el-button-holder'))
        parentNext = parentNext.next();
    if (parentNext.length > 0 && parentNext.hasClass('row-fluid')) {
        var nextSize = $t.getChildWithSize(parentNext);
        if (nextSize - rowClass >= 0) {
            var parent = $t.activeEl.parent();
            $t.activeEl.prependTo(parentNext);
            $t.makeTempDiv(parent, true);
        } else
            alert(COM_MARKETINGROCKET_NO_ENOUGH_ROOM_NEXT);
        return;
    };
    var twoLevelParent = $t.activeEl.parent().parent();
    if (twoLevelParent.hasClass('container-fluid')) {
        while (!twoLevelParent.parent().hasClass('sortable')) {
            twoLevelParent = twoLevelParent.parent()
        };
        var nextvMainParent = twoLevelParent.next();
        if (nextvMainParent.length > 0) {
            var element = nextvMainParent.find('.added-element:first');
            var tempDiv = element.parent().find('.temp-div');
            if (tempDiv.length > 0) {
                var tempClass = tempDiv.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
                tempClass = parseInt(tempClass[3]);
            };
            if (tempDiv.length > 0 && tempClass >= rowClass) {
                var el = $t.activeEl;
                $t.dropFunction('', {
                    draggable: $t.activeEl
                }, tempDiv);
                el.prependTo(el.parent());
            } else {
                $t.swapNodes($t.activeEl, element);
            };
            return;
        };
    };
    alert(COM_MARKETINGROCKET_CANT_MOVE);
};
MR_landing.prototype.swapNodes = function(el1, el2) {
    var $t = this;
    var $ = jQuery;
    var el1ClassSize = el1.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
    el1ClassSize = parseInt(el1ClassSize[3]);
    var el2ClassSize = el2.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
    el2ClassSize = parseInt(el2ClassSize[3]);
    el1.removeClass('span' + el1ClassSize).removeClass('col-md-' + el1ClassSize).addClass('span' + el2ClassSize).addClass('col-md-' + el2ClassSize);
    el2.removeClass('span' + el2ClassSize).removeClass('col-md-' + el2ClassSize).addClass('span' + el1ClassSize).addClass('col-md-' + el1ClassSize);
    var a = el1[0];
    var b = el2[0];
    var aparent = a.parentNode;
    var asibling = a.nextSibling === b ? a : a.nextSibling;
    b.parentNode.insertBefore(a, b);
    aparent.insertBefore(b, asibling);
};
MR_landing.prototype.getChildWithSize = function(parentNode) {
    var $t = this;
    var $ = jQuery;
    var className = 12;
    try {
        $(parentNode).find('> .temp-div').remove();
        if ($(parentNode).find('.temp-div').length == 0) {
            var parents = $(parentNode).parents('.droppable');
            if (parents.length > 0) {
                parents.each(function() {
                    if ($(this).length > 0 && $(this).find('.temp-div').length == 0)
                        $(this).addClass('droppable ui-droppable').droppable('enable');
                })
            } else
                $(parentNode).addClass('droppable ui-droppable').droppable('enable');
        }
    } catch (e) {
        console.log(e);
    };
    $(parentNode).find(' > .added-element').each(function() {
        try {
            var rowClass = $(this).attr('class');
            var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
            res = parseInt(res[3]);
            className = className - res;
        } catch (e) {
            console.log(e);
        };
    });
    return parseInt(className);
};
MR_landing.prototype.showAdminPopup = function() {
    var $t = this;
    var $ = jQuery;
    $t.fillPopUpCss($t.activeEl);
    var type = $t.activeEl.attr('aria-type');
    if (type != undefined && $t[type + 'AfterFillPopupCss'] != undefined)
        $t[type + 'AfterFillPopupCss']($t.activeEl);
    $t.modal('#MR-prperty-modal', 'show');
};
MR_landing.prototype.fillPopUpCss = function(el) {
    var $t = this;
    var $ = jQuery;
    $t.isFillPopUpCss = true;
    var type = $(el).attr('aria-type');
    if (!type || type == '') {
        if ($(el).hasClass('button-holder'))
            type = 'button';
    };
    var parents = $(el).parents('.complex-item');
    if ($(el).hasClass('container-fluid') || $(el).hasClass('row-fluid') || (parents.length > 0 && !parents.hasClass('wizard')) || $(el).hasClass('inside-item')) {
        $('#jform_change_item_type').parents('.control-group:first').hide();
    } else {
        $('#jform_change_item_type').parents('.control-group:first').show();
    };
    $('#jform_change_item_type').val(type).chosen('destroy').chosen();
    if (el.length == undefined)
        el = $(el);
    var switched = false;
    if (el.hasClass('container') && el.parent().hasClass('container-fluid')) {
        el.parent().removeClass('hovered');
    } else
        el.removeClass('hovered');
    var css = $t.css(el);
    $t.curCss = css;
    $('#jform_animation').val($t.activeEl.data('animation')).chosen('destroy').chosen();
    $('#MR-prperty-modal').find('input,textarea').unbind('keyup').unbind('blur');
    $('#MR-prperty-modal').find('select').not('#jform_change_item_type').not('#jform_animation').unbind('change');
    $('#MR-prperty-modal').find('input[type="checkbox"]').unbind('click');
    var elId = $(el).attr('id');
    $('#MR-prperty-modal').find('.onoffswitch-checkbox').each(function() {
        var id = $(this).data('id');
        var force = false;
        if ($t.inlineCss[elId] != undefined && $t.inlineCss[elId].temp != undefined && $t.inlineCss[elId].temp[id] != undefined) {
            force = true;
        };
        $(this).prop('checked', true).change();
        if (force) {
            $(this).prop('checked', false).change();
        };
    });
    $t.setBackgroundColor(css.backgroundColor, '#jform_background_color');
    var backgroundImageSetted = false;
    if (css.backgroundImage != undefined) {
        if (css.backgroundImage.substr(0, 3) == 'url') {
            var src = css.backgroundImage.match(/\((.*?)\)/)[1].replace(/('|")/g, '');
            $('#jform_background_image').val(src);
            $('#jform_background_image_preview').attr('src', src);
            backgroundImageSetted = true;
        };
    };
    if (backgroundImageSetted === false) {
        $('#jform_background_image').val('');
        $('#jform_background_image_preview').attr('src', '');
    };
    $('#jform_background_repeat').val(css.backgroundRepeat);
    $('#jform_background_size').val(css.backgroundSize);
    var background = css.background;
    if (css.background == undefined && css.backgroundImage)
        background = css.backgroundImage;
    else if (css.background == undefined)
        background = '';
    if (background.substr(0, 6) == 'linear') {
        $('#jform_background').val(background);
    } else {
        $('#jform_background').val('');
    }
    $('#container_styles_holder').parent().find('> div').show();
    $('#container_border_holder').parent().find('> div').show();
    $('#container_styles_holder').hide().find('.control-group').hide();
    $('#container_border_holder').hide().find('.control-group').hide();
    if ($(el).hasClass('container-fluid')) {
        if ($(el).parents('#MR_Modal_View').length > 0 || $('#show_exit_popup_layout').is(':checked')) {
            $('#jform_containerclass').val('container-fluid');
            $('#jform_containerclass').parents('.control-group').hide();
            $('#jform_size').parents('.control-group').hide();
        } else {
            var parent = $(el).parent();
            if (parent.attr('id') === 'MarketingRocket' || parent.attr('id') === 'MR_Exit_View_Holder') {
                $('#jform_containerclass').parents('.control-group').hide();
                $('#jform_size').parents('.control-group').hide();
            } else {
                if (parent.hasClass('container-fluid'))
                    $('#jform_containerclass').val('container-fluid');
                else
                    $('#jform_containerclass').val('container');
                $('#jform_containerclass').parents('.control-group').show();
                $('#jform_size').parents('.control-group').hide();
                $('#jform_containerclass').chosen('destroy');
                $('#jform_containerclass').chosen();
            };
        };
        if ($(el).parent().hasClass('container-fluid haschild')) {
            $('#container_styles_holder').parent().find('> div').hide();
            $('#container_border_holder').parent().find('> div').hide();
            $('#container_styles_holder').show().find('.control-group').show();
            $('#container_border_holder').show().find('.control-group').show();
            var id = $(el).parent().attr('id');
            var backgroundColor, backgroundRepeat, backgroundSize = containerBackgroundImage = containerBorderColor = containerBorderWidth = containerBorderStyle = '';
            if ($t.inlineCss[id] != null) {
                try {
                    var containerCss = $t.inlineCss[id].styles;
                    backgroundColor = containerCss['background-color'];
                    containerBackgroundImage = containerCss['background-image'];
                    backgroundRepeat = containerCss['background-repeat'];
                    backgroundSize = containerCss['background-size'];
                    containerBackground = containerCss.background;
                    containerBorderColor = containerCss['border-color'];
                    containerBorderWidth = containerCss['border-width'];
                    containerBorderStyle = containerCss['border-style'];
                } catch (e) {
                    console.log(e);
                };
            };
            $t.setBackgroundColor(backgroundColor, '#jform_container_background_color');
            var containerBackgroundImageSetted = false;
            if (containerBackgroundImage != undefined && containerBackgroundImage != '') {
                if (containerBackgroundImage.substr(0, 3) == 'url') {
                    var src = containerBackgroundImage.match(/\((.*?)\)/)[1].replace(/('|")/g, '');
                    $('#jform_container_background_image').val(src);
                    $('#jform_container_background_image_preview').attr('src', src);
                    containerBackgroundImageSetted = true;
                };
            };
            if (containerBackgroundImageSetted === false) {
                $('#jform_container_background_image').val('');
                $('#jform_container_background_image_preview').attr('src', '');
            };
            $('#jform_container_background_repeat').val(backgroundRepeat);
            $('#jform_container_background_size').val(backgroundSize);
            if (window.containerBackground == undefined && window.backgroundImage != undefined)
                var containerBackground = backgroundImage;
            else if (window.containerBackground == undefined)
                var containerBackground = '';
            if (containerBackground.substr(0, 6) == 'linear') {
                $('#jform_container_background').val(containerBackground);
            } else {
                $('#jform_container_background').val('');
            }
            $('#jform_container_border_color').val(containerBorderColor);
            $('#jform_container_border_width').val(containerBorderWidth);
            $('#jform_container_border_style').val(containerBorderStyle);
        };
        if ($(el).hasClass('container-fluid') && $('#jform_containerclass').val() == 'container-fluid') {
            var parentCss = $t.css($(el).parent());
            $('#jform_box_shadow').val(parentCss.boxShadow);
        } else {
            $('#jform_box_shadow').val(css.boxShadow);
        }
    } else {
        $('#jform_containerclass').parents('.control-group').hide();
        if ($(el).hasClass('row-fluid') || $(el).hasClass('btn') || $(el).hasClass('container') || $(el).parents('.box-container').length > 0 || $(el).hasClass('active-button') || $(el).hasClass('inside-item'))
            $('#jform_size').parents('.control-group').hide();
        else {
            var rowClass = $(el).attr('class');
            var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
            try {
                res = parseInt(res[3]);
                $('#jform_size').parents('.control-group').show();
                $('#jform_size').val(res);
                $('#jform_size').chosen('destroy');
                $('#jform_size').chosen();
            } catch (e) {
                $('#jform_size').parents('.control-group').hide();
            };
        };
        $('#jform_box_shadow').val(css.boxShadow);
    };
    $t.getBoxShadow($('#jform_box_shadow').parents('.accordion-inner:first'), $('#jform_box_shadow').val());
    $t.setColor(css.color, '#jform_color');
    $('#jform_font_size').val($t.getDimension(css.fontSize, $('#jform_font_size')));
    $('#jform_font_family').val(css.fontFamily);
    $('#jform_font_family').chosen('destroy');
    $('#jform_font_family').chosen();
    $('#jform_text_align').val(css.textAlign);
    $('#jform_text_align').chosen('destroy');
    $('#jform_text_align').chosen();
    $('#jform_font_weight').val(css.fontWeight);
    $('#jform_font_weight').chosen('destroy');
    $('#jform_font_weight').chosen();
    $('#jform_text_transform').val(css.textTransform);
    $('#jform_text_transform').chosen('destroy');
    $('#jform_text_transform').chosen();
    $('#jform_font_style').val(css.fontStyle);
    $('#jform_font_style').chosen('destroy');
    $('#jform_font_style').chosen();
    $t.extractBorders(css, '#jform_border_color', '#jform_border_width', '#jform_border_style');
    $('#jform_border_radius').val($t.getDimension(css.borderRadius, $('#jform_border_radius')));
    $('#jform_background_size').val(css.backgroundSize);
    var target = $('#background-setting.gradient');
    $t.fillGradient(background, target);
    var cutome_css = $(el).attr('aria-css');
    $('#jform_custom_css').val('').val(cutome_css);
    $('#jform_padding_left').val($t.getDimension(css.paddingLeft, $('#jform_padding_left')));
    $('#jform_padding_top').val($t.getDimension(css.paddingTop, $('#jform_padding_top')));
    $('#jform_padding_right').val($t.getDimension(css.paddingRight, $('#jform_padding_right')));
    $('#jform_padding_bottom').val($t.getDimension(css.paddingBottom, $('#jform_padding_bottom')));
    $('#jform_margin_top').val($t.getDimension(css.marginTop, $('#jform_margin_top')));
    $('#jform_margin_bottom').val($t.getDimension(css.marginBottom, $('#jform_margin_bottom')));
    var type = $(el).attr('aria-type');
    try {
        $('#MR-prperty-modal').find('h3').html($(el).find('> .el-button-holder .MR_Admin:first').attr('data-original-title'));
    } catch (e) {
        $('#MR-prperty-modal').find('h3').html('');
        console.log(e);
    };
    $('#MR-prperty-modal').find('h3').append('<small>#' + $(el).attr('id') + '</small>');
    $('#MR-prperty-modal').find('input,textarea').each(function() {
        var name = $(this).attr('name');
        if (name == undefined || name == null)
            return true;
        $(this).keyup(function() {
            $t.saveCss($(this));
        }).blur(function() {
            $(this).keyup()
        });
        $(this).change(function() {
            $t.saveCss($(this));
        }).blur(function() {
            $(this).change()
        });
        if ($(this).attr('type') === 'checkbox') {
            $(this).click(function() {
                $(this).keyup();
            })
        };
    });
    $('#MR-prperty-modal').find('select').not('#jform_change_item_type').not('#jform_animation').each(function() {
        var name = $(this).attr('name');
        if (name == undefined || name == null)
            return true;
        $(this).unbind('change').change(function() {
            $t.saveCss($(this));
            if ($(this).attr('id') == 'jform_containerclass') {
                if ($(this).val() == 'container-fluid') {
                    $('#container_border_holder').show().find('.control-group').show();
                    $('#container_styles_holder').show().find('.control-group').show();
                } else {
                    $('#container_border_holder').hide().find('.control-group').hide();
                    $('#container_styles_holder').hide().find('.control-group').hide();
                };
            };
        });
    });
    $('#jform_padding_left,#jform_padding_right,#jform_padding_top,#jform_padding_bottom,' + '#jform_margin_top,#jform_margin_bottom,#jform_border_radius,#jform_font_size').each(function() {
        $t.setDimensionValue($(this).val(), $(this));
    });
    $('#jform_button_padding_left,#jform_button_padding_right,#jform_button_padding_top,#jform_button_padding_bottom,' + '#jform_button_margin_top,#jform_button_margin_bottom,#jform_button_border_radius,#jform_font_size').each(function() {
        $t.setDimensionValue($(this).val(), $(this));
    });
    $('#overflow-holder').hide();
    $t.isFillPopUpCss = false;
};
MR_landing.prototype.saveCss = function(element) {
    var $t = this;
    var $ = jQuery;
    var el = $t.activeEl;
    $t.cssFounded = false;
    if (!$(el).hasClass('added-element') && !$(el).hasClass('btn') && !$(el).hasClass('row-fluid') && !$(el).hasClass('container-fluid') && !$(el).hasClass('inside-item'))
        el = $(el).find('.added-element:first');
    if ($t.deBugable)
        console.log(element);
    if (element == undefined)
        element = false;
    var id = itemId = el.attr('id');
    if ($t.inlineCss[itemId] == undefined)
        element = false;
    if (element == false) {
        $t.inlineCss[itemId] = {
            styles: {},
            hover: {},
            iconStyle: {},
            iconStyleHover: {}
        };
    }
    $(el).attr('style', '');
    $('#MR-prperty-modal').find('input,select,textarea').each(function() {
        var name = $(this).attr('name');
        if (element != false && name != element.attr('name') || name == '' || name == undefined)
            return true;
        name = name.replace('jform', '', 'g');
        name = name.replace('[', '', 'g');
        name = name.replace(']', '', 'g');
        if (!$(this).parents('.control-group:first').is(':visible') && name != 'box-shadow' && $('#MR-prperty-modal').is(':visible'))
            return true;
        var val = $(this).val();
        val = $.trim(val);
        var id = $(this).attr('id');
        if ($.inArray(name, ['container-background-color', 'container-background-color-transparent', 'container-background-image', 'container-background-repeat', 'container-background-size', 'container-background', 'container-border-color', 'container-border-width', 'container-border-style']) > -1) {
            var parentId = $(el).parent().attr('id');
            if (parentId == undefined)
                return true;
            if ($t.inlineCss[parentId] == undefined) {
                $t.inlineCss[parentId] = {
                    styles: {},
                    hover: {},
                    iconStyle: {},
                    iconStyleHover: {}
                };
            };
            if ($.inArray(name, ['container-background-color-transparent', 'container-background-color']) > -1 && $t.inlineCss[parentId].styles['background-image'] != '' && $('#jform_container_background_image').val() == '') {
                $t.inlineCss[parentId].styles['background-image'] = '';
            };
            if (name == 'container-background-color-transparent') {
                if (!$(this).is(':checked')) {
                    var val = $(this).parents('.control-group:first').prev().find('input').val();
                    $t.inlineCss[parentId].styles['background-color'] = val;
                    $t.cssFounded = true;
                    return true;
                } else {
                    $t.inlineCss[parentId].styles['background-color'] = 'transparent';
                    $t.cssFounded = true;
                    return true;
                };
            } else if (name == 'container-background-image' && val != '') {
                val = 'url("' + $t.fixImageSrc(val) + '")';
            };
            name = name.replace('container-', '', 'g');
            if (val != '' || element != false)
                $t.inlineCss[parentId].styles[name] = val;
        } else {
            if (id == 'jform_size' && $(this).parents('.control-group').is(':visible')) {
                if (!$(el).hasClass('row-fluid') && !$(el).hasClass('btn') && !$(el).hasClass('container-fluid') && !$(el).hasClass('MR-ELEMENTS')) {
                    var rowClass = $(el).attr('class');
                    var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
                    res = parseInt(res[3]);
                    $(el).removeClass('col-md-' + res).removeClass('span' + res);
                    $(el).addClass('col-md-' + val).addClass('span' + val);
                    if (val < 12) {
                        $t.makeTempDiv(el);
                    };
                };
                return true;
            } else if (id == 'jform_containerclass' && $(this).parents('.control-group').is(':visible')) {
                $(el).addClass('container');
                if (val === 'container-fluid') {
                    if ($(el).parent().hasClass('container-fluid'))
                        return true;
                    var div = $t.ce('div');
                    var parentId = $t.randString(6);
                    $(div).addClass('container-fluid haschild').attr('id', parentId).insertBefore(el);
                    $t.inlineCss[parentId] = {
                        styles: {},
                        hover: {},
                        iconStyle: {},
                        iconStyleHover: {}
                    };
                    $t.duplicateCss(itemId, parentId, ['background-color', 'background-color-transparent', 'background-image', 'background-repeat', 'background-size', 'background', 'border-color', 'border-width', 'border-style'], true);
                    $(el).appendTo(div);
                    $t.writeCss();
                    $t.fillPopUpCss(el);
                    return true;
                } else {
                    if ($(el).parent().attr('id') === 'MarketingRocketMain')
                        return true;
                    $(el).insertBefore($(el).parent());
                    var parentId = $(el).next().attr('id');
                    $t.duplicateCss(parentId, itemId, ['background-color', 'background-color-transparent', 'background-image', 'background-repeat', 'background-size', 'background', 'border-color', 'border-width', 'border-style']);
                    $t.inlineCss[parentId] = undefined;
                    $(el).next().remove();
                    $t.writeCss();
                    $t.fillPopUpCss(el);
                    return true;
                };
                return true;
            };
            id = id.split('_');
            id.shift();
            id = id.join('-');
            if ($.inArray(name, ['background-color-transparent', 'background-color']) > -1 && $t.inlineCss[itemId].styles['background-image'] != '' && $('#jform_background_image').val() == '') {
                $t.inlineCss[itemId].styles['background-image'] = '';
            };
            if (name == 'box-shadow' && el.hasClass('container-fluid') && $('#jform_containerclass').val() == 'container-fluid') {
                var parentId = $(el).parent().attr('id');
                if (parentId == undefined)
                    return true;
                if ($t.inlineCss[parentId] == undefined) {
                    $t.inlineCss[parentId] = {
                        styles: {},
                        hover: {},
                        iconStyle: {},
                        iconStyleHover: {}
                    };
                };
                $t.inlineCss[parentId].styles['box-shadow'] = val;
                $t.cssFounded = true;
                return true;
            }
            if (name == 'background-color-transparent') {
                if (!$(this).is(':checked')) {
                    var val = $(this).parents('.control-group:first').prev().find('input').val();
                    $t.inlineCss[itemId].styles['background-color'] = val;
                    $t.cssFounded = true;
                    return true;
                } else {
                    $t.inlineCss[itemId].styles['background-color'] = 'transparent';
                    $t.cssFounded = true;
                    return true;
                };
            } else if (name == 'background-image' && val != '') {
                val = 'url("' + $t.fixImageSrc(val) + '")';
            };
            if ($.inArray(name, ['size', 'containerclass', 'shadow_inset', 'custom-css']) > -1)
                return true;
            if ($.inArray(name, ['padding-left', 'padding-right', 'padding-top', 'padding-bottom', 'padding-right', 'margin-top', 'margin-bottom', 'font-size', 'border-radius', '']) > -1) {
                val = $t.setDimensionValue(val, $(this));
            };
            if (val != '' || element != false)
                $t.inlineCss[itemId].styles[name] = val + ' !important';
        };
        if (element != false) {
            $t.cssFounded = true;
            return false;
        };
    });
    var cutom_css = $('#jform_custom_css').val();
    cutom_css = $.trim(cutom_css.replace('"', '\''));
    $(el).attr('aria-css', cutom_css);
    if (cutom_css && cutom_css != '') {
        cutom_css = cutom_css.split(';');
        for (var i = 0; i < cutom_css.length; i++) {
            var row = $.trim(cutom_css[i]).split(':');
            if ($t.validCSS($.trim(row[0]), $.trim(row[1])))
                $t.inlineCss[itemId].styles[$.trim(row[0])] = $.trim(row[1]);
            else if ($t.deBugable)
                console.log(row[0] + ' Width ' + row[1] + ' Is Not Valid');
        };
    };
    if ($t.checkElementName(element)) {
        $t.writeCss();
        $('#jform_hidden_css').val(JSON.stringify($t.inlineCss));
    };
};
MR_landing.prototype.createRow = function(parent, appendToCurrent) {
    var $t = this;
    var $ = jQuery;
    var div = $t.ce('div');
    $(div).attr('id', $t.randString(6));
    if (!appendToCurrent) {
        if (!parent.hasClass('sortable'))
            var containerDiv = $t.createContainer($(parent).parent().parent());
        else
            var containerDiv = $t.createContainer($(parent));
        $(div).addClass('row-fluid').prependTo(containerDiv).droppable($t.dropObj);
        $t.addAdminsBtns(div, false);
    } else
        $(div).addClass('row-fluid').appendTo(parent);
    return div;
};
MR_landing.prototype.createContainer = function(parent) {
    var $t = this;
    var $ = jQuery;
    var containerDivParent = $t.ce('div');
    var id = $t.randString(6);
    $(containerDivParent).attr('id', id).addClass('container-fluid');
    $t.createCssObj(id, containerDivParent);
    if (parent !== undefined)
        $(containerDivParent).appendTo(parent);
    if ($('#MarketingRocket').is(':visible')) {
        var containerDiv = $t.ce('div');
        var id = $t.randString(6);
        $(containerDiv).attr('id', id).addClass('container-fluid container').appendTo(containerDivParent);
        $t.createCssObj(id, containerDiv);
    } else
        var containerDiv = containerDivParent;
    $t.addAdminsBtns(containerDiv);
    $t.addSortingBtns(containerDiv);
    return containerDiv;
};
MR_landing.prototype.createCssObj = function(id, div) {
    var $t = this;
    var $ = jQuery;
    $t.inlineCss[id] = {
        styles: {},
        hover: {},
        iconStyle: {},
        iconStyleHover: {},
        temp: {}
    };
};
MR_landing.prototype.ce = function(el) {
    return document.createElement(el);
};
MR_landing.prototype.rgb2hex = function(rgb) {
    try {
        rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);
        return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
    } catch (e) {
        return "";
    };
};
MR_landing.prototype.hex2rgb = function(hex) {
    if (hex.lastIndexOf('#') > -1) {
        hex = hex.replace(/#/, '0x');
    } else {
        hex = '0x' + hex;
    };
    var r = hex >> 16;
    var g = (hex & 0x00FF00) >> 8;
    var b = hex & 0x0000FF;
    return [r, g, b];
};
MR_landing.prototype.togglePreviewEl = function(el) {
    var $t = this;
    var $ = jQuery;
    if (el == undefined)
        var el = $($t.activeEl).parent();
    if ($(el).hasClass('preview') && $(el).find('.added-element').length > 0)
        $(el).removeClass('preview');
    else if (!$(el).hasClass('preview') && $(el).find('.added-element').length == 0)
        $(el).addClass('preview');
};
MR_landing.prototype.removeEl = function() {
    var $t = this;
    var $ = jQuery;
    $('#MR-CM').find('h3').html($t.lang('COM_MARKETINGROCKET_ARE_YOU_SURE_ABOUT_DELETE'));
    $('#MR-CM').find('.modal-body:first').html('').show();
    $('#MR-CM').find('div.article:first').hide();
    $('#MR-DONE').text($t.lang('COM_MARKETINGROCKET_REMOVE')).unbind('click').click(function() {
        $t.forceDelete();
        $t.modal('#MR-CM', 'hide');
        if ($('#MarketingRocketMain').find('.haschild').length === 0 && $('#MarketingRocketMain').find('.added-element').length === 0) {
            $('#MarketingRocketMain').addClass('preview');
        };
    });
    $t.modal('#MR-CM', 'show');
};
MR_landing.prototype.forceDelete = function(el) {
    var $t = this;
    var $ = jQuery;
    if (el == undefined)
        var el = $t.activeEl;
    else if (typeof el != 'object')
        var el = $(el);
    if (el == null)
        return;
    el = $(el);
    var type = el.attr('aria-type');
    if (type == 'articlebox') {
        var editorName = el.find('.content').data('editor');
        CKEDITOR.instances[editorName].destroy();
    };
    var id = $(el).attr('id');
    $t.inlineCss[id] = undefined;
    var removeFunc = type + 'Removed';
    if ($t[removeFunc] != undefined) {
        $t[removeFunc](el);
    };
    if ($(el).hasClass('container-fluid')) {
        var targetEl = $(el).parent();
        if (targetEl.parent().hasClass('container-fluid') && targetEl.parent().hasClass('haschild')) {
            el = targetEl;
            targetEl = $(el).parent();
        };
        $t.togglePreviewEl(targetEl);
        $(el).remove();
    } else if ($(el).hasClass('row-fluid')) {
        $(el).remove();
    } else {
        if (!$(el).hasClass('added-element'))
            el = $(el).find('.added-element:first');
        var targetEl = $(el).parents('.row-fluid:first');
        $t.activeEl = $(el).parent();
        var container = $t.activeEl.parents('.container-fluid:first');
        if ($($t.activeEl).find(' > .added-element').length == 1 && $($t.activeEl).find(' > .row-fluid').length == 0 && !$($t.activeEl).parent().hasClass('box-container')) {
            $($t.activeEl).remove();
            $t.togglePreviewEl(targetEl);
        } else {
            $(el).remove();
            $t.makeTempDiv($t.activeEl, true);
        };
        if (container.find('.row-fluid').length === 0 || container.find('.added-element').length === 0) {
            container.remove();
        };
    };
};
MR_landing.prototype.buttonboxDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'buttonbox');
    $(box).removeClass('simplebox').addClass('buttonbox');
    var content = '<div class="content"><div class="col-md-5 span5 box"><h2 class="">Main Description...</h2></div><div class="col-md-1 span1 box"><span class="figure">}</span></div><div class="col-md-5 span5 box"><a style="display:none"><img /></a></div></div>';
    $(box).html(content);
    var a = $('<a href="" class="btn btn-primary btn-lg btn-large target-btn"><span>Download</span></a>');
    a.attr('id', $t.randString(6)).prepend('<i class="fa"></i>').attr('aria-mainclass', 'btn btn-primary btn-lg btn-large').prependTo($(box).find('.box:last'));
    $t.addAdminsBtns(box);
    var a = $t.ce('a');
    var i = $t.ce('i');
    $(i).addClass('fa fa-download').appendTo(a);
    $(a).attr('data-original-title', COM_MARKETINGROCKET_BUTTON_STYLE).css("right", "100px").addClass('MR_Admin hasTooltip button-setting btn-mini btn')
    $(box).append(a);
    $(a).tooltip({
        container: 'body'
    });
    $t.customSetting(box, 'fa-download', COM_MARKETINGROCKET_BUTTONBOX_SETTINGS);
    $t.buttonboxFunctions(box);
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.buttonboxFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    var content = $($t.buttonBoxSetting).clone(true);
    $(box).find('a.MR_Admin.button-setting').click(function() {
        $t.activeEl = $(this).parent().find('a[aria-mainclass]');
        $t.modal('#MR_buttong_setting_modal', 'show');
        setTimeout(function() {
            $t.buttonFillPopCss()
        }, 600);
    });
    $(box).find('a.MR_Admin:last').click(function() {
        var content = $($t.imageBoxSetting).clone(true);
        var saveFunction = function() {
            $t.saveCustomImageBox();
        };
        var beforeShowFunction = function() {
            $t.beforeShowPopUpImageBox();
        };
        $t.activeEl = $(this).parent().find('.col-md-5').find('a:first');
        $t.customSettingFunctions(box, COM_MARKETINGROCKET_IMAGEBUTTON_SETTINGS, content, saveFunction, beforeShowFunction, $(this))
    })
    var saveFunction = function() {
        $t.saveCustomDownloadBox();
    };
    var beforeShowFunction = function() {
        $t.beforeShowPopUpDownloadBox();
    };
    $t.customSettingFunctions(box, COM_MARKETINGROCKET_BUTTONBOX_SETTINGS, content, saveFunction, beforeShowFunction);
};
MR_landing.prototype.beforeShowPopUpDownloadBox = function() {
    var $t = this;
    var $ = jQuery;
    $('#MR-CM').find('input[type="radio"]').unbind('click').click(function() {
        if ($(this).val() == 'url') {
            $(this).parents('.control-group').next().show();
        } else
            $(this).parents('.control-group').next().hide();
    });
    var button = $($t.activeEl).find('.content a.btn');
    $('#left-section-text').val($($t.activeEl).find('.content h2').html());
    $('#button-text').val(button.text());
    $('#figure-text').val($($t.activeEl).find('.content span.figure').text());
    $('#button-type').unbind('change').change(function() {
        var el = $($t.activeEl).find('.button-setting');
        if ($(this).val() != 'text') {
            $(this).parents('.control-group').next().hide();
            el.addClass('hidden');
            el.next().removeClass('hidden');
        } else {
            $(this).parents('.control-group').next().show();
            el.removeClass('hidden');
            el.next().addClass('hidden');
        };
    });
    var href = button.attr('href');
    if (href != undefined)
        $('#click-job-url').click();
    else
        $('#click-job-form').click();
    $('#button_url').val(href);
    $('#MR-DONE').text('Save');
};
MR_landing.prototype.saveCustomDownloadBox = function() {
    var $t = this;
    var $ = jQuery;
    var button = $($t.activeEl).find('.content a.btn');
    var imgButton = $(button).next();
    if ($.trim($('#left-section-text').val()).length > 0) {
        $($t.activeEl).find('.col-md-5:first,.col-md-1:first').show();
        $($t.activeEl).find('.col-md-11:last').attr('class', 'col-md-5 span5 box');
        $($t.activeEl).find('.btn-primary').addClass('pull-right');
    } else {
        $($t.activeEl).find('.col-md-5:first,.col-md-1:first').hide();
        $($t.activeEl).find('.col-md-5:last').attr('class', 'col-md-11 span11 text-center');
        $($t.activeEl).find('.btn-primary').removeClass('pull-right');
    };
    $($t.activeEl).find('.content h2').html($('#left-section-text').val());
    $($t.activeEl).find('.content span.figure').text($('#figure-text').val());
    if ($('#button-type').val() == 'text') {
        button.show();
        imgButton.hide();
        button.text($('#button-text').val());
        if ($('#click-job-url').is(':checked'))
            button.attr('href', $('#button_url').val()).removeAttr('onclick').attr('target', $('#open_target').val());
        else
            button.removeAttr('href').attr('onclick', 'showFormPopUp()');
    } else {
        button.hide();
        imgButton.show();
        if ($('#click-job-url').is(':checked'))
            imgButton.attr('href', $('#button_url').val()).removeAttr('onclick').attr('target', $('#open_target').val());
        else
            imgButton.removeAttr('href').attr('onclick', 'showFormPopUp()');
    };
    $t.modal('#MR-CM', 'hide');
};
MR_landing.prototype.imageboxDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var div = $t.createBox('div', className);
    var imgId = $t.randString(8);
    $(div).attr('aria-type', 'imagebox').addClass('added-element imagebox');
    var img = $t.ce('img');
    $(img).css('max-width', '100%').attr('src', locationOfJoomla + '/media/com_marketingrocket/your-image-here.jpg').addClass('inside-item').attr('id', imgId).appendTo(div);
    $t.addAdminsBtns(div);
    $t.customSetting(div, 'fa-picture-o', COM_MARKETINGROCKET_IMAGEBOX_SETTINGS);
    $t.customSetting(div, 'fa-gear', $t.lang('COM_MARKETINGROCKET_IMAGEBOX_STYLE_SETTINGS'));
    $t.imageboxFunctions(div);
    $t.addToParent(div, parent, className);
    return div;
};
MR_landing.prototype.imageboxFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    if ($(box).find('.MR_Custom').length == 1) {
        $t.customSetting(box, 'fa-gear', $t.lang('COM_MARKETINGROCKET_IMAGEBOX_STYLE_SETTINGS'));
    }
    $(box).find('.MR_Custom:last').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpImageBox();
        $t.modal('#imagebox-setting-template', 'show');
    });
    $(box).find('.MR_Custom:first').click(function() {
        $t.activeEl = $(box).find('img');
        $t.showAdminPopup();
    });
};
MR_landing.prototype.beforeShowPopUpImageBox = function() {
    var $t = this;
    var $ = jQuery;
    var el = $t.activeEl.find('img');
    $('#jform_image_src').val(el.attr('src')).unbind('keyup').unbind('blur').keyup(function() {
        $t.activeEl.find('img').attr('src', $t.fixImageSrc($(this).val()));
    }).blur(function() {
        $(this).keyup();
    }).change(function() {
        $(this).keyup();
    });
    $('#jform_full_image_src').val(el.attr('data-src')).unbind('keyup').unbind('blur').keyup(function() {
        if ($(this).val() == '')
            $t.activeEl.find('img').removeAttr('data-src');
        else
            $t.activeEl.find('img').attr('data-src', $t.fixImageSrc($(this).val()));
    }).blur(function() {
        $(this).keyup();
    }).change(function() {
        $(this).keyup();
    });
    $('#image-alt').val(el.attr('alt')).unbind('blur').blur(function() {
        $t.activeEl.find('img').attr('alt', $(this).val());
    });
    var style = el.attr('style');
    $('#image_max_width').val('');
    $('#image_border-radius').val('');
    if (style === undefined || style === '') {
        $('#image_max_width').val('100%');
        $('#image_border-radius').val($t.getDimension(null, $('#image_border-radius')));
    } else {
        style = style.split(';');
        for (var i = 0; i < style.length; i++) {
            var row = style[i].split(':');
            if ($.trim(row[0]) === 'max-width') {
                $('#image_max_width').val($t.getDimension($.trim(row[1]), $('#image_max_width')));
            } else if ($.trim(row[0]) === 'border-radius') {
                $('#image_border-radius').val($t.getDimension($.trim(row[1]), $('#image_border-radius')));
            };
        };
    };
    $('#image_max_width').unbind('keyup').unbind('blur').keyup(function() {
        var el = $t.activeEl.find('img');
        var val = $(this).val();
        el.css('max-width', $t.setDimensionValue(val, $(this)));
        if ($(this).val() != '') {
            el.css('height', 'auto');
        } else
            el.css('height', '');
    }).blur(function() {
        $(this).keyup();
    });
};
MR_landing.prototype.addToParent = function(box, parentNode, className) {
    var $t = this;
    var $ = jQuery;
    var id = $(box).attr('id');
    if (id == undefined || id == '') {
        var id = $t.randString(6);
        $(box).attr('id', id);
    };
    if ($t.isChildAdded) {
        $(box).appendTo(parentNode);
        return;
    };
    $t.makeDraggable(box);
    if ($t.isReplace) {
        $(box).attr('id', $t.reservedId);
        $t.reservedId = false;
        parentNode.replaceWith(box);
        $t.activeEl = $(box);
        $t.isReplace = false;
        if ($(box).parents('.box-container').length == 0)
            $t.makeResizable(box);
        return;
    };
    $(parentNode).addClass('haschild');
    $(parentNode).parents('.container-fluid:first').addClass('haschild');
    if ($(parentNode).parent().parent().hasClass('container-fluid'))
        $(parentNode).parent().parent().addClass('haschild');
    if ((className == 12 || (className * -1) == 12) && $(parentNode).find('.added-element').length > 0) {
        var div;
        if ($(parentNode).parent().hasClass('row-fluid')) {
            div = $t.createRow($(parentNode).parent(), true);
        } else {
            div = $t.createRow(parentNode, true);
        };
        $(div).append(box);
        $(div).addClass('haschild');
    } else if ($(parentNode).find('.added-element').length > 0) {
        if (className == undefined)
            var className = $t.getChildWithSize(parentNode);
        if (className == 0) {
            className = 12;
            $(parentNode).find('.row-fluid:last .added-element').each(function() {
                var rowClass = $(this).attr('class');
                var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
                res = parseInt(res[3]);
                className = className - res;
            });
            if (className > 0) {
                $(parentNode).find('.row-fluid:last').append(box);
            } else {
                $(box).insertBefore($(parentNode).find(' > .el-button-holder'));
            };
        } else {
            if ($(parentNode).find(' > .el-button-holder').length > 0)
                $(box).insertBefore($(parentNode).find(' > .el-button-holder'));
            else
                $(parentNode).append(box);
        };
    } else if ($(parentNode).find(' > .el-button-holder').length > 0) {
        $(box).insertBefore($(parentNode).find(' > .el-button-holder'));
    } else
        $(box).appendTo(parentNode);
    if ($(box).parents('.box-container').length == 0)
        $t.makeResizable(box);
    var sortableParent = $(parentNode).parents('.sortable:first');
    if (sortableParent.find('> div').not('.haschild').length == 0) {
        var containerDiv = $t.createContainer(sortableParent);
        var div = $t.ce('div');
        $(div).addClass('row-fluid droppable').prependTo(containerDiv).droppable($t.dropObj);
        $(div).attr('id', $t.randString(6));
        $t.addAdminsBtns(div, false);
    };
    $('.cke:visible').find('.cke_button__closebtn_icon').click();
};
MR_landing.prototype.makeDraggable = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).draggable({
        cancel: '.cant_drag',
        revert: "invalid",
        distance: 30,
        appendTo: "body",
        helper: function() {
            var type = $(this).attr('aria-type');
            if (type == 'box-container') {
                return $(this).clone();
            } else if ($(this).hasClass('button-holder')) {
                return $('#MR-SideBar').find('[aria-type="button"]').clone();
            };
            return $('#MR-SideBar').find('[aria-type="' + type + '"]').clone();
        },
        delay: 300,
        start: function(event, ui) {
            $(this).css('visibility', 'hidden');
            $('.droppable').addClass('active');
            $t.lastParent = $(this).parents('.droppable:first');
            $t.lastPrev = $(this).prev();
        },
        stop: function(event, ui) {
            $(this).css('visibility', 'visible').addClass('cant_drag');
            $('.droppable,.row-fluid').removeClass('active');
            ui.helper.css({
                'left': '',
                'top': '',
                'position': ''
            });
            setTimeout(function() {
                $t.lastPrev = false;
            }, 200);
        }
    });
};
MR_landing.prototype.makeResizable = function(box) {
    var $t = this;
    var $ = jQuery;
    var handles = 's,e';
    if (pageDirection == 'rtl') {
        handles = 's,w';
    }
    var options = {
        start: function(event, ui) {
            if (ui.element.attr('aria-free-size')) {
                ui.element.css('width', ui.element.width()).css('min-width', '');
            };
        },
        handles: handles
    };
    if (!$(box).attr('aria-free-size'))
        options.grid = [$(box).parent().width() / 12, 1];
    if ($(box).attr('aria-resize-handles') != undefined)
        options.handles = $(box).attr('aria-resize-handles');
    if ($(box).attr('aria-resize-alsoresize') != undefined)
        options.alsoResize = $(box).attr('aria-resize-alsoresize');
    try {
        $(box).resizable("destroy");
    } catch (e) {};
    $(box).resizable(options).unbind('resizestop').on('resizestop', function(event, ui) {
        var hApplied = false;
        var handles = $(this).attr('aria-resize-handles');
        if ($(this).hasClass('box-container')) {
            var currentH = ui.size.height;
            var row = $(this).find('.row-fluid:first');
            currentH = currentH - parseInt(row.css('margin-bottom')) - parseInt($(this).css('padding-top')) - parseInt($(this).css('padding-bottom'));
            row.css('min-height', currentH);
        };
        if (ui.originalSize.height != ui.size.height) {
            if (handles && handles.search('s') > -1) {
                $(this).css('height', '').css('min-height', ui.size.height);
                if ($(this).attr('aria-free-size') == undefined)
                    $(this).css('width', '');
                hApplied = true;
            }
        };
        if ($(this).attr('aria-free-size')) {
            var pSize = parseFloat($(this).parent().css('width'));
            var percent = (ui.size.width / pSize) * 100;
            if (percent > 100)
                percent = 100;
            $(this).css('min-width', percent + '%').css('width', '');
            return;
        };
        if ($t.history.length > 3)
            $t.history.pop();
        if (hApplied) {
            if ($t.dontAddToHistory === false) {
                var obj = {
                    type: 'resize',
                    resizeType: 'H',
                    ui: ui,
                    element: $(this).clone()
                };
                $t.history.unshift(obj);
                $('[onclick="Joomla.submitbutton(\'landing.undomove\')"]').removeClass('disabled');
            };
            return;
        };
        var firstW = ui.originalSize.width;
        var currentW = ui.size.width;
        var diff = firstW - currentW;
        var diff = diff / ($(this).parent().width() / 12);
        if (diff < 0 && diff > -1) {
            diff = -1;
        } else if (diff > 0 && diff < 1)
            diff = 1;
        else {
            diff = parseInt(diff);
        }
        $(this).css({
            'left': '',
            'top': '',
            'position': '',
            'width': '',
            'height': ''
        })
        $('.droppable.active').removeClass('active');
        if (diff == 0) {
            if ($t.deBugable)
                console.log('Diff Is Zero');
            return;
        };
        if (diff > 11) {
            if ($t.deBugable)
                console.log('Diff Is Greater Than 11 , diff Is ' + diff);
            return;
        };
        var rowClass = $(this).attr('class');
        try {
            var res = rowClass.match(/(\s+)(span{1})(\d{1,2})/i);
            res = parseInt(res[3]);
        } catch (e) {
            return;
        };
        $(this).removeClass('col-md-' + res).removeClass('span' + res);
        var oldSize = res;
        if (diff < 0)
            res = res + (-1 * diff);
        else
            res = res - diff;
        if (res < 0)
            res = -1 * res;
        else if (res == 0)
            res = 1;
        if ($t.dontAddToHistory === false) {
            var obj = {
                type: 'resize',
                resizeType: 'W',
                prevClassSize: oldSize,
                newClassSize: res,
                element: $(this).clone()
            };
            $t.history.unshift(obj);
            $('[onclick="Joomla.submitbutton(\'landing.undomove\')"]').removeClass('disabled');
        };
        $(this).addClass('col-md-' + res).addClass('span' + res);
        $(this).css('width', 'calc()');
        $(this).parent().find(' > .temp-div').remove();
        if (res < 12) {
            $t.makeTempDiv(this);
        } else {
            $(this).parents('.row-fluid.droppable').droppable($t.dropObj).droppable("enable");
        };
    });
};
MR_landing.prototype.makeTempDiv = function(el, isParent) {
    var $t = this;
    var $ = jQuery;
    var parent;
    if ($t.deBugable)
        console.log('itsIn :' + isParent);
    if (isParent === true)
        parent = $(el);
    else
        parent = $(el).parent();
    var tempSize = $t.getChildWithSize(parent);
    if (tempSize == 0 || tempSize == 12)
        return tempSize;
    var div = $t.ce('div');
    $(div).addClass('temp-div droppable ui-droppable col-md-' + tempSize + ' span' + tempSize);
    if (parent.find('> .el-button-holder').length > 0)
        $(div).insertBefore(parent.find('> .el-button-holder'));
    else
        $(parent).append(div);
    $(div).droppable($t.dropObj);
    parent.droppable($t.dropObj).droppable("disable");
    parent.find('row-fluid.droppable').droppable($t.dropObj).droppable("disable");
    parent.parents('.row-fluid.droppable').droppable($t.dropObj).droppable("disable");
    return true;
};
MR_landing.prototype.addSortingBtns = function(el) {
    var $t = this;
    var $ = jQuery;
    var a = $t.ce('a');
    var i = $t.ce('i');
    var additionalClass = '';
    var btnHolder = $(el).find('.el-button-holder').find('.MR_duplicate');
    if ($(el).hasClass('container-fluid'))
        additionalClass = ' btn-primary';
    $(i).addClass('fa fa-chevron-up').appendTo(a);
    $(a).attr('data-original-title', COM_MARKETINGROCKET_SORT_UP).addClass('MR_SORT_UP hasTooltip btn-mini btn' + additionalClass).insertBefore(btnHolder);
    $(a).tooltip({
        container: 'body'
    });
    var a = $t.ce('a');
    var i = $t.ce('i');
    $(i).addClass('fa fa-chevron-down').appendTo(a);
    $(a).attr('data-original-title', COM_MARKETINGROCKET_SORT_DOWN).addClass('MR_SORT_DOWN btn-mini btn hasTooltip' + additionalClass).insertBefore(btnHolder);
    $(a).tooltip({
        container: 'body'
    });
    $t.sortBtnFunctions(el);
};
MR_landing.prototype.sortBtnFunctions = function(el) {
    var $t = this;
    var $ = jQuery;
    $(el).find('.MR_SORT_UP:first').unbind('click').click(function() {
        var el = $(this).parent().parent();
        if (el.parent().hasClass('container-fluid') && el.parent().hasClass('haschild'))
            el = el.parent();
        if ($(el).prev().length > 0) {
            $(this).tooltip('hide');
            $(el).insertBefore($(el).prev());
        };
    })
    $(el).find('.MR_SORT_DOWN:first').unbind('click').click(function() {
        var el = $(this).parent().parent();
        if (el.parent().hasClass('container-fluid') && el.parent().hasClass('haschild'))
            el = el.parent();
        if ($(el).next().length > 0) {
            $(this).tooltip('hide');
            $(el).insertAfter($(el).next());
        };
    })
};
MR_landing.prototype.boxContainerDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.ce('div');
    $(box).addClass('col-md-' + className + ' span' + className + ' added-element box-container')
    $(box).attr('aria-type', 'box-container');
    var row = $t.createRow(box, true);
    $(row).addClass('droppable').droppable($t.dropObj);
    $t.addAdminsBtns(box);
    $t.addToParent(box, parent, className);
    $(box).parents('.row-fluid.droppable').droppable($t.dropObj).droppable("disable");
};
MR_landing.prototype.checkElementName = function(element, el) {
    var $t = this;
    var $ = jQuery;
    if ($t.cssFounded == 'break')
        return false;
    if ($t.cssFounded === true) {
        $t.writeCss();
        $('#jform_hidden_css').val(JSON.stringify($t.inlineCss));
        $t.cssFounded = 'break';
        return false;
    };
    if (element) {
        var name = $(el).attr('name');
        if (name == element.attr('name')) {
            $t.cssFounded = true;
            return true;
        };
        return false;
    };
    return true;
};
MR_landing.prototype.writeCss = function() {
    var $t = this;
    var $ = jQuery;
    var css = '';
    for (var i in $t.inlineCss) {
        if ($t.inlineCss[i] == undefined)
            continue;
        css += '#' + i + ' {\n';
        for (var s in $t.inlineCss[i].styles) {
            if ($t.validCSS(s, $t.inlineCss[i].styles[s]))
                css += s + ' : ' + $t.inlineCss[i].styles[s] + ';\n';
        };
        css += '}\n';
        if (objectSize($t.inlineCss[i].hover) > 0) {
            css += '#' + i + ':hover {\n';
            for (var s in $t.inlineCss[i].hover) {
                css += s + ' : ' + $t.inlineCss[i].hover[s] + ';\n';
            };
            css += '}\n';
        };
        if (objectSize($t.inlineCss[i].iconStyle) > 0) {
            css += '#' + i + ' > i {\n';
            for (var s in $t.inlineCss[i].iconStyle) {
                css += s + ' : ' + $t.inlineCss[i].iconStyle[s] + ';\n';
            };
            css += '}\n';
        };
        if (objectSize($t.inlineCss[i].iconStyleHover) > 0) {
            css += '#' + i + ':hover > i {\n';
            for (var s in $t.inlineCss[i].iconStyleHover) {
                css += s + ' : ' + $t.inlineCss[i].iconStyleHover[s] + ';\n';
            };
            css += '}\n';
        };
    };
    try {
        for (var i = 0; i < $t.cssOverRides.length; i++) {
            var st = $t.cssOverRides[i];
            css = $t[st](css);
        };
    } catch (e) {
        console.log(e);
    };
    $('#inlineCss').html(css);
};
MR_landing.prototype.validateCss = function() {
    var $t = this;
    var $ = jQuery;
    var newObj = {};
    for (var i in $t.inlineCss) {
        if ($t.inlineCss[i] == undefined)
            continue;
        var obj = {
            styles: {},
            hover: {},
            iconStyle: {},
            iconStyleHover: {}
        };
        for (var s in $t.inlineCss[i].styles) {
            if ($t.validCSS(s, $t.inlineCss[i].styles[s]))
                obj.styles[s] = $t.inlineCss[i].styles[s];
        };
        if (objectSize($t.inlineCss[i].hover) > 0) {
            for (var s in $t.inlineCss[i].hover) {
                if ($t.validCSS(s, $t.inlineCss[i].hover[s]))
                    obj.hover[s] = $t.inlineCss[i].hover[s];
            };
        };
        if (objectSize($t.inlineCss[i].iconStyle) > 0) {
            for (var s in $t.inlineCss[i].iconStyle) {
                if ($t.validCSS(s, $t.inlineCss[i].iconStyle[s]))
                    obj.iconStyle[s] = $t.inlineCss[i].iconStyle[s];
            };
        };
        if (objectSize($t.inlineCss[i].iconStyleHover) > 0) {
            for (var s in $t.inlineCss[i].iconStyleHover) {
                if ($t.validCSS(s, $t.inlineCss[i].iconStyleHover[s]))
                    obj.iconStyleHover[s] = $t.inlineCss[i].iconStyleHover[s];
            };
        };
        newObj[i] = obj;
    };
    try {
        for (var i = 0; i < $t.cssOverRides.length; i++) {
            var st = $t.cssOverRides[i];
            newObj = $t[st](newObj);
        };
    } catch (e) {
        console.log(e);
    };
    $('#jform_hidden_css').val(JSON.stringify(newObj));
};
MR_landing.prototype.setColor = function(color, target) {
    var $t = this;
    var $ = jQuery;
    if (color == 'initial')
        return '';
    if (color == '' || color == undefined) {
        $(target).val('');
        return;
    };
    if (color.slice(0, 1) == 'r') {
        var cObj = $t.createRGBobject(color);
        $(target).val(color).ColorPickerSetColor(cObj);
    } else {
        $(target).val(color).ColorPickerSetColor(color);
    };
};
MR_landing.prototype.createRGBobject = function(color) {
    var $t = this;
    var $ = jQuery;
    var cObj = {};
    var cArray = color.replace('rgba', '');
    cArray = cArray.replace('rgb', '');
    cArray = cArray.replace('(', '');
    cArray = cArray.replace(')', '');
    cArray = cArray.split(',');
    cObj.r = cArray[0];
    cObj.g = cArray[1];
    cObj.b = cArray[2];
    if (cArray[3] != undefined)
        cObj.o = $.trim(cArray[3]);
    else
        cObj.o = 1;
    return cObj;
};
MR_landing.prototype.setBackgroundColor = function(color, target) {
    var $t = this;
    var $ = jQuery;
    if (color == 'initial')
        return '';
    var checkbox = $(target).parents('.control-group').next().find('input[type="checkbox"]');
    $(checkbox).prop('checked', false).change();
    $(target).val('');
    if (color == undefined || color == '')
        return;
    if (color.slice(0, 1) == 'r') {
        var cObj = $t.createRGBobject(color);
        $(target).val(color).ColorPickerSetColor(cObj);
    } else if (color == 'transparent') {
        $(checkbox).prop('checked', true).change();
    } else {
        $(target).val(color);
    };
};
MR_landing.prototype.beforeShowPopUpButton = function() {
    var $t = this;
    var $ = jQuery;
    SqueezeBox.assign($$($('#jform_image_src').next()[0]), {
        parse: 'rel'
    });
    var el = $t.activeEl.find('img');
    $('#jform_image_src').val(el.attr('src'));
    $('#image-alt').val(el.attr('alt'));
    var style = el.attr('style');
    $('#image_max_width,#image_border-radius').val('');
    if (style === undefined || style === '') {
        $('#image_max_width').val('100%');
        $('#image_border-radius').val('0');
    } else {
        style = style.split(';');
        for (var i = 0; i < style.length; i++) {
            var row = style[i].slice(':');
            if ($.trim(row[0]) === 'max-width') {
                $('#image_max_width').val(row[1]);
            } else if ($.trim(row[0]) === 'border-radius') {
                $('#image_border-radius').val(row[1]);
            };
        };
    };
    $('#MR-DONE').text('Save');
};
MR_landing.prototype.saveCustomButton = function() {
    var $t = this;
    var $ = jQuery;
    var el = $t.activeEl.find('img:first');
    if ($('#jform_image_src').val().substr(0, 1) != '/')
        el.attr('src', $t.locationOfJoomla + '/' + $('#jform_image_src').val());
    el.attr('alt', $('#image-alt').val());
    $t.modal('#MR-CM', 'hide');
};
MR_landing.prototype.randString = function(n) {
    var $t = this;
    if (!n) {
        n = 5;
    };
    n--;
    var text = 'a';
    var possible = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    for (var i = 0; i < n; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    };
    text = 'MR_' + text;
    return text;
};
MR_landing.prototype.makeHex = function(color) {
    var $t = this;
    if (color == undefined)
        color = '';
    if (color && color.slice(0, 1) == 'r') {
        color = $t.rgb2hex(color);
    };
    return color;
};
MR_landing.prototype.css = function(a, hoverClass) {
    var $t = this;
    var $ = jQuery;
    var sheets = document.styleSheets;
    var o = {};
    for (var i in sheets) {
        try {
            var rules = sheets[i].rules || sheets[i].cssRules;
            for (var r in rules) {
                if (rules[r].selectorText == undefined || rules[r].selectorText.search(':before') > 0 || rules[r].selectorText.search(':after') > 0)
                    continue;
                try {
                    var text = rules[r].selectorText;
                    if (hoverClass) {
                        text = text.replace(':hover', '', 'g');
                        text = text.replace(':link', '', 'g');
                        text = text.replace(':visited', '', 'g');
                        text = text.replace(':active', '', 'g');
                        text = text.replace(':focus', '', 'g');
                    } else {
                        text = text.split(',');
                        newText = [];
                        for (var i = 0; i < text.length; i++) {
                            if (text[i].search(':') > -1 && text[i].search(':first-child') < 0) {
                                continue;
                            };
                            newText.push(text[i]);
                        };
                        text = newText.join(',');
                    };
                    if (a.is(text)) {
                        o = $.extend(o, $t.css2json(rules[r].style));
                    };
                } catch (e) {};
            };
        } catch (e) {};
    };
    o = $.extend(o, $t.css2json(a.attr('style')));
    if ($t.inlineCss[$(a).attr('id')])
        o = $.extend(o, $t.inlineCss[$(a).attr('id')].styles);
    return o;
};
MR_landing.prototype.css2json = function(css) {
    var $t = this;
    var $ = jQuery;
    var s = {};
    if (!css) return s;
    if (typeOf(css) == 'object' || typeOf(css) == 'collection') {
        for (var i in css) {
            if ((css[i]).toLowerCase) {
                var name = $t.makeStringReady(i);
                if (css[name] == '')
                    continue;
                s[name] = (css[name]);
            };
        };
    } else if (typeof css == "string") {
        try {
            css = css.split(";");
            for (var i in css) {
                var l = css[i].split(":");
                var name = $t.makeStringReady(l[0].toLowerCase());
                if (name == '')
                    continue;
                s[name] = $.trim(l[1]);
            };
        } catch (e) {};
    };
    return s;
};
MR_landing.prototype.makeStringReady = function(name) {
    name = jQuery.trim(name);
    if (name.search('-') > 0) {
        name = name.split('-');
        for (var i = 1; i < name.length; i++) {
            name[i] = ucfirst(name[i]);
        };
        name = name.join('');
    };
    return name;
};
MR_landing.prototype.applyCss = function() {
    var $t = this;
    var $ = jQuery;
    if ($('#additionalCss').length == 0) {
        var style = $t.ce('style');
        $(style).attr('id', 'additionalCss').appendTo('head');
    };
    $('#additionalCss').html($('#jform_css').val());
};
MR_landing.prototype.setBoxShadow = function(selector) {
    var $t = this;
    var $ = jQuery;
    var parent = $(selector);
    var str = '';
    var val = parent.find('input[type="radio"]:checked').val();
    val = (val == 'yes') ? 'inset ' : ' ';
    var color = parent.find('input[data-boxshaow="color"]').val();
    color = $t.hex2rgb(color);
    str += val +
        parent.find('input[data-boxshaow="horizontal"]').val() + 'px ' +
        parent.find('input[data-boxshaow="vertical"]').val() + 'px ' +
        parent.find('input[data-boxshaow="blur"]').val() + 'px ' +
        parent.find('input[data-boxshaow="spread"]').val() + 'px ' + 'rgba(' + color.join(',') + ',' +
        (parent.find('input[data-boxshaow="opacity"]').val() / 100) + ')';
    str = $.trim(str);
    console.log(str);
    parent.find('.box-shadow-holder input').val(str).blur();
};
MR_landing.prototype.getBoxShadow = function(selector, val) {
    var $t = this;
    var $ = jQuery;
    var parent = $(selector);
    var radios = parent.find('input[type="radio"]');
    radios.unbind('click').prop('checked', 'false');
    parent.find('.active.btn-success').removeClass('active btn-success');
    if (val.search('inset') > -1) {
        $(radios[0]).prop('checked', true);
        parent.find('.btn:first').addClass('active btn-success');
    } else {
        $(radios[1]).prop('checked', true);
        parent.find('.btn:last').addClass('active btn-success');
    };
    radios.click(function() {
        $t.setBoxShadow(selector);
    });
    var rgba = val.match(/rgba\((\d+),\s*(\d+),\s*(\d+),\s*(.+)\)/)
    if (rgba != null) {
        var color = "#" + hex(rgba[1]) + hex(rgba[2]) + hex(rgba[3]);
        var opacity = rgba[4] * 100;
        val = val.replace(rgba[0], '');
    } else {
        var color = "#ffffff";
        var opacity = 0;
    };
    parent.find('[data-boxshaow="color"]').ColorPickerSetColor(color).val(color).unbind('blur').keyup(function() {
        $t.setBoxShadow(selector);
    });
    parent.find('[data-boxshaow="opacity"]').val(opacity);
    val = val.replace('inset');
    val = $.trim(val);
    val = val.split(' ');
    if (val.length > 1) {
        parent.find('[data-boxshaow="horizontal"]').val($t.parseInt(val[0]));
        parent.find('[data-boxshaow="vertical"]').val($t.parseInt(val[1]));
        parent.find('[data-boxshaow="blur"]').val($t.parseInt(val[2]));
        parent.find('[data-boxshaow="spread"]').val($t.parseInt(val[3])).keyup();
    } else {
        parent.find('[data-boxshaow="horizontal"]').val(0);
        parent.find('[data-boxshaow="vertical"]').val(0);
        parent.find('[data-boxshaow="blur"]').val(0);
        parent.find('[data-boxshaow="spread"]').val(0).keyup();
    };
};
MR_landing.prototype.parseInt = function(val) {
    var v = parseInt(val);
    if (typeOf(v) === 'number')
        return v;
    return 0;
};
MR_landing.prototype.modal = function(selector, type) {
    var $t = this;
    var $ = jQuery;
    if (selector == '#MR-CM' || selector == '#Setting_modal' || selector == '#code_editor_modal') {
        $(selector).modal(type);
        return true;
    };
    var h = $(window).outerHeight() + 4 -
        $('.header:first').outerHeight() -
        $('#status').outerHeight() -
        $('.navbar').outerHeight() -
        $('.subhead-collapse:first').find('.container-fluid:first').outerHeight();
    $('#side_setting').css('height', h);
    if (pageType == 'responder')
        $('#side_setting').css('top', '0px');
    $('#side_setting').removeClass('def-page');
    if (type == 'show') {
        $('#side_setting').find('.nano-content > div').hide();
        $('#side_setting').addClass('open');
        $('.all-container').addClass('mini');
        setTimeout(function() {
            $(selector).show();
            $(".nano").nanoScroller('reset');
        }, 500);
        if (selector == '#MR-landing-setting') {
            $('#side_setting').addClass('def-page');
        };
        $('body').addClass('side-menu-open');
    } else {
        $(selector).hide();
        $('#side_setting').removeClass('open');
        $('.all-container').removeClass('mini');
        $('body').removeClass('side-menu-open');
    };
};
MR_landing.prototype.fillGradient = function(gradient, target) {
    var $t = this;
    var $ = jQuery;
    var origText = gradient;
    if (gradient != '' && gradient != undefined && gradient.split(',').length > 1 && gradient.search('linear-gradient\\(') > -1) {
        gradient = gradient.replace('linear-gradient(', '');
        gradient = gradient.replace('repeat scroll 0% 0% transparent', '');
        gradient = gradient.substr(0, gradient.length - 1);
        gradient = gradient.split(',');
        var ori = gradient.shift();
        if (ori.search('bottom') === -1 && ori.search('top') === -1 && ori.search('right') === -1 && ori.search('left') === -1) {
            gradient.unshift(ori);
        };
        var select = target.parent().find('select');
        if (ori.search('bottom') > -1) {
            select.val('vertical');
        } else {
            select.val('horizontal');
        };
        gradient = gradient.join(',');
        var rgb = gradient.match(/rgb\((\d+),\s*(\d+),\s*(\d+)\)/g);
        var havePercent = true;
        if (gradient.search('%') === -1)
            havePercent = false;
        if (rgb != null) {
            for (var i = 0; i < rgb.length; i++) {
                var colors = rgb[i].match(/rgb\((\d+),\s*(\d+),\s*(\d+)\)/);
                var color = "#" + hex(colors[1]) + hex(colors[2]) + hex(colors[3]);
                if (rgb.length === 2 && havePercent == false) {
                    if (i === 0) {
                        color += ' 0%';
                    } else {
                        color += ' 100%';
                    };
                };
                gradient = gradient.replace(rgb[i], color);
            };
        };
        if (gradient != '')
            target.data('ClassyGradient').setGradient(gradient);
        target.parent().find('textarea').val(origText);
        select.change();
        return gradient;
    } else {
        gradient = '#c400c4 0%, #570057 98%';
        target.data('ClassyGradient').setGradient(gradient);
        target.parent().find('textarea').val('');
        return gradient;
    };
};
MR_landing.prototype.getArticleEditor = function() {
    var $t = this;
    var $ = jQuery;
    for (var i = 0; i < tinyMCE.editors.length; i++) {
        if (tinyMCE.editors[i].id == 'jform_articletext') {
            $t.editorCounter = i;
            break;
        };
    };
};
MR_landing.prototype.extractBorders = function(css, colorSelector, widthSelector, styleSelector) {
    var $t = this;
    var $ = jQuery;
    if (css.borderColor != undefined) {
        var color = css.borderColor;
    } else {
        if (css.borderTopColor) {
            var color = css.borderTopColor;
        };
        if (css.borderRightColor) {
            var color = css.borderRightColor;
        };
        if (css.borderBottomColor) {
            var color = css.borderBottomColor;
        };
        if (css.borderLeftColor) {
            var color = css.borderLeftColor;
        };
    };
    $t.setColor(color, colorSelector);
    var width = css.borderTopWidth + ' ' + css.borderRightWidth + ' ' + css.borderBottomWidth + ' ' + css.borderLeftWidth;
    width = width.replace('undefined', '0px', 'g');
    $(widthSelector).val(width);
    if (css.borderStyle != undefined) {
        var style = css.borderStyle;
    } else {
        if (css.borderTopStyle) {
            var style = css.borderTopStyle;
        };
        if (css.borderRightStyle) {
            var style = css.borderRightStyle;
        };
        if (css.borderBottomStyle) {
            var style = css.borderBottomStyle;
        };
        if (css.borderLeftStyle) {
            var style = css.borderLeftStyle;
        };
    };
    $(styleSelector).val(style).chosen('destroy').chosen();
};
MR_landing.prototype.validCSS = function(property, value) {
    if (value == 'transparent' || value == 'none')
        return true;
    if (value.search('!important') > -1)
        return true;
    var $ = jQuery;
    var div = $("<div>");
    var _old = div.css(property);
    div.css(property, value);
    var _new = div.css(property);
    if (_old != _new) {
        return true;
    } else if (value == '0px' && _old == '0px')
        return true;
    return false;
};
MR_landing.prototype.duplicateCss = function(fromId, toId, fields, clearParent) {
    var $t = this;
    var $ = jQuery;
    var arr = ['hover', 'styles', 'iconStyle', 'iconStyleHover'];
    try {
        $(arr).each(function() {
            for (var i in $t.inlineCss[fromId][this]) {
                if (fields != undefined) {
                    if (!$.inArray(i, fields) < 0) {
                        continue;
                    };
                };
                $t.inlineCss[toId][this][i] = $t.inlineCss[fromId][this][i];
                if (clearParent === true)
                    $t.inlineCss[fromId][this][i] = '';
            };
        })
    } catch (e) {
        console.log(e);
    };
};
MR_landing.prototype.duplicateEl = function(el) {
    var $t = this;
    var $ = jQuery;
    $t.dontAddToHistory = true;
    if (el.hasClass('container')) {
        var newContiner = $($t.createContainer());
        newContiner.addClass('duplicated haschild');
        var parent = el;
        if (parent.parent().hasClass('container-fluid'))
            parent = parent.parent();
        if ($('#MarketingRocket').is(':visible')) {
            newContiner.parent().addClass('haschild').insertAfter(parent);
            if (el.parent().hasClass('container-fluid')) {
                $t.duplicateCss(parent.attr('id'), newContiner.parent().attr('id'));
            };
            $t.duplicateCss(el.attr('id'), newContiner.attr('id'));
        } else {
            newContiner.insertAfter(parent);
            if (el.parent().hasClass('container-fluid')) {
                $t.duplicateCss(parent.attr('id'), newContiner.attr('id'));
            } else {
                $t.duplicateCss(el.attr('id'), newContiner.attr('id'));
            };
        };
        var div = $t.ce('div');
        $(div).attr('id', $t.randString(6));
        $(div).addClass('row-fluid droppable').prependTo(newContiner).droppable($t.dropObj);
        $t.addAdminsBtns(div, false);
        $t.writeCss();
    } else {
        var newDiv = el.clone();
        var id = $t.randString(6);
        newDiv.attr('id', id);
        newDiv.find('.ui-resizable-handle').remove();
        newDiv.removeClass('ui-draggable ui-resizable');
        $(newDiv).find('.hasTooltip').tooltip({
            container: 'body'
        });
        $t.adminsBtnsFuntions(newDiv);
        var type = $(newDiv).attr('aria-type');
        if ($t[type + 'Functions'] != undefined)
            $t[type + 'Functions'](newDiv);
        $t.createCssObj(id, newDiv);
        $t.duplicateCss(el.attr('id'), id);
        $t.writeCss();
        $t.lastParent = el.parents('.droppable:first');
        if (el.parent().find('.temp-div').length > 0)
            $t.dropFunction('', {
                draggable: newDiv
            }, el.parent().find('.temp-div:first'));
        else
            $t.dropFunction('', {
                draggable: newDiv
            }, $t.lastParent[0]);
        var dragPoint = newDiv.find('.drag-point');
        $t.dragPointFunctions(dragPoint);
        $t.makeDraggable(newDiv);
    };
    if (el.attr('aria-type') == 'box-container' || el.hasClass('button-holder') || el.hasClass('complex-item')) {
        newDiv.find('.added-element').each(function() {
            var newDiv = $(this);
            var oldId = newDiv.attr('id');
            var id = $t.randString(6);
            newDiv.attr('id', id);
            newDiv.find('.ui-resizable-handle').remove();
            newDiv.removeClass('ui-draggable ui-resizable');
            newDiv.find('.hasTooltip').tooltip({
                container: 'body'
            });
            $t.adminsBtnsFuntions(newDiv);
            var type = newDiv.attr('aria-type');
            if ($t[type + 'Functions'] != undefined)
                $t[type + 'Functions'](newDiv);
            $t.createCssObj(id, newDiv);
            $t.duplicateCss(oldId, id);
            $t.writeCss();
            var dragPoint = newDiv.find('.drag-point');
            $t.dragPointFunctions(dragPoint);
            $t.makeDraggable(newDiv);
        });
    };
    $t.dontAddToHistory = false;
};
MR_landing.prototype.fixImageSrc = function(src) {
    var $t = this;
    var $ = jQuery;
    var r = new RegExp('^(?:[a-z]+:)?//', 'i');
    var l = $t.locationOfJoomla.length + 1;
    if (!r.test(src) && src.substr(0, l) != $t.locationOfJoomla + '/') {
        src = $t.locationOfJoomla + '/' + src;
    };
    return src;
};
MR_landing.prototype.getDimension = function(val, el) {
    var $t = this;
    if (val == undefined) {
        $t.handleInputAfter(val, el, 'show');
        return '';
    };
    if (val.search('px') > -1) {
        $t.handleInputAfter(val, el, 'show');
        return val.replace('px', '');
    };
    var r = /[a-zA-Z%]$/;
    if (val.match(r) != null) {
        $t.handleInputAfter(val, el, 'hide');
    } else {
        $t.handleInputAfter(val, el, 'show');
    };
    return val;
};
MR_landing.prototype.setDimensionValue = function(val, el) {
    var $t = this;
    if (val == undefined) {
        $t.handleInputAfter(val, el, 'show');
        return '';
    };
    val = jQuery.trim(val);
    var r = /[a-zA-Z%]$/;
    if (val.match(r) != null) {
        $t.handleInputAfter(val, el, 'hide');
        return val;
    };
    $t.handleInputAfter(val, el, 'show');
    return val + 'px';
};
MR_landing.prototype.handleInputAfter = function(val, el, action) {
    var $t = this;
    var $ = jQuery;
    try {
        var next = el.next();
    } catch (e) {
        return true;
    };
    if (action == 'show') {
        if (next.length == 0 || !next.hasClass('px-holder')) {
            var span = $t.ce('span');
            $(span).addClass('px-holder').html('px').insertAfter(el);
        } else
            next.show();
    } else if (action == 'hide') {
        if (next.length == 1) {
            next.hide();
        };
    };
};
MR_landing.prototype.makeOffForElements = function(id, div, propery) {
    var $t = this;
    var $ = jQuery;
    $t.activeEl = $(div);
    var pr = propery || ['background-switch', 'border-switch', 'box_shadow-switch'];
    $t.createCssObj(id, $t.activeEl);
    $t.fillPopUpCss($t.activeEl);
    $(pr).each(function() {
        $('#' + this).prop('checked', false).change()
    })
};
MR_landing.prototype.lang = function(text) {
    if (__lang[text] == undefined)
        return text;
    return __lang[text];
};
MR_landing.prototype.createDragPoint = function(el) {
    var $t = this;
    var $ = jQuery;
    var dragPoint = $t.ce('div');
    $(dragPoint).addClass('drag-point').prependTo(el);
    $t.dragPointFunctions($(dragPoint));
};
MR_landing.prototype.dragPointFunctions = function(dragPoint) {
    var $t = this;
    var $ = jQuery;
    dragPoint.mousedown(function() {
        $(this).parents('.cant_drag').removeClass('cant_drag').addClass('allow_drag');
    }).mouseup(function() {
        $(this).parents('.allow_drag').addClass('cant_drag').removeClass('allow_drag');
    });
};
MR_landing.prototype.undo = function() {
    var $t = this;
    var $ = jQuery;
    if ($t.history.length == 0) {
        return;
    };
    var obj = $t.history[0];
    $t.history.shift();
    $t.dontAddToHistory = true;
    if (obj.type === 'first_drop') {
        if (obj.element.hasClass('row-fluid')) {
            $t.activeEl = $(obj.element).find('.added-element:last');
            $t.forceDelete();
            if ($('#MarketingRocketMain').find('.haschild').length === 0 && $('#MarketingRocketMain').find('.added-element').length === 0) {
                $('#MarketingRocketMain').addClass('preview');
            };
        };
    } else if (obj.type === 'drop') {
        var el = $('#' + obj.lastParent.attr('id'));
        if (el.length == 0) {
            if (obj.parentIndex == 0) {
                obj.lastParentParent.prepend(obj.lastParent);
            } else {
                var target = obj.lastParentParent.find(' > *').eq(obj.parentIndex - 1);
                obj.lastParent.insertAfter(target);
            };
        } else {
            el.replaceWith(obj.lastParent);
        };
        $t.undoCatch(obj.lastParent);
        $('#' + obj.newParent.attr('id')).replaceWith(obj.newParent);
        $t.undoCatch(obj.newParent);
        $('.droppable.active').removeClass('active');
        var target = $('#' + obj.element.attr('id'));
        target.css('visibility', 'visible');
    } else if (obj.type === 'resize') {
        var id = obj.element.attr('id');
        var el = $('#' + id);
        if (obj.resizeType === 'H') {
            el.css('min-height', obj.ui.originalSize.height);
        } else {
            var newClassSize = obj.newClassSize;
            var prevClassSize = obj.prevClassSize;
            el.removeClass('col-md-' + newClassSize).removeClass('span' + newClassSize).addClass('col-md-' + prevClassSize).addClass('span' + prevClassSize);
            if (el.next().hasClass('temp-div'))
                el.next().remove();
            else if (el.prev().hasClass('temp-div'))
                el.prev().remove();
            if (prevClassSize < 12) {
                $t.makeTempDiv(el);
            } else {
                el.parents('.row-fluid.droppable').droppable($t.dropObj).droppable("enable");
            };
        };
    };
    if ($t.history.length == 0) {
        $('[onclick="Joomla.submitbutton(\'landing.undomove\')"]').addClass('disabled');
    };
    $t.dontAddToHistory = false;
};
MR_landing.prototype.undoCatch = function(el) {
    var $t = this;
    var $ = jQuery;
    el.find('.added-element').each(function() {
        var type = $(this).attr('aria-type');
        $t.adminsBtnsFuntions(this);
        if ($t[type + 'Functions'] != undefined)
            $t[type + 'Functions'](this);
        if (type) {
            $t.makeDraggable(this);
        };
    });
    $t.adminsBtnsFuntions(el);
    $t.sortBtnFunctions(el);
    var cont = el.find('.container-fluid')
    if (cont.length > 0) {
        $t.adminsBtnsFuntions(cont);
        $t.sortBtnFunctions(cont);
    };
    el.find(".droppable").droppable($t.dropObj);
    el.find(".droppable.ui-droppable-disabled").droppable('disable');
    el.find('.ui-resizable').each(function() {
        if ($(this).is(':visible')) {
            $(this).find('.ui-resizable-handle').remove();
            $t.makeResizable(this);
        };
    });
    $(el).find('.hasTooltip').tooltip({
        container: 'body'
    });
};

function ucfirst(str) {
    str += '';
    var f = str.charAt(0).toUpperCase();
    return f + str.substr(1);
};

function alertr(ob) {
    var st = "";
    for (i in ob) {
        st += i + ":" + ob[i] + "\n";
    };
    alert(st);
};

function objectSize(obj) {
    var size = 0,
        key;
    for (key in obj) {
        if (obj.hasOwnProperty(key)) size++;
    };
    return size;
};

function hex(x) {
    return ("0" + parseInt(x).toString(16)).slice(-2);
};

function isInt(value) {
    var x;
    return isNaN(value) ? !1 : (x = parseFloat(value), (0 | x) === x);
};
intialize.push('timer');
MR_landing.prototype.timerDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'timer').addClass('timer_element');
    var div = $t.ce('div');
    var today = new Date();
    var dd = today.getDate() + 1;
    var mm = today.getMonth() + 1;
    var yyyy = today.getFullYear();
    if (dd < 10) {
        dd = '0' + dd
    }
    if (mm < 10) {
        mm = '0' + mm
    }
    var today = yyyy + '-' + mm + '-' + dd + ' 00:00:00';
    $(div).addClass('timer-holder').attr('id', $t.randString(6)).attr('data-date', today).attr('data-width', 800).attr('data-bigest', 'year').attr('data-background', '#000000').attr('data-color', '#ffffff').attr('data-timer-show', '').attr('data-timer-hide', '').attr('data-timezone', $t.defaultTimeZoneValue).attr('data-timezonestring', $t.defaultTimeZoneString).attr('data-timertype', '').attr('data-seconds', '0').attr('data-text-color', '#000000');
    $(box).append(div);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-clock-o', $t.lang('COM_MARKETINGROCKET_TIMER_EDIT_TITLE'));
    $t.timerFunctions(box);
    $t.addToParent(box, parent, className);
    $('#jform_bigest').val('year');
    $t.createTimer($(div));
    $t.resizeTimer($(div));
};
MR_landing.prototype.timerFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('a.MR_Custom').click(function() {
        $t.activeEl = $(box).find('.timer-holder');
        $t.beforeShowPopUpTimer();
        $t.modal('#timer_setting', 'show');
    });
};
MR_landing.prototype.beforeShowPopUpTimer = function() {
    var $t = this;
    var $ = jQuery;
    $t.intialize.push('timer');
    var t = $t.activeEl;
    $('#timer_setting > h3 > small').text('#' + t.attr('id'));
    if (t.attr('data-timertype') != undefined && t.attr('data-timertype') == 'timer') {
        $('#jform_timer_type1').next().click();
        $('#jform_timer_type1').click();
        var time = t.attr('data-seconds');
        var hour = 0;
        var min = 0;
        var sec = 0;
        if (time >= 3600) {
            hour = parseInt(time / 3600);
            time = time - (hour * 3600);
        };
        if (time >= 60) {
            min = parseInt(time / 60);
            time = time - (min * 60);
        };
        sec = time;
        $('#jform_time_hour').val(hour);
        $('#jform_time_minute').val(min);
        $('#jform_time_second').val(sec);
    } else {
        $('#jform_timer_type0').next().click();
        $('#jform_timer_type0').click();
        $('#jform_time_hour,#jform_time_minute,#jform_time_second').val(0);
    };
    $('#jform_time').val(t.attr('data-date'));
    $('#jform_bigest').val(t.attr('data-bigest')).chosen('destroy').chosen();
    $('#timer_width').slider('value', t.attr('data-width'));
    $('#timer_width_input').val(t.attr('data-width'));
    $('#jform_timer_background').val(t.attr('data-background')).ColorPickerSetColor(t.attr('data-background'));
    $('#jform_timer_color').val(t.attr('data-color')).ColorPickerSetColor(t.attr('data-color'));
    $('#jform_timer_after').val(t.attr('data-action')).change().chosen('destroy').chosen();
    $('#jform_timer_show').val(t.attr('data-timer-show'));
    $('#jform_timer_hide').val(t.attr('data-timer-hide'));
    $('#jform_line_color').val(t.data('line-color'));
    $('#jform_text_color').val(t.data('text-color'));
};
MR_landing.prototype.timer = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_time_btn').blur(function() {
        $t.activeEl.attr("data-date", $("#jform_time").val());
        var date_future = new Date($("#jform_time").val());
        var date_now = new Date();
        var diff_date = date_future - date_now;
        var num_years = Math.floor(diff_date / 31536000000);
        var num_months = Math.floor((diff_date % 31536000000) / 2628000000);
        var days = Math.floor(((diff_date % 31536000000) % 2628000000) / 86400000);
        var h = Math.floor(diff_date / 3600000) % 24;
        diff_date -= h * 3600000;
        var m = Math.floor(diff_date / 60000) % 60;
        diff_date -= m * 60000;
        var s = diff_date % 60;
        var seconds = s;
        var minutes = Math.floor(m);
        var hours = h;
        var tempCount = 1;
        var CounteractiveEl = $t.activeEl;
        var tempElement = $($t.activeEl).find('.time-row-1');
        $(tempElement).find('span').each(function(i, e) {
            if (tempCount == 1) {
                $(this).html(num_years);
            }
            if (tempCount == 2) {
                $(this).html(num_months);
            }
            if (tempCount == 3) {
                $(this).html(days);
            }
            if (tempCount == 4) {
                $(this).html(hours);
            }
            if (tempCount == 5) {
                $(this).html(minutes);
            }
            if (tempCount == 6) {
                $(this).html(seconds);
            }
            tempCount++;
        });
    });
    $('#jform_time').keyup(function() {
        $('#jform_time_btn').blur();
    });
    $('#jform_time').blur(function() {
        $('#jform_time_btn').blur();
    });
    $('#timer_width_input').unbind('keyup').keyup(function() {
        $t.activeEl.attr('data-width', $(this).val());
        $t.resizeTimer();
    });
    $('#jform_bigest').change(function() {
        $t.activeEl.attr('data-bigest', $(this).val());
        $t.createTimer();
        $t.resizeTimer();
    });
    $('#jform_timer_background').keyup(function() {
        $t.activeEl.attr('data-background', $(this).val());
        $t.activeEl.find('.time-row-1').css('background-color', $(this).val());
    });
    $('#jform_timer_color').keyup(function() {
        $t.activeEl.attr('data-color', $(this).val());
        $t.activeEl.find('.time-row-1').css('color', $(this).val());
    });
    $('#jform_line_color').keyup(function() {
        $t.activeEl.attr('data-line-color', $(this).val());
        $t.activeEl.find('.line').css('background-color', $(this).val());
    })
    $('#jform_text_color').keyup(function() {
        $t.activeEl.attr('data-text-color', $(this).val());
        $t.activeEl.find('.time-row-2').css('color', $(this).val());
    })
    $('#jform_timer_show, #jform_timer_hide').blur(function() {
        var val = $(this).val();
        if (val != '') {
            if (val.substr(0, 1) != '#' && val.substr(0, 1) != '.')
                val = '#' + val;
            if ($(val).length == 0) {
                alert($t.lang('COM_MARKETINGROCKET_ELEMENT_NOT_FOUND'));
            };
        };
        var name = $(this).attr('name');
        name = name.replace('jform[', '');
        name = name.replace(']', '');
        $t.activeEl.attr('data-' + name, val);
    });
    $('#jform_timer_timezone').change(function() {
        $t.activeEl.attr('data-timezonestring', $(this).val());
        $t.activeEl.attr('data-timezone', timeZones[$(this).val()]);
    })
    $t.defaultTimeZoneString = $('#jform_timer_timezone').val();
    $t.defaultTimeZoneValue = timeZones[$('#jform_timer_timezone').val()];
    $('[name="jform[timer_type]"]').click(function() {
        if ($(this).val() == 'counter') {
            $('#timer_time_holder').hide();
            $('#jform_time').parents('.control-group:first').show();
            $('#jform_timer_timezone').parents('.control-group:first').show();
        } else {
            $('#timer_time_holder').show();
            $('#jform_time').parents('.control-group:first').hide();
            $('#jform_timer_timezone').parents('.control-group:first').hide();
        };
        try {
            $t.activeEl.attr('data-timertype', $(this).val());
        } catch (e) {};
    });
    $('[name="jform[timer_type]"]:checked').click();
    $('#jform_time_hour,#jform_time_minute,#jform_time_second').keyup(function() {
        try {
            var time = 3600 * parseInt($("#jform_time_hour").val());
            time += 60 * parseInt($("#jform_time_minute").val());
            time += parseInt($("#jform_time_second").val());
            $t.activeEl.attr("data-seconds", time);
            var date_future = new Date();
            var date_now = new Date();
            date_future.setHours(date_future.getHours() + parseInt($("#jform_time_hour").val()));
            date_future.setMinutes(date_future.getMinutes() + parseInt($("#jform_time_minute").val()));
            date_future.setSeconds(date_future.getSeconds() + parseInt($("#jform_time_second").val()));
            var diff_date = date_future - date_now;
            var num_years = Math.floor(diff_date / 31536000000);
            var num_months = Math.floor((diff_date % 31536000000) / 2628000000);
            var days = Math.floor(((diff_date % 31536000000) % 2628000000) / 86400000);
            var h = Math.floor(diff_date / 3600000) % 24;
            diff_date -= h * 3600000;
            var m = Math.floor(diff_date / 60000) % 60;
            diff_date -= m * 60000;
            var s = diff_date % 60;
            var seconds = s;
            var minutes = Math.floor(m);
            var hours = h;
            var tempCount = 1;
            var CounteractiveEl = $t.activeEl;
            var tempElement = $($t.activeEl).find('.time-row-1');
            $(tempElement).find('span').each(function(i, e) {
                if (tempCount == 1) {
                    $(this).html(num_years);
                }
                if (tempCount == 2) {
                    $(this).html(num_months);
                }
                if (tempCount == 3) {
                    $(this).html(days);
                }
                if (tempCount == 4) {
                    $(this).html(hours);
                }
                if (tempCount == 5) {
                    $(this).html(minutes);
                }
                if (tempCount == 6) {
                    $(this).html(seconds);
                }
                tempCount++;
            });
        } catch (e) {
            if ($t.deBugable)
                console.log(e);
        };
    })
};
MR_landing.prototype.createTimer = function(el) {
    var $t = this;
    var $ = jQuery;
    var names = [$t.lang('COM_MARKETINGROCKET_YEAR'), $t.lang('COM_MARKETINGROCKET_MONTHS'), $t.lang('COM_MARKETINGROCKET_DAYS'), $t.lang('COM_MARKETINGROCKET_HOURS'), $t.lang('COM_MARKETINGROCKET_MINUTES'), $t.lang('COM_MARKETINGROCKET_SECONDS')];
    var el = el || $t.activeEl;
    el.html('');
    var div = $t.ce('div');
    $(div).css({
        'overflow': 'visible',
        'vertical-align': 'top',
        'font-size': '100%',
        'position': 'relative'
    });
    var count = $('#jform_bigest')[0].selectedIndex + 3;
    for (var i = 3 - $('#jform_bigest')[0].selectedIndex; i < names.length; i++) {
        var d = $t.ce('div');
        $(d).css({
            position: 'absolute',
            overflow: 'visible',
            'background-color': el.attr('data-background'),
            color: el.attr('data-color')
        }).addClass('time-row-1');
        var lineHolder = $t.ce('div');
        $(lineHolder).addClass('line').css('background-color', $('#jform_line_color').val()).appendTo(d);
        var d2 = $t.ce('div');
        $(d2).css({
            position: 'absolute',
            width: '100%',
            height: '100%',
            left: '0px',
            top: '0px',
            'text-align': 'center',
            'font-family': 'Arial',
            'white-space': 'nowrap',
            'line-height': '1em'
        });
        var sp = $t.ce('span');
        $(sp).html('00').appendTo(d2);
        $(d).append(d2).appendTo(div);
        var d = $t.ce('div');
        $(d).css({
            position: 'absolute',
            overflow: 'visible',
            'text-align': 'center',
            'line-height': '1.25em',
        }).addClass('time-row-2');
        var sp = $t.ce('span');
        $(sp).html(names[i]).appendTo(d);
        $(d).appendTo(div);
    };
    el.append(div);
};
MR_landing.prototype.resizeTimer = function(el) {
    var $t = this;
    var $ = jQuery;
    var el = el || $t.activeEl;
    var count = $('#jform_bigest')[0].selectedIndex + 3;
    var w = el.attr('data-width');
    var h = (parseInt(w) / 100) * 13.33;
    var borderRadius = h / 13;
    var margin = (w / count) / 20;
    var elW = (w / count) - (margin * 2);
    var textWidth = w / count;
    var secondRowH = h / 4.30;
    var secondRowT = (h + 5) - secondRowH;
    var firstRowH = secondRowT - (secondRowT / 7.3);
    var fontSize = h / 1.45;
    var secondRowFontSize = h / 5.71;
    el.find(' > div').css({
        width: w,
        height: h
    });
    var currentLeft = margin;
    el.find('.time-row-1').each(function() {
        $(this).css({
            'left': currentLeft,
            'width': elW,
            'height': firstRowH,
            'border-radius': borderRadius,
            'font-size': fontSize
        });
        currentLeft += elW + (margin * 2);
    });
    var currentLeft = 0;
    el.find('.time-row-2').each(function() {
        $(this).css({
            'left': currentLeft,
            'width': textWidth,
            'height': secondRowH,
            'top': secondRowT,
            'font-size': secondRowFontSize,
            'color': $('#jform_text_color').val()
        });
        currentLeft += textWidth;
    });
};
MR_landing.prototype.spacerDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'spacer').addClass('spacer');
    var div = $t.ce('div');
    var type = $.trim($('.elemnts[aria-type="spacer"]:first').text());
    $(div).addClass('element-type-holder').html(type).prependTo(box);
    $t.addAdminsBtns(box);
    $(box).find('.MR_Admin').remove();
    $(box).find('.MR_duplicate').remove();
    $t.addToParent(box, parent, className);
};
intialize.push('button');
MR_landing.prototype.button = function() {
    var $t = this;
    var $ = jQuery;
    $('[name="jform[size_type]"]').click(function() {
        var changed = false;
        var val = $('[name="jform[size_type]"]:checked').val();
        $('#button_width').parents('.control-group:first').show();
        if (val == 'inline') {
            $('#jform_button_change_item_type').parents('.accordion-group').hide();
            if (!$t.activeEl.parent().hasClass('button-holder')) {
                var parent = $($t.ce('div'));
                var id = $t.randString(6);
                parent.attr('id', id);
                try {
                    var className = $t.activeEl.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
                    className = parseInt(className[3]);
                    $t.activeEl.removeClass('span' + className).removeClass('col-md-' + className);
                    parent.addClass('button-holder').addClass('span' + className).addClass('col-md-' + className).addClass('added-element').insertBefore($t.activeEl);
                } catch (e) {
                    parent.addClass('button-holder').addClass('added-element').insertBefore($t.activeEl);
                }
                $t.addAdminsBtns(parent);
                $t.activeEl.css('width', '').removeAttr('data-width').appendTo(parent);
                try {
                    $t.activeEl.draggable("destroy").resizable("destroy");
                } catch (e) {}
                var type = $.trim($('.elemnts[aria-type="button"]:first').text());
                var div = $t.ce('div');
                $(div).addClass('element-type-holder').html(type).prependTo(parent);
                $t.createDragPoint(parent);
                $t.makeResizable(parent);
                $t.makeDraggable(parent);
            }
        } else {
            $('#jform_button_change_item_type').parents('.accordion-group').show();
            if ($t.activeEl.parents('.complex-item').length > 0) {
                $t.activeEl.css('width', '');
            }
            if ($t.activeEl.find('img.button-img').length == 0)
                $('#button_width').parents('.control-group:first').hide();
            if ($t.activeEl.parent().hasClass('button-holder')) {
                $t.activeEl.css('width', '');
                var parent = $t.activeEl.parent();
                try {
                    var className = parent.attr('class').match(/(\s+)(span{1})(\d{1,2})/i);
                    className = parseInt(className[3]);
                    $t.activeEl.addClass('span' + className).addClass('col-md-' + className);
                } catch (e) {}
                $t.activeEl.attr('aria-resize-handles', 'e');
                if (pageDirection == 'rtl') {
                    $t.activeEl.attr('aria-resize-handles', 'w');
                }
                $t.activeEl.appendTo(parent).css('width', '').removeAttr('data-width').insertBefore(parent);
                $t.makeResizable($t.activeEl);
                $t.makeDraggable($t.activeEl);
                parent.remove();
            }
        }
    });
    $('[name="jform[button_type]"]').click(function() {
        var changed = false;
        var val = $('[name="jform[button_type]"]:checked').val();
        var inserAfter = $t.activeEl.find('.element-type-holder');
        if (val == 'text') {
            $('#jform_size_type').parents('.control-group:first').show();
            $('#text-buttons-samples').show();
            $('#image-buttons-samples').hide();
            $('#jform_button_image_src-lbl').parents('.control-group:first').hide();
            $('#button_text_and_color').find('div.control-group, h5, hr').show();
            if (pageType == 'responder') {
                var firstEl = $('#jform_button_icon-lbl').parents('.control-group:first');
                while (firstEl.length > 0) {
                    firstEl.hide();
                    firstEl = firstEl.next();
                }
            }
            $('#button_boders').parent().show();
            $('#button_box_shadow').parent().show();
            $('#jform_button_image_alt').parent().parent().hide();
            $t.activeEl.find('img').remove();
            if ($t.activeEl.find('> i').length == 0) {
                var span = $t.ce('span');
                $(span).text(' Button Text');
                var i = $t.ce('i');
                $(i).addClass('fa');
                if (inserAfter.length > 0) {
                    $(span).insertAfter($t.activeEl.find('.element-type-holder'));
                    $(i).insertAfter($t.activeEl.find('.element-type-holder'));
                } else {
                    $(i).appendTo($t.activeEl);
                    $(span).appendTo($t.activeEl);
                }
                var mainClass = $t.activeEl.attr('aria-mainclass');
                $t.activeEl.addClass(mainClass + ' text-center');
                changed = true;
            }
        } else if (val == 'image') {
            $('#button_width').parents('.control-group:first').show();
            $('#jform_size_type').parents('.control-group:first').hide();
            $('#text-buttons-samples').hide();
            $('#image-buttons-samples').show();
            $('#jform_button_image_src-lbl').parents('.control-group:first').show();
            $('#button_text_and_color').find('div.control-group, h5, hr').hide();
            $('#jform_button_text_align').parents('.control-group:first').show();
            $('#button_boders').parent().hide();
            $('#button_box_shadow').parent().hide();
            $('#jform_button_image_alt').parent().parent().show();
            $t.activeEl.find('> i, > span').remove();
            if ($t.activeEl.find('> img').length == 0) {
                $('#jform_size_type0').next().click();
                $('#jform_size_type0').click();
                var img = $t.ce('img');
                var id = $t.randString(6);
                $(img).addClass('button-img').attr('src', locationOfJoomla + '/media/com_marketingrocket/buttons/download.png').attr('id', id);
                if (inserAfter.length > 0) {
                    $(img).insertAfter(inserAfter);
                } else {
                    $(img).appendTo($t.activeEl);
                }
                var mainClass = $t.activeEl.attr('aria-mainclass');
                $t.activeEl.removeClass(mainClass).addClass('text-center');
                changed = true;
                $('#button_width').parents('.control-group:first').show();
            }
        }
        if (changed === true) {
            var id = $t.activeEl.attr('id');
            $t.inlineCss[id] = undefined;
            $t.writeCss();
        }
        $t.buttonFillPopCss(true);
    });
    $('[name="jform[link_type]"]').click(function() {
        var val = $('[name="jform[link_type]"]:checked').val();
        if (val == 'href') {
            $('#jform_button_href').parents('.control-group:first').show();
            if (pageType != 'responder')
                $('#jform_button_target').parents('.control-group:first').show();
            else
                $('#jform_button_target').parents('.control-group:first').hide();
            $t.activeEl.attr('onclick', '');
        } else {
            if ($('#MarketingRocketMain [aria-type="form"]').length > 0 && $t.activeEl.attr('id') != 'MR_form_submit') {
                alert(COM_MARKETINGROCKET_OPENFORM_CLICK_ALERT);
                return false;
            }
            $('#jform_button_href').parents('.control-group:first').hide();
            $('#jform_button_target').parents('.control-group:first').hide();
            if ($t.activeEl.attr('id') != 'MR_form_submit') {
                if ($('#jform_form_or_cta').val() == 'form') {
                    $t.activeEl.attr('onclick', 'showFormPopUp()');
                } else {
                    $t.activeEl.attr('onclick', 'callCta()');
                }
            }
            $t.activeEl.removeAttr('href');
        }
    });
    if (pageType == 'responder') {
        var firstEl = $('#jform_button_background_color_hover').parents('.control-group:first').prev().prev();
        while (firstEl.length > 0) {
            firstEl.hide();
            firstEl = firstEl.next();
        }
        var firstEl = $('#jform_button_icon-lbl').parents('.control-group:first');
        while (firstEl.length > 0) {
            firstEl.hide();
            firstEl = firstEl.next();
        }
        var firstEl = $('#jform_button_border_color_hover').parents('.control-group:first').prev().prev();
        while (firstEl.length > 0) {
            firstEl.hide();
            firstEl = firstEl.next();
        }
    }
};
MR_landing.prototype.buttonDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.ce('div');
    if (isInt(className))
        $(box).addClass('col-md-' + className + ' span' + className + ' added-element active-button MR-button');
    else
        $(box).addClass('added-element active-button MR-button ' + className);
    var resizeSide = 'e';
    if (pageDirection == 'rtl') {
        resizeSide = 'w';
    }
    $(box).attr('aria-type', 'button').attr('aria-resize-handles', resizeSide).prepend('<i class="fa"></i>').attr('aria-mainclass', 'active-button');
    $(box).attr('id', $t.randString(6));
    if (pageType == 'responder') {
        $(box).attr('href', '');
    } else if ($('#MarketingRocket').is(':visible')) {
        var val = $('#jform_form_or_cta').val();
        if (val == 'form') {
            if ($('#MarketingRocket').find('.form-holder-parent').length == 0)
                $(box).attr('onclick', 'showFormPopUp()');
        } else if (val == 'cta')
            $(box).attr('onclick', 'callCta()');
    }
    var span = $t.ce('span');
    $(span).text(' Button Text').appendTo(box);
    $t.addAdminsBtns(box);
    $t.addToParent(box, parent, className);
    var a = $t.ce('a');
    var i = $t.ce('i');
    $(i).addClass('fa fa-gear').appendTo(a);
    $(a).attr('data-original-title', COM_MARKETINGROCKET_BUTTON_STYLE).addClass('MR_Admin hasTooltip btn-mini btn');
    $(a).insertAfter($(box).find('.MR_SORT_RIGHT:first'));
    $(a).tooltip({
        container: 'body'
    });
    $t.buttonFunctions(box);
    if (pageType == 'responder') {
        setTimeout(function() {
            $(box).find('.MR_Admin').click();
        }, 200);
    }
    return box;
};
MR_landing.prototype.buttonAfterAddAdminBtns = function(el) {
    var $t = this;
    var $ = jQuery;
    $(el).find('.MR_Admin').remove();
};
MR_landing.prototype.buttonFunctions = function(el) {
    var $t = this;
    var $ = jQuery;
    $(el).click(function() {
        return false;
    });
    $(el).find('.MR_Admin').unbind('click').click(function() {
        $t.activeEl = $(this).parent().parent();
        $t.modal('#MR_buttong_setting_modal', 'show');
        $('#MR_buttong_setting_modal').find('h3 > small').text('#' + $t.activeEl.attr('id'));
        setTimeout(function() {
            $t.buttonFillPopCss()
        }, 200);
    });
    var panrent = $(el).parent();
    if (panrent.hasClass('button-holder')) {
        $t.adminsBtnsFuntions(panrent);
    }
};
MR_landing.prototype.buttonFillPopCss = function(handle) {
    var $t = this;
    var $ = jQuery;
    if (handle === undefined) {
        if ($t.activeEl.find('img').length > 0) {
            $('#jform_button_type1').next().click();
            $('#jform_button_type1').click();
        } else {
            $('#jform_button_type0').next().click();
            $('#jform_button_type0').click();
        }
        return true;
    }
    if (!$t.activeEl.parent().hasClass('button-holder')) {
        $('#jform_size_type0').next().click();
        $('#jform_size_type0').click();
    } else {
        $('#jform_size_type1').next().click();
        $('#jform_size_type2').click();
    }
    if ($($t.activeEl).parents('.complex-item').length > 0) {
        $('#jform_button_change_item_type').parents('.control-group:first').hide();
    } else {
        $('#jform_button_change_item_type').parents('.control-group:first').show();
    }
    if (pageType == 'responder') {
        $('#jform_link_type').parent().parent().hide();
    }
    if ($($t.activeEl).parents('.form-holder-parent').length > 0) {
        $('#button_click').parent().hide();
    } else {
        $('#button_click').parent().show();
    }
    $t.isFillPopUpCss = true;
    $('#jform_button_change_item_type').val('button').chosen('destroy').chosen();
    var css = $t.css($t.activeEl);
    $t.buttonCss = css;
    $('#button_setting_tabsContent').find('input:not([type="radio"]),textarea').unbind('keyup').unbind('blur').val('');
    $('#button_setting_tabsContent').find('select').not('#jform_button_change_item_type').unbind('change').val('');
    var elId = $($t.activeEl).attr('id');
    $('#MR_buttong_setting_modal').find('.onoffswitch-checkbox').each(function() {
        var id = $(this).data('id');
        var force = false;
        if ($t.inlineCss[elId] != undefined && $t.inlineCss[elId].temp != undefined && $t.inlineCss[elId].temp[id] != undefined) {
            force = true;
        }
        $(this).prop('checked', true).change();
        if (force) {
            $(this).prop('checked', false).change();
        }
    });
    var src = $t.activeEl.find('img').attr('src');
    $('#jform_button_image_src').val(src);
    $('#jform_button_image_src_preview').attr('src', src);
    $t.setBackgroundColor(css.backgroundColor, '#jform_button_background_color');
    if (css.backgroundImage != undefined) {
        if (css.backgroundImage.substr(0, 3) == 'url') {
            var src = css.backgroundImage.match(/\((.*?)\)/)[1].replace(/('|")/g, '');
            $('#jform_button_background_image').val(src);
            $('#jform_button_background_image_preview').attr('src', src);
        }
    }
    $('#jform_button_background_repeat').val(css.backgroundRepeat);
    $('#jform_button_background_size').val(css.backgroundSize);
    var background = css.background;
    if (css.background == undefined && css.backgroundImage)
        background = css.backgroundImage;
    else if (css.background == undefined)
        background = '';
    if (background.substr(0, 6) == 'linear') {
        $('#jform_button_background').val(background);
    } else {
        $('#jform_button_background').val('');
    }
    var hoverCss = $t.css($t.activeEl, $t.activeEl.attr('aria-mainclass'));
    $t.hoverCss = hoverCss;
    $t.setBackgroundColor(hoverCss.backgroundColor, '#jform_button_background_color_hover');
    if (hoverCss.backgroundImage != undefined) {
        if (hoverCss.backgroundImage.substr(0, 3) == 'url') {
            var src = hoverCss.backgroundImage.match(/\((.*?)\)/)[1].replace(/('|")/g, '');
            $('#jform_button_background_image_hover').val(src);
            $('#jform_button_background_image_hover_preview').attr('src', src);
        }
    }
    $('#jform_button_background_repeat_hover').val(hoverCss.backgroundRepeat);
    $('#jform_button_background_size_hover').val(hoverCss.backgroundSize);
    var hoverBackground = hoverCss.background;
    if (hoverBackground === undefined && hoverCss.backgroundImage)
        hoverBackground = hoverCss.backgroundImage;
    else if (hoverBackground == undefined)
        hoverBackground = '';
    if (hoverBackground.substr(0, 6) == 'linear') {
        $('#jform_button_background_hover').val(hoverBackground);
    } else {
        $('#jform_button_background_hover').val('');
    }
    $('#jform_button_text').val($t.activeEl.find('span:first').text());
    $t.setColor(css.color, '#jform_button_color');
    $('#jform_button_font_size').val($t.getDimension(css.fontSize, $('#jform_button_font_size')));
    var icon = $t.activeEl.find(' > i:first');
    $(MR_BUTTON_MAGIC).unbind('selectionchange');
    if (icon.length > 0) {
        var allClass = icon.attr('class');
        if (allClass == undefined)
            allClass = ''
        allClass = allClass.split(' ');
        var selected = [];
        for (var i = 0; i < allClass.length; i++) {
            var obj = {
                name: allClass[i],
                value: allClass[i]
            };
            selected.push(obj);
        }
        MR_BUTTON_MAGIC.setSelection(selected);
        var color = icon.css('color');
        color = $t.makeHex(color);
        $('#jform_button_icon_color').val(color).ColorPickerSetColor(color);
    } else {
        MR_BUTTON_MAGIC.clear();
        $('#jform_button_icon_color').val('').ColorPickerSetColor('');
    }
    $(MR_BUTTON_MAGIC).on('selectionchange', function() {
        $t.saveButtonCss($('[name="jform[button_icon][]"]:first'));
    })
    $('#jform_button_icon_position').val($t.activeEl.attr('aria-button-icon-position'));
    $('#jform_button_icon_position_chzn > a > span').text($t.activeEl.attr('aria-button-icon-position'));
    $('#jform_button_target').val($t.activeEl.attr('target'));
    $('#jform_button_target_chzn > a > span').text($("#jform_button_target option:selected").text());
    $('#jform_button_font_family').val(css.fontFamily);
    $('#jform_button_font_family').chosen('destroy');
    $('#jform_button_font_family').chosen();
    $('#jform_button_font_weight').val(css.fontWeight);
    $('#jform_button_font_weight').chosen('destroy');
    $('#jform_button_font_weight').chosen();
    $('#jform_button_text_transform').val(css.textTransform);
    $('#jform_button_text_transform').chosen('destroy');
    $('#jform_button_text_transform').chosen();
    $('#jform_button_font_style').val(css.fontStyle);
    $('#jform_button_font_style').chosen('destroy');
    $('#jform_button_font_style').chosen();
    $('#jform_button_text_align').val(css.textAlign);
    $('#jform_button_text_align').chosen('destroy');
    $('#jform_button_text_align').chosen();
    $('#jform_button_text_decoration').val(css.textDecoration);
    $('#jform_button_text_decoration').chosen('destroy');
    $('#jform_button_text_decoration').chosen();
    $t.setColor(hoverCss.color, '#jform_button_color_hover');
    if (icon.length > 0) {
        var iconHoverCss = $t.css(icon, true);
        if (iconHoverCss.color != undefined)
            var color = iconHoverCss.color;
        else
            var color = '';
        $t.setColor(color, '#jform_button_icon_color_hover');
    } else {
        $('#jform_button_icon_color_hover').val('').ColorPickerSetColor('');
    }
    $('#jform_button_text_decoration_hover').val(hoverCss.textDecoration);
    $('#jform_button_text_decoration_hover').chosen('destroy');
    $('#jform_button_text_decoration_hover').chosen();
    $('#jform_button_padding_left').val($t.getDimension(css.paddingLeft, $('#jform_button_padding_left')));
    $('#jform_button_padding_top').val($t.getDimension(css.paddingTop, $('#jform_button_padding_top')));
    $('#jform_button_padding_right').val($t.getDimension(css.paddingRight, $('#jform_button_padding_right')));
    $('#jform_button_padding_bottom').val($t.getDimension(css.paddingBottom, $('#jform_button_padding_bottom')));
    $('#jform_button_margin_top').val($t.getDimension(css.marginTop), $('#jform_button_margin_top'));
    $('#jform_button_margin_bottom').val($t.getDimension(css.marginBottom, $('#jform_button_margin_bottom')));
    $t.extractBorders(css, '#jform_button_border_color', '#jform_button_border_width', '#jform_button_border_style');
    $('#jform_button_border_radius').val($t.getDimension(css.borderRadius, $('#jform_button_border_radius')));
    var color = $t.makeHex(hoverCss.borderColor);
    $('#jform_button_border_color_hover').val(color).ColorPickerSetColor(color);
    if ($t.activeEl.attr('id') === 'MR_form_submit') {
        $('#button_click').parent().hide();
    } else {
        $('#button_click').parent().show();
    }
    $('#jform_button_onclick').val($t.activeEl.attr('onclick'));
    $('#jform_button_href').val($t.activeEl.attr('href'));
    $('#jform_button_target').val($t.activeEl.attr('target'));
    $('#jform_link_type').find('.btn').removeClass('active btn-success');
    if ($.trim($t.activeEl.attr('onclick')) != '') {
        $('#jform_link_type1').next().click().addClass('active btn-success');
        $('#jform_link_type1').click();
    } else {
        $('#jform_link_type0').next().click().addClass('active btn-success');
        $('#jform_link_type0').click();
    }
    $('#jform_button_box_shadow').val(css.boxShadow);
    $t.getBoxShadow($('#jform_button_box_shadow').parents('.accordion-inner:first'), $('#jform_button_box_shadow').val());
    var target = $('#button-background.gradient');
    $t.fillGradient(background, target);
    var target = $('#button-background-hover');
    $t.fillGradient(hoverBackground, target);
    var cutome_css = $t.activeEl.attr('aria-css');
    $('#jform_button_custom_css').val('').val(cutome_css);
    var target = $t.activeEl;
    if (target.find('img.button-img').length > 0)
        target = $t.activeEl.find('img.button-img');
    if (target.attr('data-width') && target.attr('data-width') != NaN) {
        $('#button_width_input').val(target.attr('data-width'));
        $('#button_width').slider('value', target.attr('data-width'));
    } else {
        $('#button_width_input').val('');
        var p = target.parent().width();
        var val = (target.width() / p) * 100;
        $('#button_width').slider('value', val);
    }
    $('#jform_button_title').val($t.activeEl.attr('title'));
    var img = $t.activeEl.find('img');
    if (img.length > 0) {
        $('#jform_button_image_alt').val(img.attr('alt'));
    }
    $('#button_setting_tabsContent').find('input,textarea').each(function() {
        var name = $(this).attr('name');
        if (name == undefined || name == null)
            return true;
        $(this).unbind('keyup').keyup(function() {
            $t.saveButtonCss($(this));
        })
    });
    $('#button_setting_tabsContent').find('input,textarea').each(function() {
        var name = $(this).attr('name');
        if (name == undefined || name == null)
            return true;
        $(this).unbind('blur').blur(function() {
            $(this).keyup()
        })
    });
    $('#jform_button_href').unbind('blur').blur(function() {
        $t.activeEl.attr('href', $(this).val());
    });
    $('#jform_button_onclick').unbind('blur').blur(function() {
        $t.activeEl.attr('onclick', $(this).val());
    });
    $('#jform_button_title').unbind('blur').blur(function() {
        $t.activeEl.attr('title', $(this).val());
    });
    $('#jform_button_image_alt').unbind('blur').blur(function() {
        var img = $t.activeEl.find('img');
        if (img.length > 0)
            img.attr('alt', $(this).val());
    });
    $('#button_setting_tabsContent').find('select,#jform_button_background_image,#jform_button_background_image_hover,#jform_button_image_src').not('#jform_button_change_item_type').each(function() {
        var name = $(this).attr('name');
        if (name == undefined || name == null)
            return true;
        $(this).unbind('change').change(function() {
            $t.saveButtonCss($(this));
        });
    });
    $('#button_width_input').keyup(function() {
        var val = $(this).val();
        if (val != '')
            val = val + '%';
        var target = $t.activeEl;
        if (target.find('img.button-img').length > 0)
            target = $t.activeEl.find('img.button-img');
        target.css('width', val).attr('data-width', parseFloat(val));
    });
    $('#overflow-holder').hide();
    $t.isFillPopUpCss = false;
    if (pageType == 'responder') {
        setTimeout(function() {
            $t.saveButtonCss();
        }, 200);
    }
};
MR_landing.prototype.saveButtonCss = function(element) {
    var $t = this;
    var $ = jQuery;
    var button_icon_position = 'left';
    var button_target = '_self';
    $t.buttonExclude = ['text', 'icon', 'onclick', 'href', 'icon_color', 'icon_position', 'button-target', 'icon_color-hover'];
    $t.buttonId = $t.activeEl.attr('id');
    $t.cssFounded = false;
    if ($t.deBugable && element != undefined) {
        console.log('Element :' + element.attr('name'));
    }
    if (element == undefined)
        element = false;
    if ($t.inlineCss[$t.buttonId] == undefined)
        element = false;
    if (element == false) {
        $t.inlineCss[$t.buttonId] = {
            styles: {},
            hover: {},
            iconStyle: {},
            iconStyleHover: {}
        };
        $t.inlineCss[$t.buttonId].styles['cursor'] = 'pointer';
    }
    $('#button_setting_tabsContent').find('input,select,textarea').each(function() {
        var name = $(this).attr('name');
        if (name == undefined || name == '')
            return true;
        if (element != false && name != element.attr('name'))
            return true;
        name = name.replace('jform', '', 'g');
        name = name.replace('[', '', 'g');
        name = name.replace(']', '', 'g');
        name = name.replace('button-', '');
        if (!$(this).parents('.control-group:first').is(':visible') && name != 'box-shadow')
            return true;
        if ($.inArray(name, $t.buttonExclude) > -1)
            return true;
        var isHover = false;
        if (name.search('-hover') > -1) {
            name = name.replace('-hover', '');
            isHover = true;
        }
        var val = $.trim($(this).val());
        if (name == 'background-color-transparent') {
            if (!$(this).is(':checked')) {
                var val = $(this).parents('.control-group:first').prev().find('input').val();
                if (isHover == false)
                    $t.inlineCss[$t.buttonId].styles['background-color'] = val;
                else
                    $t.inlineCss[$t.buttonId].hover['background-color'] = val;
                $t.cssFounded = true;
                return true;
            } else {
                if (isHover == false)
                    $t.inlineCss[$t.buttonId].styles['background-color'] = 'transparent';
                else
                    $t.inlineCss[$t.buttonId].hover['background-color'] = 'transparent';
                return true;
            }
        } else if (name == 'background-image' && val != '') {
            val = 'url("' + $t.fixImageSrc(val) + '")';
        } else if (name == 'image-src') {
            $t.activeEl.find('img').attr('src', $t.fixImageSrc(val));
            return true;
        } else if (name == 'button_icon_position') {
            button_icon_position = $('#jform_button_icon_position').val();
            var button_text = $t.activeEl.find('span:first'),
                button_icon_el = $t.activeEl.find(' > i:first').clone();
            $t.activeEl.attr('aria-button-icon-position', button_icon_position);
            $t.activeEl.find(' > i:first').remove();
            if (button_icon_position == 'left') {
                $(button_icon_el).insertBefore(button_text);
            } else {
                $(button_icon_el).insertAfter(button_text);
            }
        } else if (name == 'target') {
            button_target = $('#jform_button_target').val();
            $t.activeEl.attr('target', button_target);
        }
        if ($.inArray(name, ['padding-left', 'padding-right', 'padding-top', 'padding-bottom', 'padding-right', 'margin-top', 'margin-bottom', 'font-size', 'border-radius']) > -1) {
            val = $t.setDimensionValue(val, $(this));
        }
        if (val != '' || element != false) {
            var tempClass = '';
            $('#jform_button_icon').find('div.ms-sel-item ').each(function(i, e) {
                tempClass += tempClass + ' ' + $(e).text();
            });
            if (name == 'button_icon' || name == 'button_icon[]') {
                $t.activeEl.find('i:first').attr('class', '');
                $t.activeEl.find('i:first').addClass(tempClass);
            }
            if (isHover == false)
                $t.inlineCss[$t.buttonId].styles[name] = val;
            else
                $t.inlineCss[$t.buttonId].hover[name] = val;
        }
        if (element != false) {
            $t.cssFounded = true;
            return false;
        }
    })
    if ($t.checkElementName(element, $('[name="jform[button_icon][]"]:first'))) {
        $t.activeEl.find(' > i:first').removeAttr('class');
        $('[name="jform[button_icon][]"]').each(function() {
            $t.activeEl.find(' > i:first').addClass($(this).val());
        });
    }
    if ($t.checkElementName(element, $('#jform_button_text'))) {
        $t.activeEl.find('span:first').text($('#jform_button_text').val());
    }
    if ($t.checkElementName(element, $('#jform_button_icon_color')))
        $t.inlineCss[$t.buttonId].iconStyle.color = $('#jform_button_icon_color').val();
    if ($t.checkElementName(element), $('#jform_button_icon_color_hover'))
        $t.inlineCss[$t.buttonId].iconStyleHover.color = $('#jform_button_icon_color_hover').val();
    if ($t.checkElementName(element, $('#jform_button_onclick')))
        $t.activeEl.attr('onclick', $('#jform_button_onclick').val());
    if ($t.checkElementName(element, $('#jform_button_href'))) {
        var href = $.trim($('#jform_button_href').val());
        if (href == '')
            $t.activeEl.removeAttr('href');
        else {
            $t.activeEl.attr('href', href).removeAttr('onclick');
        }
    }
    if ($t.checkElementName(element, $('#jform_button_target'))) {
        $t.activeEl.attr('target', $('#jform_button_target').val());
    }
    var cutom_css = $('#jform_button_custom_css').val();
    cutom_css = $.trim(cutom_css.replace('"', '\''));
    $t.activeEl.attr('aria-css', cutom_css);
    if (cutom_css && cutom_css != '') {
        cutom_css = cutom_css.split(';');
        for (var i = 0; i < cutom_css.length; i++) {
            var row = $.trim(cutom_css[i]).split(':');
            if ($t.validCSS($.trim(row[0]), $.trim(row[1])))
                $t.inlineCss[$t.buttonId].styles[$.trim(row[0])] = $.trim(row[1]);
            else if ($t.deBugable)
                console.log(row[0] + ' Width ' + row[1] + ' Is Not Valid');
        }
    }
    if ($t.checkElementName(element)) {
        $t.writeCss();
        $('#jform_hidden_css').val(JSON.stringify($t.inlineCss));
    }
};
intialize.push('codebox');
MR_landing.prototype.codeboxDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'codebox').addClass('codebox_element');
    var div = $t.ce('div');
    $(div).addClass('code-holder').appendTo(box);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-code', $t.lang('COM_MARKETINGROCKET_CODEBOX_EDIT_TITLE'));
    $t.codeboxFunctions(box);
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.codeboxFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('a.MR_Custom:first').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpCodebox();
        $t.modal('#code_editor_modal', 'show');
    });
};
MR_landing.prototype.beforeShowPopUpCodebox = function() {
    var $t = this;
    var $ = jQuery;
    if ($t.codeboxEditor == false) {
        setTimeout(function() {
            var div = $('#code_editor_modal').find('div.modal-body');
            $t.codeboxEditor = CodeMirror(div[0], {
                value: $t.activeEl.find('.code-holder').html(),
                lineNumbers: true,
                mode: "htmlmixed"
            });
        }, 500);
    } else {
        setTimeout(function() {
            $t.codeboxEditor.setValue($t.activeEl.find('.code-holder').html());
        }, 500);
    }
};
MR_landing.prototype.codebox = function() {
    var $t = this;
    var $ = jQuery;
    $t.codeboxEditor = false;
    $('#code_editor_modal').find('.btn-primary').click(function() {
        $t.activeEl.find('.code-holder').html($t.codeboxEditor.getValue())
        $t.modal('#code_editor_modal', 'hide');
    });
};
intialize.push('videobox');
MR_landing.prototype.videoboxDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'videobox').addClass('videobox');
    $(box).html('<iframe width="420" height="315" data-id="JX7167Nn0R4" src="https://www.youtube.com/embed/dcXUWBw_H1o?rel=0" frameborder="0" id="' + $t.randString(6) + '" allowfullscreen></iframe>');
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-youtube-play', COM_MARKETINGROCKET_VIDEOBOX_SETTINGS);
    $t.videoboxFunctions(box);
    $t.addToParent(box, parent, className);
}
MR_landing.prototype.videoboxFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('a.MR_Custom').click(function() {
        $t.activeEl = $(box).find('iframe');
        $('#videobox_setting').find('h3').find('small').text('#' + $t.activeEl.attr('id'));
        $t.beforeShowPopUpVideoBox();
        $t.modal('#videobox_setting', 'show');
    });
}
MR_landing.prototype.videoBoxCreateUrl = function() {
    var $t = this;
    var $ = jQuery;
    if ($t.videoboxAct == false)
        return;
    var url = 'https://www.youtube.com/embed/';
    var videoId = $('#jform_video_id').val();
    url += videoId + '?';
    var sep = '';
    $('#videobox_setting').find('input[type="radio"]:checked').each(function() {
        var name = $(this).attr('name');
        name = name.replace('jform[video_', '');
        name = name.replace(']', '');
        url += sep + name + '=' + $(this).val();
        sep = "&";
    })
    $t.activeEl.attr('src', url);
};
MR_landing.prototype.beforeShowPopUpVideoBox = function() {
    var $t = this;
    var $ = jQuery;
    $t.videoboxAct = false;
    var url = $t.activeEl.attr('src');
    url = url.replace('https://www.youtube.com/embed/', '');
    url = url.replace('http://www.youtube.com/embed/', '');
    url = url.replace('//www.youtube.com/embed/', '');
    var safeUrl = url;
    url = url.split('?');
    var videoId = url[0];
    try {
        url = url[1].split('&');
        var type = $t.activeEl.attr('data-type');
        if (type == 'webinar') {
            $('#jform_video_type1').next().click();
            $('#jform_video_type1').click();
            $('#jform_webinar_id').val(videoId);
        } else {
            $('#jform_video_type0').next().click();
            $('#jform_video_type0').click();
            $('#jform_video_id').val(videoId);
        }
        for (var i = 0; i < url.length; i++) {
            var rowData = url[i].split('=');
            var name = rowData[0];
            var val = rowData[1];
            name = 'jform[video_' + name + ']';
            $('#videobox_setting [name="' + name + '"][val="' + val + '"]').click().next().click();
        }
    } catch (e) {
        videoId = safeUrl;
        $('#jform_video_id').val(videoId);
    }
    $('#jform_video_width').val($t.activeEl.attr('width'));
    $('#jform_video_height').val($t.activeEl.attr('height'));
    $t.videoboxAct = true;
};
MR_landing.prototype.videobox = function() {
    var $t = this;
    var $ = jQuery;
    $t.videoboxAct = true;
    $('#videobox_setting [name="jform[video_type]"]').click(function() {
        if ($(this).val() == 'video') {
            $('#jform_video_id').parents('.control-group:first').show();
            $('#jform_webinar_id').parents('.control-group:first').hide();
        } else {
            $('#jform_video_id').parents('.control-group:first').hide();
            $('#jform_webinar_id').parents('.control-group:first').show();
        }
        if ($t.activeEl != undefined) {
            $t.activeEl.attr('data-type', $(this).val());
        }
    }).eq('0').next().click().prev().click();
    $('#jform_video_id').blur(function() {
        $t.videoBoxCreateUrl();
    });
    $('#jform_webinar_id').change(function() {
        $('#jform_video_id').val($(this).val()).blur();
    });
    $('#videobox_setting [name="jform[video_autoplay]"]' +
        ',#videobox_setting [name="jform[video_controls]"]' +
        ',#videobox_setting [name="jform[video_showinfo]"]' +
        ',#videobox_setting [name="jform[video_theme]"]' +
        ',#videobox_setting [name="jform[video_autohide]"]' +
        ',#videobox_setting [name="jform[video_rel]"]').click(function() {
        $t.videoBoxCreateUrl();
    });
    $('#jform_video_width').keyup(function() {
        $t.activeEl.attr('width', $(this).val());
    });
    $('#jform_video_height').keyup(function() {
        $t.activeEl.attr('height', $(this).val());
    });
};
intialize.push('icon');
MR_landing.prototype.iconDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'icon').addClass('icon_element');
    var span = $t.ce('span');
    var id = $t.randString(6);
    $(span).addClass('fa fa-smile-o').attr('id', id).attr('data-size', '20');
    $(box).append(span);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-smile-o', COM_MARKETINGROCKET_ICON_EDIT_TITLE);
    $t.iconFunctions(box);
    $t.addToParent(box, parent, className);
    $t.createCssObj(id, span);
    return box;
};
MR_landing.prototype.iconFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('a.MR_Custom').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpIcon();
        $t.modal('#icon_setting', 'show');
    });
    $('#icon_setting').find('h3:first small').text('#' + $(box).find('> span').attr('id'));
};
MR_landing.prototype.beforeShowPopUpIcon = function() {
    var $t = this;
    var $ = jQuery;
    var icon = $t.activeEl.find(' > span:first');
    $('#icon_size').slider('value', icon.attr('data-size'));
    $('#icon_size_input').val(icon.attr('data-size')).keyup();
    var color = $t.rgb2hex(icon.css('color'));
    $('#jform_icon_color').val(color).ColorPickerSetColor(color).keyup();
    $(MR_ICON_MAGIC).unbind('selectionchange');
    if (icon.length > 0) {
        var allClass = icon.attr('class');
        if (allClass == undefined)
            allClass = ''
        allClass = allClass.split(' ');
        var selected = [];
        for (var i = 0; i < allClass.length; i++) {
            if (allClass[i] == 'replace')
                continue;
            var obj = {
                name: allClass[i],
                value: allClass[i]
            };
            selected.push(obj);
        }
        MR_ICON_MAGIC.setSelection(selected);
    } else {
        MR_ICON_MAGIC.clear();
    }
    $(MR_ICON_MAGIC).on('selectionchange', function() {
        var span = $t.activeEl.find(' > span:first');
        span.removeAttr('class');
        $('[name="jform[icon][]"]').each(function() {
            span.addClass($(this).val());
        });
        if (span.attr('aria-replace'))
            span.addClass('replace');
    });
    $('#jform_icon_hover_color').val('');
    if ($t.activeEl.find(' > span:first').attr('aria-replace')) {
        $('#jform_icon_linked0').next().click();
        $('#jform_icon_linked0').click();
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if ($t.inlineCss[id]) {
            try {
                $('#jform_icon_hover_color').val($t.inlineCss[id].hover.color);
            } catch (e) {}
        }
    } else {
        $('#jform_icon_linked1').next().click();
        $('#jform_icon_linked1').click();
    }
    $('#jform_icon_href').val($t.activeEl.find(' > span:first').attr('href'));
    $('#jform_icon_target').val($t.activeEl.find(' > span:first').attr('target'));
};
MR_landing.prototype.icon = function() {
    var $t = this;
    var $ = jQuery;
    $('#icon_size_input').keyup(function() {
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if (!$t.inlineCss[id])
            $t.createCssObj(id, span);
        $t.inlineCss[id].styles['font-size'] = $(this).val() + 'em';
        span.attr('data-size', $(this).val()).removeAttr('style');
        $t.writeCss();
    });
    $('#jform_icon_color').keyup(function() {
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if (!$t.inlineCss[id])
            $t.createCssObj(id, span);
        $t.inlineCss[id].styles['color'] = $(this).val();
        span.removeAttr('style');
        $t.writeCss();
    });
    $('#icon_setting [name="jform[icon-linked]"]').click(function() {
        var span = $t.activeEl.find(' > span:first');
        if ($('#icon_setting [name="jform[icon-linked]"]:checked').val() == 1) {
            span.addClass('replace').attr('aria-replace', 'a');
            $('#jform_icon_href').parents('.control-group:first').show();
            $('#jform_icon_target').parents('.control-group:first').show();
            $('#jform_icon_hover_color').parents('.control-group:first').show();
        } else {
            span.removeClass('replace').removeAttr('aria-replace');
            $('#jform_icon_hover_color').val('').blur();
            $('#jform_icon_href').val('').blur();
            $('#jform_icon_href').parents('.control-group:first').hide();
            $('#jform_icon_target').parents('.control-group:first').hide();
            $('#jform_icon_hover_color').parents('.control-group:first').hide();
        }
    });
    $('#jform_icon_href').blur(function() {
        var val = $(this).val();
        if (val != '')
            $t.activeEl.find(' > span:first').attr('href', val);
        else
            $t.activeEl.find(' > span:first').removeAttr('href');
    });
    $('#jform_icon_target').change(function() {
        var val = $(this).val();
        if ($('#icon_setting [name="jform[icon-linked]"]:checked').val() == 1)
            $t.activeEl.find(' > span:first').attr('target', val);
    });
    $('#jform_icon_hover_color').blur(function() {
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if (!$t.inlineCss[id])
            $t.createCssObj(id, span);
        $t.inlineCss[id].hover['color'] = $(this).val();
        $t.inlineCss[id].hover['text-decoration'] = 'none';
        $t.writeCss();
    });
};
intialize.push('form');
MR_landing.prototype.form = function() {
    var $t = this;
    var $ = jQuery;
    if ($('#MarketingRocket').find('div[aria-type="form"]').length > 0)
        $t.formExitPopupAction();
};
MR_landing.prototype.formDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var mainParent = $('#MarketingRocket');
    if ($(parent).parents('#MR_Exit_View_Holder').length > 0) {
        mainParent = $('#MR_Exit_View_Holder');
        if (mainParent.find('.form-modal-holder').length > 0) {
            alert(COM_MARKETINGROCKET_ONLY_ONE_TIME_ELEMENT_ERRORR);
            return;
        }
    } else {
        if (mainParent.find('#MR_form_holder').length > 0) {
            alert(COM_MARKETINGROCKET_ONLY_ONE_TIME_ELEMENT_ERRORR);
            return;
        }
    }
    if (mainParent.find('div[aria-type="button"][onclick="showFormPopUp()"]').length > 0) {
        alert(COM_MARKETINGROCKET_FORM_DROP_ERROR_POPUP);
        return;
    }
    if ($('#jform_form_or_cta').val() != 'form') {
        alert('You must have FORM selected in Landing Page Settings in order to display a form on your page');
        return;
    }
    if (mainParent.attr('id') == 'MarketingRocket') {
        var box = $t.createBox('div', className);
        $(box).addClass('form-holder-parent complex-item').attr('aria-type', 'form');
        $t.formExitPopupAction();
        var div = $t.ce('div');
        $(div).addClass('form-holder fa').attr('id', 'MR_form_holder').appendTo(box);
        $t.addAdminsBtns(box);
        $t.formButton(box);
        $t.isChildAdded = true;
        var btn = $t.buttonDropped(box, '');
        $(btn).attr('id', 'MR_form_submit').attr('onclick', 'document.getElementById(\'front-landing-form\').submit()');
        $t.isChildAdded = false;
        $t.addToParent(box, parent, className);
    } else {
        var box = $('.form-modal-holder').clone(true);
        box.find('#MR_form_submit').attr('id', 'MR_form_submit_exit').attr('onclick', 'document.getElementById(\'exit-landing-form\').submit()');
        $t.addToParent(box, parent, className);
    }
    $(box).find('#MR_form_holder').attr('data-form-class', $('[name="jform[form-style-class]"]:checked').val());
    fb.trigger('change');
};
MR_landing.prototype.formExitPopupAction = function() {
    var $t = this;
    var $ = jQuery;
    var parents = $('#show-modal-setting').parents('.pull-left:first');
    parents.prev().hide();
    parents.hide();
    var popup = $('#jform_exit_popup');
    if (popup.val() == 'default')
        popup.val('0').change();
    popup.find('option[value="default"]').attr('disabled', 'true');
    popup.chosen('destroy').chosen();
};
MR_landing.prototype.formFunctions = function(parent) {
    var $t = this;
    var $ = jQuery;
    $t.formButton(parent);
}
MR_landing.prototype.formButton = function(parent) {
    var $t = this;
    var $ = jQuery;
    if ($(parent).find('.fa-pencil-square-o').length > 1) {
        $(parent).find('.fa-pencil-square-o').each(function() {
            $(this).parent().remove();
        })
    }
    if ($(parent).find('> .el-button-holder .MR_Custom').length === 0) {
        var a = $t.ce('a');
        var i = $t.ce('i');
        $(i).addClass('fa fa-pencil-square-o').appendTo(a);
        var title = COM_MARKETINGROCKET_EDIT_FORM;
        $(a).attr('data-original-title', title).addClass('MR_Custom hasTooltip btn-mini btn ');
        $(parent).find('> .el-button-holder').append(a);
        $(a).tooltip({
            container: 'body'
        });
    } else {
        var a = $(parent).find('> .el-button-holder .MR_Custom');
    }
    $(a).unbind('click').click(function() {
        $('#show-form-builder').click();
    })
};
MR_landing.prototype.formRemoved = function(el) {
    var $t = this;
    var $ = jQuery;
    if ($(el).parents('#MarketingRocket').length > 0) {
        var parents = $('#show-modal-setting').parents('.pull-left:first');
        parents.prev().show();
        parents.show();
        var popup = $('#jform_exit_popup');
        popup.find('option[value="default"]').removeAttr('disabled');
        popup.chosen('destroy').chosen();
    }
};
MR_landing.prototype.mediaDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'media').addClass('media complex-item').attr('id', $t.randString(6));
    var div = $t.ce('div');
    $t.isChildAdded = true;
    $(div).addClass('pull-left').appendTo(box);
    $t.imageboxDropped(div, 'media-object');
    var div = $t.ce('div');
    $(div).addClass('media-body').appendTo(box);
    var h4 = $t.ce('h4');
    $(h4).addClass('media-heading contenteditable').attr('contenteditable', 'true').appendTo(div).text('Title');
    $t.articleboxDropped(div, '');
    $t.isChildAdded = false;
    $t.addAdminsBtns(box);
    $t.addToParent(box, parent, className);
};
intialize.push('card');
colorpickersIds.push('#card_text_color');
colorpickersIds.push('#card_background_color');
MR_landing.prototype.cardDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'card').addClass('card complex-item thumbnail');
    var div = $t.ce('div');
    $(div).addClass('MR-ribbon right').attr('id', $t.randString(6)).appendTo(box);
    var span = $t.ce('span');
    $(span).attr('id', $t.randString(6)).text($t.lang('COM_MARKETINGROCKET_RIBBON')).appendTo(div);
    var img = $t.ce('img');
    $(img).attr('src', locationOfJoomla + '/media/com_marketingrocket/your-image-here.jpg').appendTo(box).attr('id', $t.randString(6));
    $t.isChildAdded = true;
    var h3 = $t.ce('h3');
    $(h3).addClass('contenteditable').attr('contenteditable', 'true').appendTo(box).text('Title').attr('id', $t.randString(6));
    var articleBox = $t.articleboxDropped(box, '');
    $(articleBox).find('.content').html('<p></p>');
    var div = $t.ce('div');
    $(div).addClass('text-center').appendTo(box);
    var btn = $t.buttonDropped(div, '');
    $t.isChildAdded = false;
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-picture-o', COM_MARKETINGROCKET_IMAGEBOX_SETTINGS);
    $t.customSetting(box, 'fa-bookmark fa-rotate-90', $t.lang('COM_MARKETINGROCKET_RIBBON'));
    $t.cardFunctions(box);
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.cardFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('.MR_Custom:first').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpCard();
        $t.modal('#card-setting-template', 'show');
    })
    $(box).find('.MR_Custom:last').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpImageBox();
        $t.modal('#imagebox-setting-template', 'show');
    })
};
MR_landing.prototype.beforeShowPopUpCard = function() {
    var $t = this;
    var $ = jQuery;
    if ($t.activeEl.find('.MR-ribbon:first').is(':visible')) {
        $('#card_show_show_1').next().attr('class', 'btn active btn-success');
        $('#card_show_show_0').next().attr('class', 'btn');
    } else {
        $('#card_show_show_1').next().attr('class', 'btn');
        $('#card_show_show_0').next().attr('class', 'btn active btn-danger');
    }
    if (!$t.activeEl.find('.MR-ribbon:first').hasClass('right')) {
        $('#card_position_left').next().attr('class', 'btn active btn-success');
        $('#card_position_right').next().attr('class', 'btn');
    } else {
        $('#card_position_left').next().attr('class', 'btn');
        $('#card_position_right').next().attr('class', 'btn active btn-success');
    }
    var id = $t.activeEl.find('.MR-ribbon:first span').attr('id');
    if ($t.inlineCss[id] != undefined) {
        $('#card_text_color').val($t.inlineCss[id].styles.color).ColorPickerSetColor($t.inlineCss[id].styles.color);
    } else
        $('#card_text_color').val('');
    var id = $t.activeEl.find('.MR-ribbon:first').attr('id');
    if ($t.inlineCss[id] != undefined) {
        $('#card_background_color').val($t.inlineCss[id].styles['background-color']).ColorPickerSetColor($t.inlineCss[id].styles['background-color']);
    } else
        $('#card_background_color').val('');
    $('#card_text').val($t.activeEl.find('.MR-ribbon:first span').text());
};
MR_landing.prototype.card = function() {
    var $t = this;
    var $ = jQuery;
    $('#card_show_show_1').click(function() {
        $t.activeEl.find('.MR-ribbon:first').show();
    });
    $('#card_show_show_0').click(function() {
        $t.activeEl.find('.MR-ribbon:first').hide();
    });
    $('#card_position_left').click(function() {
        $t.activeEl.find('.MR-ribbon:first').removeClass('right');
    });
    $('#card_position_right').click(function() {
        $t.activeEl.find('.MR-ribbon:first').addClass('right');
    });
    $('#card_text_color').keyup(function() {
        var id = $t.activeEl.find('.MR-ribbon:first span').attr('id');
        if ($t.inlineCss[id] == undefined)
            $t.createCssObj(id, '');
        $t.inlineCss[id].styles.color = $(this).val();
        $t.writeCss();
    });
    $('#card_background_color').keyup(function() {
        var id = $t.activeEl.find('.MR-ribbon:first').attr('id');
        if ($t.inlineCss[id] == undefined)
            $t.createCssObj(id, '');
        $t.inlineCss[id].styles['background-color'] = $(this).val();
        $t.writeCss();
    });
    $('#card_text').keyup(function() {
        $t.activeEl.find('.MR-ribbon:first span').text($(this).val());
    });
};
intialize.push('loadmodule');
MR_landing.prototype.loadmoduleDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'loadmodule').addClass('loadmodule');
    var div = $t.ce('div');
    $(div).addClass('MR-module-holder').appendTo(box);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-cogs', $t.lang('COM_MARKETINGROCKET_LOADMODULE_SETTINGS'));
    $t.loadmoduleFunctions(box);
    $t.addToParent(box, parent, className);
    $(box).find('.MR_Custom').click();
};
MR_landing.prototype.loadmoduleFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('.MR_Custom').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpLoadmodule();
        $t.modal('#loadmodule-setting-template', 'show');
    })
};
MR_landing.prototype.beforeShowPopUpLoadmodule = function() {
    var $t = this;
    var $ = jQuery;
    var val = $t.activeEl.find('.MR-module-holder');
    if (val != '') {
        val = val.text().replace('{loadmodule ', '');
        val = val.replace('}', '');
    };
    $('#jform_load_modules').val(val).chosen('destroy').chosen();
};
MR_landing.prototype.loadmodule = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_load_modules').change(function() {
        var tar = $t.activeEl.find('.MR-module-holder');
        tar.html('');
        var val = this.value;
        if (val) {
            tar.text('{loadmodule ' + val + '}');
        };
    })
};
intialize.push('loadposition');
MR_landing.prototype.loadpositionDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'loadposition').addClass('loadposition');
    var div = $t.ce('div');
    $(div).addClass('MR-module-holder').appendTo(box);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-cogs', $t.lang('COM_MARKETINGROCKET_LOADMODULE_SETTINGS'));
    $t.loadpositionFunctions(box);
    $t.addToParent(box, parent, className);
    $(box).find('.MR_Custom').click();
};
MR_landing.prototype.loadpositionFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('.MR_Custom').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpLoadposition();
        $t.modal('#loadposition-setting-template', 'show');
    })
};
MR_landing.prototype.beforeShowPopUpLoadposition = function() {
    var $t = this;
    var $ = jQuery;
    var val = $t.activeEl.find('.MR-module-holder').text();
    if (val != '') {
        val = val.replace('{loadposition ', '');
        val = val.replace('}', '');
    };
    $('#jform_load_position').val(val);
};
MR_landing.prototype.loadposition = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_load_position').blur(function() {
        var tar = $t.activeEl.find('.MR-module-holder');
        tar.html('');
        var val = this.value;
        if (val) {
            tar.text('{loadposition ' + val + '}');
        };
    }).keyup(function() {
        $(this).blur();
    });
};
intialize.push('wizard');
MR_landing.prototype.wizardDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'wizard').addClass('wizard complex-item').attr('id', $t.randString(6));
    var div = $t.ce('div');
    $(div).addClass('wizard-holder text-center').appendTo(box);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-magic', $t.lang('COM_MARKETINGROCKET_WIZARD_SETTINGS'));
    $t.wizardFunctions(box);
    $t.addToParent(box, parent, className);
    $t.wizardCreateView(box, 2);
};
MR_landing.prototype.wizardCreateView = function(box, length, content) {
    var $t = this;
    var $ = jQuery;
    var prefix = $(box).attr('id');
    var box = $(box).find('.wizard-holder');
    var defWidth = 1.5;
    length = parseInt(length);
    switch (length) {
        case 3:
        case 4:
        case 5:
        case 6:
            defWidth = 2;
            break;
    };
    var width = (100 / length) - defWidth;
    var leftPercent = (100 / length);
    var ul = $(box).find(' > ul');
    var allLi = [];
    if (ul.length == 0) {
        var ul = $t.ce('ul');
        $(ul).addClass('nav nav-pills nav-wizard').prependTo(box);
    } else
        allLi = ul.find('li');
    if (!content) {
        box.find('.tab-content').remove();
    } else {
        var allPane = [];
        if (box.find('.tab-content').length == 0) {
            var contentEl = $t.ce('div');
            $(contentEl).addClass('tab-content').appendTo(box);
        } else {
            contentEl = box.find('.tab-content');
            allPane = contentEl.find('> .tab-pane');
        };
    };
    $t.isChildAdded = true;
    for (var i = 0; i < length; i++) {
        var left = (i * leftPercent);
        if (left == 0)
            left = defWidth / 2;
        if (allLi[i]) {
            var li = allLi.eq(i);
            if (pageDirection == 'ltr')
                li.css('width', width + '%').css('left', left + '%');
            else
                li.css('width', width + '%').css('right', left + '%');
            if (i + 1 < length && li.find('.nav-arrow').length == 0) {
                var div = $t.ce('div');
                $(div).addClass('nav-arrow').appendTo(li);
            } else if (i + 1 == length && li.find('.nav-arrow').length > 0)
                li.find('.nav-arrow').remove();
        } else {
            var li = $t.ce('li');
            if (pageDirection == 'ltr')
                $(li).css('width', width + '%').css('left', left + '%').appendTo(ul);
            else
                $(li).css('width', width + '%').css('right', left + '%').appendTo(ul);
            var a = $t.ce('a');
            $(a).attr('data-toggle', 'tab').attr('href', '#' + prefix + '-' + i);
            var span = $t.ce('span');
            $(span).addClass('contenteditable').attr('contenteditable', 'true').appendTo(a).text('step ' + (i + 1));
            if (i == 0) {
                $(li).addClass('active');
                $(a).appendTo(li);
            } else {
                var div = $t.ce('div');
                $(div).addClass('nav-wedge').appendTo(li);
                $(a).appendTo(li);
            };
            if (i + 1 < length) {
                var div = $t.ce('div');
                $(div).addClass('nav-arrow').appendTo(li);
            };
        };
        if (content) {
            if (allPane[i]) {
                continue;
            } else {
                var div = $t.ce('div');
                $(div).addClass('tab-pane').attr('id', prefix + '-' + i).appendTo(contentEl);
                if (i == 0) {
                    $(div).addClass('active');
                };
                var row = $t.ce('div');
                $(row).addClass('row row-fluid haschild').appendTo(div);
                var articleBox = $t.articleboxDropped(row, 12);
            };
        };
    };
    $t.isChildAdded = false;
    var orig = i;
    while (allLi[orig]) {
        allLi.eq(orig).remove();
        orig++;
    };
    var orig = i;
    if (content) {
        while (allPane[orig]) {
            allPane.eq(orig).remove();
            orig++;
        };
    };
};
MR_landing.prototype.wizardFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('> .el-button-holder .MR_Custom:first').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpWizard();
        $t.modal('#wizard-setting-template', 'show');
    })
};
MR_landing.prototype.beforeShowPopUpWizard = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_wizard_count').val($t.activeEl.find('.wizard-holder > ul > li').length).chosen('destroy').chosen();
    if ($t.activeEl.find('.tab-content').length > 0) {
        $('#jform_wizard_have_desc0').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_wizard_have_desc1').prop('checked', false).next().attr('class', 'btn');
    } else {
        $('#jform_wizard_have_desc1').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_wizard_have_desc0').prop('checked', false).next().attr('class', 'btn');
    };
    var className = $t.activeEl.find('.wizard-holder > ul').attr('class').replace('nav nav-pills nav-wizard', '');
    className = $.trim(className);
    $('#jform_wizard_template').val(className).chosen('destroy').chosen();
};
MR_landing.prototype.wizard = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_wizard_count').change(function() {
        $t.wizardCreateView($t.activeEl, $(this).val(), parseInt($('[name="jform[wizard_have_desc]"]:checked').val()));
    });
    $('#jform_wizard_template').change(function() {
        $t.activeEl.find('ul.nav-pills').attr('class', 'nav nav-pills nav-wizard ' + $(this).val())
    });
    $('#jform_wizard_have_desc0,#jform_wizard_have_desc1').click(function() {
        var val = $(this).val();
        if (val == 1) {
            if ($t.activeEl.find('.tab-content').length > 0)
                return;
            $t.wizardCreateView($t.activeEl, $('#jform_wizard_count').val(), true);
        } else {
            $t.wizardCreateView($t.activeEl, $('#jform_wizard_count').val(), false);
        };
    })
};
intialize.push('pricatetable');
colorpickersIds.push('#jform_pricetable_background_0');
colorpickersIds.push('#jform_pricetable_background_1');
colorpickersIds.push('#jform_pricetable_background_2');
colorpickersIds.push('#jform_pricetable_background_3');
colorpickersIds.push('#jform_pricetable_background_4');
colorpickersIds.push('#jform_pricetable_background_5');
colorpickersIds.push('#jform_pricetable_color_0');
colorpickersIds.push('#jform_pricetable_color_1');
colorpickersIds.push('#jform_pricetable_color_2');
colorpickersIds.push('#jform_pricetable_color_3');
colorpickersIds.push('#jform_pricetable_color_4');
colorpickersIds.push('#jform_pricetable_color_5');
MR_landing.prototype.pricatetableDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'pricatetable').addClass('pricatetable complex-item').attr('data-template', '1');
    var tableHolder = $t.ce('div');
    $(tableHolder).addClass('pricetable-holder').appendTo(box).attr('id', $t.randString(6));
    if ($t.tableTemplates[1] == undefined) {
        $t.loadTableTemplate(1, box);
    } else {
        $t.createPricatetable(box);
    };
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-table', $t.lang('COM_MARKETINGROCKET_PRICETABLE_SETTINGS'));
    $t.pricatetableFunctions(box);
    $t.addToParent(box, parent, className);
    $t.writeCss();
    $(box).find(' > .el-button-holder .MR_Custom:first').click();
};
MR_landing.prototype.createPricatetable = function(parent) {
    var $t = this;
    var $ = jQuery;
    $(parent).find('.pricetable-holder').html($t.tableTemplates[$(parent).data('template')].html).attr('class', 'pricetable-holder table' + $(parent).data('template'));
    $t.isChildAdded = true;
    $(parent).find('.add-element').each(function() {
        var type = $(this).data('addelement');
        $t.pricatetableCallItemFunction(this, type);
    });
    $t.isChildAdded = false;
    $t.writeCss();
};
MR_landing.prototype.pricatetableCallItemFunction = function(mainEl, type) {
    var $t = this;
    var $ = jQuery;
    try {
        var el = $t[type + "Dropped"]($(mainEl).find('div'), '');
        if (type == 'icon') {
            $(el).find('span.fa').attr('data-size', 2).removeClass('fa-smile-o').addClass('fa-check');
        };
        return el;
    } catch (e) {
        console.log(e);
        console.log(type);
    }
}
MR_landing.prototype.pricatetableFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find(' > .el-button-holder .MR_Custom:first').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPricatetable();
        $t.modal('#pricetable-setting-template', 'show');
    })
};
MR_landing.prototype.beforeShowPricatetable = function() {
    var $t = this;
    var $ = jQuery;
    var selectedTemplate = $t.activeEl.data('template');
    var data = $t.tableTemplates[selectedTemplate].data;
    $('#pricetable-setting-template').find('small:first').text('#' + $t.activeEl.find('.pricetable-holder').attr('id'))
    var parentId = $t.activeEl.attr('id');
    var colors = $('#pricetable-setting-template .pricetable-color-input');
    for (var i = 0; i < colors.length; i++) {
        if (data.colors[i] != undefined) {
            var parent = colors.eq(i).parents('.control-group:first');
            parent.find('label').text(data.colors[i].title);
            parent.show();
            colors.eq(i).val('');
            try {
                var color = $t.inlineCss[parentId].pricetables[data.background[i].class]['color'];
                colors.eq(i).val(color).ColorPickerSetColor(color);
            } catch (e) {};
        } else {
            colors.eq(i).parents('.control-group:first').hide();
        };
    };
    var colors = $('#pricetable-setting-template .pricetable-background-input');
    for (var i = 0; i < colors.length; i++) {
        if (data.background[i] != undefined) {
            var parent = colors.eq(i).parents('.control-group:first');
            parent.find('label').text('').text(data.background[i].title);
            parent.show();
            colors.eq(i).val('');
            try {
                var color = $t.inlineCss[parentId].pricetables[data.background[i].class]['background-color'];
                colors.eq(i).val(color).ColorPickerSetColor(color);
            } catch (e) {};
        } else {
            colors.eq(i).parents('.control-group:first').hide();
        };
    };
    $('#jform_pricetable_column_count').val($t.activeEl.find('.repeatable:first').find('.copycell').length).chosen('destroy').chosen();
    $('#jform_pricetable_row_count').val($t.activeEl.find('.repeatable').length).chosen('destroy').chosen();
    $('#jform_pricetable_recomended_column').val($t.activeEl.find('tr.repeatable:first').find('td.recommended').index() + 1).chosen('destroy').chosen();
    $('#jform_pricetable_templates').val($t.activeEl.data('template')).chosen('destroy').chosen();
    var type;
    if (typeof(type) == 'undefined') {
        var child = $(this).find('[aria-type]');
        if (child.length > 0)
            type = child.attr('aria-type');
    }
};
MR_landing.prototype.loadTableTemplate = function(template_id, parent, not_creaet) {
    var $t = this;
    var $ = jQuery;
    if ($t.tableTemplates[template_id] != undefined) {
        if (not_creaet == undefined) {
            $t.createPricatetable(parent);
            $t.activeEl.find(' > .el-button-holder .MR_Custom:first').click();
        };
        return;
    };
    $('#loading-holder').show();
    $.ajax({
        url: 'index.php?option=com_marketingrocket&task=landing.tabletemplate',
        data: {
            template: template_id
        },
        dataType: 'json'
    }).done(function(res) {
        $t.tableTemplates[template_id] = res.data;
        if (not_creaet == undefined) {
            $t.createPricatetable(parent);
        } else
            $t.writeCss();
        try {
            $t.activeEl.find(' > .el-button-holder .MR_Custom:first').click();
        } catch (e) {};
        $('#loading-holder').hide();
    });
};
MR_landing.prototype.pricatetableCssOverride = function(css) {
    var $t = this;
    var $ = jQuery;
    if (typeof(css) == 'string') {
        $('.pricatetable').each(function() {
            css += $t.tableTemplates[$(this).data('template')].css;
        });
        for (var i in $t.inlineCss) {
            if ($t.inlineCss[i] == undefined)
                continue;
            if ($t.inlineCss[i].pricetables == undefined)
                continue;
            if (objectSize($t.inlineCss[i].pricetables) > 0) {
                for (var className in $t.inlineCss[i].pricetables) {
                    css += '#' + i + ' ' + className + ' {\n';
                    for (var s in $t.inlineCss[i].pricetables[className]) {
                        if ($t.inlineCss[i].pricetables[className][s] == '')
                            continue;
                        css += s + ' : ' + $t.inlineCss[i].pricetables[className][s] + ';\n';
                    };
                    css += '}\n';
                };
            };
        };
    } else {
        for (var i in $t.inlineCss) {
            if ($t.inlineCss[i] == undefined)
                continue;
            if ($t.inlineCss[i].pricetables == undefined)
                continue;
            if (objectSize($t.inlineCss[i].pricetables) > 0) {
                var obj = css[i];
                obj.pricetables = {};
                for (var className in $t.inlineCss[i].pricetables) {
                    obj.pricetables[className] = {};
                    for (var s in $t.inlineCss[i].pricetables[className]) {
                        if ($t.inlineCss[i].pricetables[className][s] == '')
                            continue;
                        obj.pricetables[className][s] = $t.inlineCss[i].pricetables[className][s];
                    };
                };
                css[i] = obj;
            };
        };
    };
    return css;
};
MR_landing.prototype.pricatetable = function() {
    var $t = this;
    var $ = jQuery;
    $t.tableTemplates = {};
    $t.cssOverRides.push('pricatetableCssOverride');
    $('#jform_pricetable_column_count').change(function() {
        var tr = $t.activeEl.find('tr.repeatable:first');
        var tdLength = tr.find('td.copycell').length;
        var val = parseInt($(this).val());
        if (tdLength > val) {
            do {
                $t.activeEl.find('tr').each(function() {
                    $(this).find('.copycell').eq(val).remove();
                });
            }
            while ($t.activeEl.find('tr:first').find('.copycell').eq(val).length > 0);
        } else {
            var mustAdd = val - tdLength;
            var template = $($t.tableTemplates[$t.activeEl.data('template')].html);
            var templateCopyRow = template.find('tr');
            $t.isChildAdded = true;
            $t.activeEl.find('tr').each(function(index) {
                for (var i = 0; i < mustAdd; i++) {
                    var last = $(this).find('.copycell:last');
                    var cl = last.clone();
                    cl.removeClass('recommended').insertAfter(last);
                    cl.find('.add-element').each(function() {
                        $(this).find('> div').html('');
                        var type = $(this).data('addelement');
                        $t.pricatetableCallItemFunction(this, type);
                    });
                };
            });
            $t.isChildAdded = false;
        };
    });
    $('#jform_pricetable_recomended_column').change(function() {
        var val = parseInt($(this).val()) - 1;
        $t.activeEl.find('.recommended').removeClass('recommended');
        if (val < 0)
            return true;
        $t.activeEl.find('tr').each(function(index) {
            $(this).find('.copycell').eq(val).addClass('recommended');
        });
    });
    $('#jform_pricetable_row_count').change(function() {
        var trLength = $t.activeEl.find('tr.repeatable').length;
        var val = parseInt($(this).val());
        if (trLength > val) {
            while ($t.activeEl.find('tr.repeatable').eq(val).length > 0) {
                $t.activeEl.find('tr.repeatable').eq(val).remove();
            };
        } else {
            var mustAdd = val - trLength;
            var template = $t.activeEl.find('tr.repeatable:first');
            for (var i = 0; i < mustAdd; i++) {
                var tr = template.clone();
                tr.insertAfter($t.activeEl.find('tr.repeatable:last'));
                tr.find('.add-element').each(function() {
                    $(this).find('> div').html('');
                    var type = $(this).data('addelement');
                    $t.pricatetableCallItemFunction(this, type);
                });
            };
        };
    });
    $('#pricetable-setting-template .pricetable-background-input,#pricetable-setting-template .pricetable-color-input').keyup(function() {
        var id = $(this).attr('id');
        var index = id.split('_');
        index = index.pop();
        var selectedTemplate = $t.activeEl.data('template');
        var data = $t.tableTemplates[selectedTemplate].data;
        var aElId = $t.activeEl.attr('id');
        var type = 'color';
        var dataType = 'colors';
        if ($(this).hasClass('background-color')) {
            type = 'background-color';
            dataType = 'background';
        };
        if (data[dataType][index] != undefined) {
            if ($t.inlineCss[aElId] == undefined) {
                $t.createCssObj(aElId);
            };
            if ($t.inlineCss[aElId].pricetables == undefined)
                $t.inlineCss[aElId].pricetables = {};
            var className = data[dataType][index].class;
            if ($t.inlineCss[aElId].pricetables[className] == undefined)
                $t.inlineCss[aElId].pricetables[className] = {};
            $t.inlineCss[aElId].pricetables[className][type] = $(this).val();
            $t.writeCss();
        } else {
            alert(index);
        };
    });
    $('#jform_pricetable_templates').change(function() {
        $t.activeEl.attr('data-template', $(this).val()).data('template', $(this).val());
        $t.loadTableTemplate($(this).val(), $t.activeEl);
    });
    $('.pricatetable').each(function() {
        $t.loadTableTemplate($(this).data('template'), '', true);
    });
};
intialize.push('progress');
colorpickersIds.push('#jform_progress_background_color');
MR_landing.prototype.progressDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'progress').addClass('progress');
    var div = $t.ce('div');
    $(div).addClass('bar').css('width', '50%').css('height', '20px').appendTo(box);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-tasks', $t.lang('COM_MARKETINGROCKET_PROGRESS'));
    $t.progressFunctions(box);
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.progressFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('.MR_Custom').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpProgress();
        $t.modal('#progress-setting-template', 'show');
    });
};
MR_landing.prototype.beforeShowPopUpProgress = function() {
    var $t = this;
    var $ = jQuery;
    $('#progress-setting-template').find('small:first').text('#' + $t.activeEl.attr('id'))
    var bar = $t.activeEl.find('.bar');
    var bg = bar.css('background-color');
    bg = $t.rgb2hex(bg);
    $('#jform_progress_background_color').val(bg).ColorPickerSetColor(bg);
    var width = bar.attr('style').match(/\d{1,2}%/);
    width = parseInt(width);
    $('#jform_progress_width').val(width);
    if ($t.activeEl.hasClass('progress-striped')) {
        $('#jform_progress_is_striped0').next().attr('class', 'btn active btn-success').prop('checked', true);
        $('#jform_progress_is_striped1').next().attr('class', 'btn').prop('checked', false);
    } else {
        $('#jform_progress_is_striped0').next().attr('class', 'btn').prop('checked', false);
        $('#jform_progress_is_striped1').next().attr('class', 'btn active btn-danger').prop('checked', true);
    };
    $('#jform_progress_text').val(bar.text());
};
MR_landing.prototype.progress = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_progress_background_color').keyup(function() {
        $t.activeEl.find('.bar').css('background-color', $(this).val());
    });
    $('#jform_progress_is_striped0').click(function() {
        $t.activeEl.addClass('progress-striped');
    });
    $('#jform_progress_is_striped1').click(function() {
        $t.activeEl.removeClass('progress-striped');
    });
    $('#jform_progress_text').keyup(function() {
        $t.activeEl.find('.bar').text($(this).val());
    });
    $('#jform_progress_width').keyup(function() {
        $t.activeEl.find('.bar').css('width', $(this).val() + '%');
    }).blur(function() {
        $(this).keyup()
    });
};
intialize.push('comment');
colorpickersIds.push('#jform_comment_background_color');
MR_landing.prototype.commentDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'comment').addClass('comment complex-item template1');
    var div = $t.ce('div');
    $(div).addClass('comment-holder').attr('id', $t.randString(6)).appendTo(box);
    var div = $t.ce('div');
    $(div).addClass('text-center image-holder').appendTo(box);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-commenting-o', $t.lang('COM_MARKETINGROCKET_COMMENT'));
    $t.commentFunctions(box);
    $t.addToParent(box, parent, className);
    $t.createComment(box, 1);
};
MR_landing.prototype.createComment = function(parent, template) {
    var $t = this;
    var $ = jQuery;
    $t.isChildAdded = true;
    var div = $(parent).find('.comment-holder');
    div.html('');
    var articleBox = $t.articleboxDropped(div, '');
    $(articleBox).find('.content').html('<p></p>');
    var div = $(parent).find('.image-holder');
    div.html('');
    var imgbox = $t.imageboxDropped(div, 'avatar');
    $(imgbox).find('img').attr('src', locationOfJoomla + '/media/com_marketingrocket/eden-brownlee-tie.jpg');
    $t.isChildAdded = false;
};
MR_landing.prototype.commentFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('> .el-button-holder .MR_Custom').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpComment();
        $t.modal('#comment-setting-template', 'show');
    })
};
MR_landing.prototype.beforeShowPopUpComment = function() {
    var $t = this;
    var $ = jQuery;
    $('#comment-setting-template').find('.comment-holder').text('#' + $t.activeEl.attr('id'))
    var bar = $t.activeEl.find('.comment-holder');
    var bg = bar.css('background-color');
    bg = $t.rgb2hex(bg);
    $('#jform_comment_background_color').val(bg).ColorPickerSetColor(bg);
    if ($t.activeEl.hasClass('template1'))
        $('#jform_comment_template').val(1).chosen('destroy').chosen();
    else
        $('#jform_comment_template').val(2).chosen('destroy').chosen();
};
MR_landing.prototype.commentCssOverride = function(css) {
    var $t = this;
    var $ = jQuery;
    if (typeof(css) == 'string') {
        for (var i in $t.inlineCss) {
            if ($t.inlineCss[i] == undefined)
                continue;
            if ($t.inlineCss[i].after == undefined)
                continue;
            if (objectSize($t.inlineCss[i].after) > 0) {
                css += '#' + i + ':after {\n';
                for (var s in $t.inlineCss[i].after) {
                    if ($t.inlineCss[i].after == '')
                        continue;
                    css += s + ' : ' + $t.inlineCss[i].after[s] + ';\n';
                }
                css += '}\n';
            }
            if (objectSize($t.inlineCss[i].before) > 0) {
                css += '#' + i + ':before {\n';
                for (var s in $t.inlineCss[i].before) {
                    if ($t.inlineCss[i].before == '')
                        continue;
                    css += s + ' : ' + $t.inlineCss[i].before[s] + ';\n';
                }
                css += '}\n';
            }
        }
    } else {
        for (var i in $t.inlineCss) {
            if ($t.inlineCss[i] == undefined)
                continue;
            if ($t.inlineCss[i].after == undefined)
                continue;
            if (objectSize($t.inlineCss[i].after) > 0) {
                var obj = css[i];
                obj.after = {};
                for (var s in $t.inlineCss[i].after) {
                    if ($t.inlineCss[i].after == '')
                        continue;
                    obj.after[s] = $t.inlineCss[i].after[s];
                }
                css[i] = obj;
            }
            if (objectSize($t.inlineCss[i].before) > 0) {
                var obj = css[i];
                obj.before = {};
                for (var s in $t.inlineCss[i].before) {
                    if ($t.inlineCss[i].before == '')
                        continue;
                    obj.before[s] = $t.inlineCss[i].before[s];
                }
                css[i] = obj;
            }
        }
    }
    return css;
};
MR_landing.prototype.comment = function() {
    var $t = this;
    var $ = jQuery;
    $t.cssOverRides.push('commentCssOverride');
    $('#jform_comment_template').change(function() {
        if ($(this).val() == 1) {
            $t.activeEl.find('.image-holder').insertAfter($t.activeEl.find('.comment-holder'));
            $t.activeEl.removeClass('template2').addClass('template1');
        } else {
            $t.activeEl.find('.image-holder').insertBefore($t.activeEl.find('.comment-holder'));
            $t.activeEl.removeClass('template1').addClass('template2');
        }
    });
    $('#jform_comment_background_color').keyup(function() {
        var div = $t.activeEl.find('.comment-holder');
        var id = div.attr('id');
        if ($t.inlineCss[id] == undefined) {
            $t.createCssObj(id);
        }
        if ($t.inlineCss[id].after == undefined) {
            $t.inlineCss[id].after = {};
            $t.inlineCss[id].before = {};
        }
        $t.inlineCss[id].styles['background-color'] = $(this).val();
        $t.inlineCss[id].after['border-color'] = $(this).val() + ' transparent transparent transparent';
        $t.inlineCss[id].before['border-color'] = 'transparent ' + $(this).val() + ' transparent transparent';
        $t.writeCss();
    })
};
intialize.push('video');
MR_landing.prototype.videoDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'video').addClass('video');
    var video = $t.ce('video');
    $(video).text($t.lang('COM_MARKETINGROCKET_YOUR_BROWSER_DOES_NOT_SUPPORT_THE_VIDEO_TAG')).attr('width', '100%').attr('height', '100%').attr('controls', '').appendTo(box);
    var source = $t.ce('source');
    $(source).attr('type', 'video/mp4').appendTo(video);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-film', $t.lang('COM_MARKETINGROCKET_VIDEO_SETTINGS'));
    $t.videoFunctions(box);
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.videoFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('.MR_Custom:first').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpVideo();
        $t.modal('#video-setting-template', 'show');
    })
};
MR_landing.prototype.beforeShowPopUpVideo = function() {
    var $t = this;
    var $ = jQuery;
    var video = $t.activeEl.find('video')
    $('#jform_videoel_file').val(video.find('source').attr('src'));
    var width = $t.getDimension(video.attr('width'), $('#jform_video_width'));
    $('#jform_videoel_width').val(width);
    var h = $t.getDimension(video.attr('height'), $('#jform_videoel_height'));
    $('#jform_videoel_height').val(h);
    if (video.attr('autoplay')) {
        $('#jform_videoel_autoplay1').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_videoel_autoplay0').next().attr('class', 'btn');
    } else {
        $('#jform_videoel_autoplay1').next().attr('class', 'btn');
        $('#jform_videoel_autoplay0').prop('checked', true).next().attr('class', 'btn active btn-danger');
    }
    if (video.attr('controls')) {
        $('#jform_videoel_control1').prop('checked', true).next().attr('class', 'btn active btn-success');
        $('#jform_videoel_control0').next().attr('class', 'btn');
    } else {
        $('#jform_videoel_control1').next().attr('class', 'btn');
        $('#jform_videoel_control0').prop('checked', true).next().attr('class', 'btn active btn-danger');
    }
};
MR_landing.prototype.video = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_videoel_file').keyup(function() {
        $t.activeEl.find('source').attr('src', joomlaHost + $(this).val().substr(1));
        $t.activeEl.find('video')[0].load();
    });
    $('#jform_videoel_width').keyup(function() {
        var width = $t.setDimensionValue($(this).val(), $(this));
        $t.activeEl.find('video').attr('width', width);
    });
    $('#jform_videoel_height').keyup(function() {
        var width = $t.setDimensionValue($(this).val(), $(this));
        $t.activeEl.find('video').attr('height', width);
    });
    $('#video-setting-template [name="jform[videoel_control]"]').click(function() {
        var val = $(this).val();
        if (val == 1) {
            $t.activeEl.find('video').attr('controls', '');
        } else {
            $t.activeEl.find('video').removeAttr('controls');
        }
    });
    $('#video-setting-template [name="jform[videoel_autoplay]"]').click(function() {
        var val = $(this).val();
        if (val == 1) {
            $t.activeEl.find('video').attr('autoplay', '')[0].load();
        } else {
            $t.activeEl.find('video').removeAttr('autoplay');
        }
    });
};
intialize.push('label');
colorpickersIds.push('#jform_label_backgroundcolor');
MR_landing.prototype.labelDropped = function(parent, className) {
    var $t = this;
    var $ = jQuery;
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'label').addClass('label_element');
    var div = $t.ce('div');
    $(div).addClass('label-holder label-' + $('#jform_label_template').val()).attr('data-template', $('#jform_label_template').val()).attr('id', $t.randString(6)).appendTo(box);
    var span = $t.ce('span');
    var id = $t.randString(6);
    $(span).addClass('fa fa-smile-o').attr('id', id).attr('data-size', '1');
    $(div).append(span);
    var span = $t.ce('span');
    $(span).attr('id', $t.randString(6)).attr('contenteditable', 'true').addClass('contenteditable').text(' Label').appendTo(div);
    $t.addAdminsBtns(box);
    $t.customSetting(box, 'fa-smile-o', COM_MARKETINGROCKET_ICON_EDIT_TITLE);
    $t.customSetting(box, 'fa-tag', $t.lang('COM_MARKETINGROCKET_LABEL_SETTINGS'));
    $t.labelFunctions(box);
    $t.addToParent(box, parent, className);
    $t.createCssObj(id, span);
    return box;
};
MR_landing.prototype.labelFunctions = function(box) {
    var $t = this;
    var $ = jQuery;
    $(box).find('a.MR_Custom:last').click(function() {
        $t.activeEl = $(box).find('.label-holder');
        $t.beforeShowPopUpIcon();
        $t.modal('#icon_setting', 'show');
    });
    $(box).find('a.MR_Custom:first').click(function() {
        $t.activeEl = $(box);
        $t.beforeShowPopUpLabel();
        $t.modal('#label-setting-template', 'show');
    });
};
MR_landing.prototype.beforeShowPopUpLabel = function() {
    var $t = this;
    var $ = jQuery;
    var el = $t.activeEl.find('.label-holder');
    $('#jform_label_template').val(el.data('template')).chosen('destroy').chosen();
    var bg = el.css('background-color');
    bg = $t.rgb2hex(bg);
    $('#jform_label_backgroundcolor').val(bg).ColorPickerSetColor(bg);
};
MR_landing.prototype.label = function() {
    var $t = this;
    var $ = jQuery;
    $('#jform_label_template').change(function() {
        var el = $t.activeEl.find('.label-holder');
        el.attr('class', 'label-holder');
        var val = $(this).val();
        var newClass = val.replace('.', ' ');
        el.attr('data-template', val).data('template', val).addClass('label-' + newClass);
        $('#jform_label_backgroundcolor').val('').keyup();
    });
    $('#jform_label_backgroundcolor').keyup(function() {
        var template = $('#jform_label_template').val().split('.');
        template = template[0];
        var div = $t.activeEl.find('.label-holder');
        var id = div.attr('id');
        if ($t.inlineCss[id] == undefined) {
            $t.createCssObj(id);
        }
        $t.inlineCss[id].after = {};
        $t.inlineCss[id].before = {};
        $t.inlineCss[id].styles['background-color'] = $(this).val();
        if ($(this).val() != '') {
            if (template == '2') {
                if (pageDirection == 'ltr')
                    $t.inlineCss[id].before['border-color'] = 'transparent ' + $(this).val() + ' transparent transparent';
                else
                    $t.inlineCss[id].before['border-color'] = 'transparent transparent transparent ' + $(this).val();
            }
            if (template == '3') {
                $t.inlineCss[id].styles['background-color'] = 'transparent';
                $t.inlineCss[id].before['background-color'] = $(this).val();
                $t.inlineCss[id].after['background-color'] = $(this).val();
            }
            if (template == '4') {
                if (pageDirection == 'ltr') {
                    $t.inlineCss[id].before['border-color'] = 'transparent ' + $(this).val() + ' transparent transparent';
                    $t.inlineCss[id].after['border-color'] = 'transparent transparent ' + $(this).val() + ' transparent';
                } else {
                    $t.inlineCss[id].before['border-color'] = $(this).val() + ' transparent transparent transparent';
                    $t.inlineCss[id].after['border-color'] = 'transparent transparent transparent ' + $(this).val();
                }
            }
        }
        $t.writeCss();
    });
};