intialize.push('label');
colorpickersIds.push('#jform_label_backgroundcolor');
MR_landing.prototype.labelDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'label').addClass('label_element');
    
    var div = $t.ce('div');
    $(div).addClass('label-holder label-'+$('#jform_label_template').val())
            .attr('data-template', $('#jform_label_template').val())
            .attr('id', $t.randString(6))
            .appendTo(box)
    ;
    
    
    var span = $t.ce('span');
    var id = $t.randString(6);
    
    $(span).addClass('fa fa-smile-o').attr('id', id).attr('data-size', '1');
    $(div).append(span);
    
    var span = $t.ce('span');
    $(span).attr('id', $t.randString(6)).attr('contenteditable', 'true').addClass('contenteditable').text(' Label').appendTo(div);


    $t.addAdminsBtns(box);

    $t.customSetting(box, 'fa-smile-o', COM_MARKETINGROCKET_ICON_EDIT_TITLE);
    $t.customSetting(box, 'fa-tag', $t.lang('COM_MARKETINGROCKET_LABEL_SETTINGS'));
    $t.labelFunctions(box);


    $t.addToParent(box, parent, className);
    
    $t.createCssObj(id, span);
    
    return box;
};
MR_landing.prototype.labelFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('a.MR_Custom:last').click(function(){
        $t.activeEl = $(box).find('.label-holder');
        $t.beforeShowPopUpIcon();
        $t.modal('#icon_setting','show');
    });
    
    $(box).find('a.MR_Custom:first').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpLabel();
        $t.modal('#label-setting-template','show');
    });
};
MR_landing.prototype.beforeShowPopUpLabel = function(){
    var $t = this;
    var $ = jQuery;
    
    var el = $t.activeEl.find('.label-holder');
    
    $('#jform_label_template').val(el.data('template')).chosen('destroy').chosen();
    
    var bg = el.css('background-color');
    bg = $t.rgb2hex(bg);
    
    $('#jform_label_backgroundcolor').val(bg).ColorPickerSetColor(bg);
};
MR_landing.prototype.label = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#jform_label_template').change(function(){
        var el = $t.activeEl.find('.label-holder');
        el.attr('class', 'label-holder');
        
        var val = $(this).val();
        var newClass = val.replace('.', ' ');
        
        el.attr('data-template', val).data('template', val).addClass('label-'+newClass);
        
        $('#jform_label_backgroundcolor').val('').keyup();
    });
    $('#jform_label_backgroundcolor').keyup(function(){
        var template = $('#jform_label_template').val().split('.');
        template = template[0];
        
        var div = $t.activeEl.find('.label-holder');
        var id = div.attr('id');
        if($t.inlineCss[id] == undefined){
             $t.createCssObj(id);
        }
        
        $t.inlineCss[id].after = {};
        $t.inlineCss[id].before = {};
        
        $t.inlineCss[id].styles['background-color'] = $(this).val();
        if($(this).val() != ''){
            if(template == '2'){
                if(pageDirection == 'ltr')
                    $t.inlineCss[id].before['border-color'] =  'transparent '+$(this).val()+' transparent transparent';
                else 
                    $t.inlineCss[id].before['border-color'] =  'transparent transparent transparent '+$(this).val();

            }
            if(template == '3'){
                $t.inlineCss[id].styles['background-color'] = 'transparent';
                $t.inlineCss[id].before['background-color'] =  $(this).val();
                $t.inlineCss[id].after['background-color'] =  $(this).val();
            }
            if(template == '4'){
                if(pageDirection == 'ltr'){
                    $t.inlineCss[id].before['border-color'] =  'transparent '+$(this).val()+' transparent transparent';
                    $t.inlineCss[id].after['border-color'] =  'transparent transparent '+$(this).val()+' transparent';
                }
                else {
                    $t.inlineCss[id].before['border-color'] =  $(this).val()+' transparent transparent transparent';
                    $t.inlineCss[id].after['border-color'] =  'transparent transparent transparent '+$(this).val();
                }
            }
        }
        
        $t.writeCss();
    });
};