intialize.push('comment');
colorpickersIds.push('#jform_comment_background_color');
MR_landing.prototype.commentDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'comment').addClass('comment complex-item template1');
    
    var div = $t.ce('div');
    $(div).addClass('comment-holder').attr('id', $t.randString(6)).appendTo(box);
    
    var div = $t.ce('div');
    $(div).addClass('text-center image-holder').appendTo(box);
    
    
    $t.addAdminsBtns(box);
    
    $t.customSetting(box, 'fa-commenting-o', $t.lang('COM_MARKETINGROCKET_COMMENT'));
    $t.commentFunctions(box);
    
    $t.addToParent(box, parent, className);
    
    $t.createComment(box, 1);
};
MR_landing.prototype.createComment = function(parent, template){
    var $t = this;
    var $ = jQuery;
    
    $t.isChildAdded = true;
    
    var div = $(parent).find('.comment-holder');

    div.html('');
    var articleBox = $t.articleboxDropped(div, '');

    $(articleBox).find('.content').html('<p></p>');

    var div = $(parent).find('.image-holder');
    div.html('');
    var imgbox = $t.imageboxDropped(div, 'avatar');
    $(imgbox).find('img').attr('src', locationOfJoomla+'/media/com_marketingrocket/eden-brownlee-tie.jpg');
    
    $t.isChildAdded = false;
    
};
MR_landing.prototype.commentFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('> .el-button-holder .MR_Custom').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpComment();
        $t.modal('#comment-setting-template','show');
    })
};
MR_landing.prototype.beforeShowPopUpComment = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#comment-setting-template').find('.comment-holder').text('#'+$t.activeEl.attr('id'))
    
    var bar = $t.activeEl.find('.comment-holder');
    var bg = bar.css('background-color');
    bg = $t.rgb2hex(bg);
    $('#jform_comment_background_color').val(bg).ColorPickerSetColor(bg);
    
    if($t.activeEl.hasClass('template1'))
        $('#jform_comment_template').val(1).chosen('destroy').chosen();
    else
        $('#jform_comment_template').val(2).chosen('destroy').chosen();
};
MR_landing.prototype.commentCssOverride = function(css){
    var $t = this;
    var $ = jQuery;
    
    // TODO this part must be in main section
    if(typeof(css) == 'string'){
        for(var i in $t.inlineCss){
            if($t.inlineCss[i] == undefined)
                continue;
            if($t.inlineCss[i].after == undefined)
                continue;
            if(objectSize($t.inlineCss[i].after) > 0){
                css += '#'+i+':after {\n';
                for(var s in $t.inlineCss[i].after){
                    if($t.inlineCss[i].after == '')
                        continue;
                    css += s+' : '+$t.inlineCss[i].after[s]+';\n';
                }
                css += '}\n';
            }
            
            if(objectSize($t.inlineCss[i].before) > 0){
                css += '#'+i+':before {\n';
                for(var s in $t.inlineCss[i].before){
                    if($t.inlineCss[i].before == '')
                        continue;
                    css += s+' : '+$t.inlineCss[i].before[s]+';\n';
                }
                css += '}\n';
            }

        }
    }
    else {
        for(var i in $t.inlineCss){
            if($t.inlineCss[i] == undefined)
                continue;
            if($t.inlineCss[i].after == undefined)
                continue;

            if(objectSize($t.inlineCss[i].after) > 0){
                var obj = css[i];
                obj.after = {};
                for(var s in $t.inlineCss[i].after){
                    if($t.inlineCss[i].after == '')
                        continue;
                    obj.after[s] = $t.inlineCss[i].after[s];
                }
                css[i] = obj;
            }
            
            if(objectSize($t.inlineCss[i].before) > 0){
                var obj = css[i];
                obj.before = {};
                for(var s in $t.inlineCss[i].before){
                    if($t.inlineCss[i].before == '')
                        continue;
                    obj.before[s] = $t.inlineCss[i].before[s];
                }
                css[i] = obj;
            }

        }
        
    }
    return css;
};
MR_landing.prototype.comment = function(){
    var $t = this;
    var $ = jQuery;
    $t.cssOverRides.push('commentCssOverride');
    
    $('#jform_comment_template').change(function(){
       if($(this).val() == 1){
           $t.activeEl.find('.image-holder').insertAfter($t.activeEl.find('.comment-holder'));
           $t.activeEl.removeClass('template2').addClass('template1');
       }
       else{
           $t.activeEl.find('.image-holder').insertBefore($t.activeEl.find('.comment-holder'));
           $t.activeEl.removeClass('template1').addClass('template2');
       }
    });
    
    $('#jform_comment_background_color').keyup(function(){
        var div = $t.activeEl.find('.comment-holder');
        var id = div.attr('id');
        if($t.inlineCss[id] == undefined){
             $t.createCssObj(id);
        }
        if($t.inlineCss[id].after == undefined){
            $t.inlineCss[id].after = {};
            $t.inlineCss[id].before = {};
        }
        $t.inlineCss[id].styles['background-color'] = $(this).val();
        $t.inlineCss[id].after['border-color'] =  $(this).val()+' transparent transparent transparent';
        $t.inlineCss[id].before['border-color'] =  'transparent '+$(this).val()+' transparent transparent';
        
        $t.writeCss();
    })
};