intialize.push('card');
colorpickersIds.push('#card_text_color');
colorpickersIds.push('#card_background_color');
MR_landing.prototype.cardDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'card').addClass('card complex-item thumbnail');
    
    var div = $t.ce('div');
    $(div).addClass('MR-ribbon right').attr('id', $t.randString(6)).appendTo(box);
    var span = $t.ce('span');
    $(span).attr('id', $t.randString(6)).text($t.lang('COM_MARKETINGROCKET_RIBBON')).appendTo(div);
    
    var img = $t.ce('img');
    
    $(img).attr('src', locationOfJoomla+'/media/com_marketingrocket/your-image-here.jpg').appendTo(box).attr('id', $t.randString(6));
    
    $t.isChildAdded = true;
    
    var h3 = $t.ce('h3');
    $(h3).addClass('contenteditable').attr('contenteditable', 'true').appendTo(box).text('Title').attr('id', $t.randString(6));
    
    var articleBox = $t.articleboxDropped(box, '');
    
    $(articleBox).find('.content').html('<p></p>');
    
    var div = $t.ce('div');
    $(div).addClass('text-center').appendTo(box);
    
    var btn = $t.buttonDropped(div, '');

    $t.isChildAdded = false;
    
    
    $t.addAdminsBtns(box);
    
    $t.customSetting(box, 'fa-picture-o', COM_MARKETINGROCKET_IMAGEBOX_SETTINGS);
    $t.customSetting(box, 'fa-bookmark fa-rotate-90', $t.lang('COM_MARKETINGROCKET_RIBBON'));
    $t.cardFunctions(box);
    
    $t.addToParent(box, parent, className);
};
MR_landing.prototype.cardFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('.MR_Custom:first').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpCard();
        $t.modal('#card-setting-template','show');
    })

     $(box).find('.MR_Custom:last').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpImageBox();
        $t.modal('#imagebox-setting-template','show');
    })
};
MR_landing.prototype.beforeShowPopUpCard = function(){
    var $t = this;
    var $ = jQuery;
    
    if($t.activeEl.find('.MR-ribbon:first').is(':visible')){
        $('#card_show_show_1').next().attr('class', 'btn active btn-success');
        $('#card_show_show_0').next().attr('class', 'btn');
    }
    else {
        $('#card_show_show_1').next().attr('class', 'btn');
        $('#card_show_show_0').next().attr('class', 'btn active btn-danger');
    }
    
    if(!$t.activeEl.find('.MR-ribbon:first').hasClass('right')){
        $('#card_position_left').next().attr('class', 'btn active btn-success');
        $('#card_position_right').next().attr('class', 'btn');
    }
    else {
        $('#card_position_left').next().attr('class', 'btn');
        $('#card_position_right').next().attr('class', 'btn active btn-success');
    }
    
    var id = $t.activeEl.find('.MR-ribbon:first span').attr('id');
    if($t.inlineCss[id] != undefined){
        $('#card_text_color').val($t.inlineCss[id].styles.color).ColorPickerSetColor($t.inlineCss[id].styles.color);
    }
    else 
        $('#card_text_color').val('');
    
    var id = $t.activeEl.find('.MR-ribbon:first').attr('id');
    if($t.inlineCss[id] != undefined){
        $('#card_background_color').val($t.inlineCss[id].styles['background-color']).ColorPickerSetColor($t.inlineCss[id].styles['background-color']);
    }
    else 
        $('#card_background_color').val('');
    
    $('#card_text').val($t.activeEl.find('.MR-ribbon:first span').text());
};
MR_landing.prototype.card = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#card_show_show_1').click(function(){
        $t.activeEl.find('.MR-ribbon:first').show();
    });
    $('#card_show_show_0').click(function(){
        $t.activeEl.find('.MR-ribbon:first').hide();
    });
    $('#card_position_left').click(function(){
        $t.activeEl.find('.MR-ribbon:first').removeClass('right');
    });
    $('#card_position_right').click(function(){
        $t.activeEl.find('.MR-ribbon:first').addClass('right');
    });
    $('#card_text_color').keyup(function(){
        
        var id = $t.activeEl.find('.MR-ribbon:first span').attr('id');
        if($t.inlineCss[id] == undefined)
            $t.createCssObj(id, '');
        
        $t.inlineCss[id].styles.color = $(this).val();
        $t.writeCss();
    });
    $('#card_background_color').keyup(function(){
        
        var id = $t.activeEl.find('.MR-ribbon:first').attr('id');
        if($t.inlineCss[id] == undefined)
            $t.createCssObj(id, '');
        
        $t.inlineCss[id].styles['background-color'] = $(this).val();
        $t.writeCss();
    });
    
    $('#card_text').keyup(function(){
        $t.activeEl.find('.MR-ribbon:first span').text($(this).val());
    });
};