intialize.push('icon');
MR_landing.prototype.iconDropped = function(parent, className){
    var $t = this;
    var $ = jQuery;
    
    
    
    var box = $t.createBox('div', className);
    $(box).attr('aria-type', 'icon').addClass('icon_element');

    var span = $t.ce('span');
    var id = $t.randString(6);
    
    $(span).addClass('fa fa-smile-o').attr('id', id).attr('data-size', '20');
    $(box).append(span);

    $t.addAdminsBtns(box);

    $t.customSetting(box, 'fa-smile-o', COM_MARKETINGROCKET_ICON_EDIT_TITLE);
    $t.iconFunctions(box);


    $t.addToParent(box, parent, className);
    
    $t.createCssObj(id, span);
}
MR_landing.prototype.iconFunctions = function(box){
    var $t = this;
    var $ = jQuery;
    
    $(box).find('a.MR_Custom').click(function(){
        $t.activeEl = $(box);
        $t.beforeShowPopUpIcon();
        $t.modal('#icon_setting','show');
    });
    $('#icon_setting').find('h3:first small').text('#'+$(box).find('> span').attr('id'));
}
MR_landing.prototype.beforeShowPopUpIcon = function(){
    var $t = this;
    var $ = jQuery;
    
    var icon = $t.activeEl.find(' > span:first');
    $('#icon_size').slider('value', icon.attr('data-size'));
    $('#icon_size_input').val(icon.attr('data-size')).keyup();
    var color = $t.rgb2hex(icon.css('color'));
    $('#jform_icon_color').val(color).ColorPickerSetColor(color).keyup();
    
    $(MR_ICON_MAGIC).unbind('selectionchange');
    if(icon.length > 0){
            var allClass = icon.attr('class'); 
            if(allClass == undefined)
                    allClass = ''
            allClass = allClass.split(' ');
            var selected = [];
            for(var i = 0 ;i < allClass.length;i++){
                if(allClass[i] == 'replace')
                    continue;
                var obj = {name: allClass[i], value : allClass[i]};
                selected.push(obj);
            }
            MR_ICON_MAGIC.setSelection(selected);
    }
    else 
    {
            MR_ICON_MAGIC.clear();	
    }
    
    $(MR_ICON_MAGIC).on('selectionchange' ,function(){
            var span = $t.activeEl.find(' > span:first');
            span.removeAttr('class');
            $('[name="jform[icon][]"]').each(function(){
                    span.addClass($(this).val());
            });
            // 
            if(span.attr('aria-replace'))
                span.addClass('replace');
    });
    $('#jform_icon_hover_color').val('');
    
    if($t.activeEl.find(' > span:first').attr('aria-replace'))
    {
        $('#jform_icon_linked0').next().click();
        $('#jform_icon_linked0').click();
        
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if($t.inlineCss[id]){
            try {
                $('#jform_icon_hover_color').val($t.inlineCss[id].hover.color);
            }
            catch(e){
                
            }
        }
    }
    else {
        $('#jform_icon_linked1').next().click();
        $('#jform_icon_linked1').click();
    }
    
    $('#jform_icon_href').val($t.activeEl.find(' > span:first').attr('href'));
    
    $('#jform_icon_target').val($t.activeEl.find(' > span:first').attr('target'));
    
    
    
    
}
MR_landing.prototype.icon = function(){
    var $t = this;
    var $ = jQuery;
    
    $('#icon_size_input').keyup(function(){
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if(!$t.inlineCss[id])
            $t.createCssObj(id, span);
        
        $t.inlineCss[id].styles['font-size'] = $(this).val()+'em';
        
        span.attr('data-size', $(this).val()).removeAttr('style');
        $t.writeCss();
    });
    
    $('#jform_icon_color').keyup(function(){
        
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if(!$t.inlineCss[id])
            $t.createCssObj(id, span);
        
        $t.inlineCss[id].styles['color'] = $(this).val();
        span.removeAttr('style');
        $t.writeCss();
    });
    
    $('#icon_setting [name="jform[icon-linked]"]').click(function(){
        var span = $t.activeEl.find(' > span:first');
        if($('#icon_setting [name="jform[icon-linked]"]:checked').val() == 1){
            span.addClass('replace').attr('aria-replace', 'a');
            $('#jform_icon_href').parents('.control-group:first').show();
            $('#jform_icon_target').parents('.control-group:first').show();
            $('#jform_icon_hover_color').parents('.control-group:first').show();
        }
        else {
            span.removeClass('replace').removeAttr('aria-replace');
            $('#jform_icon_hover_color').val('').blur();
            $('#jform_icon_href').val('').blur();
            $('#jform_icon_href').parents('.control-group:first').hide();
            $('#jform_icon_target').parents('.control-group:first').hide();
            $('#jform_icon_hover_color').parents('.control-group:first').hide();
        }
    });
    
    $('#jform_icon_href').blur(function(){
        var val = $(this).val();
        if(val != '')
            $t.activeEl.find(' > span:first').attr('href', val);
        else 
            $t.activeEl.find(' > span:first').removeAttr('href');
    });
    
    $('#jform_icon_target').change(function(){
        var val = $(this).val();
        if($('#icon_setting [name="jform[icon-linked]"]:checked').val() == 1)
            $t.activeEl.find(' > span:first').attr('target', val);
    });
    
    $('#jform_icon_hover_color').blur(function(){
        
        var span = $t.activeEl.find(' > span:first');
        var id = span.attr('id');
        if(!$t.inlineCss[id])
            $t.createCssObj(id, span);
        
        $t.inlineCss[id].hover['color'] = $(this).val();
        $t.inlineCss[id].hover['text-decoration'] = 'none';
        $t.writeCss();
    });
}