'use strict';


angular.
module('preConfiguration').
filter ('alias' , function(){
    return function (input) {
        input = input || '';

        return input.replace(/\W/g, '-');
    }
}).
component('preConfiguration', {
    templateUrl: appBasePath+'pre-configuration/pre-configuration.template.html',

    controller: ['$location', '$http', '$mdDialog', function PreConfiguration($location, $http, $mdDialog) {
        var self = this;
        self.stepName = "Enter Your Download Id";
        self.downloadId = "";
        self.loading = false;
        self.step = 1;
        self.origin = location.origin;
        self.menuName = "Marketing Rocket";
        self.downloadIdIsWrong = false;
        self.menuCreated = false;


        self.setDownloadIdValid = function () {
            // downloadIdIsValid = true;
        };

        /**
         * The workhorse; converts an object to x-www-form-urlencoded serialization.
         * @param {Object} obj
         * @return {String}
         */
        self.param = function(obj) {
            var query = '', name, value, fullSubName, subName, subValue, innerObj, i;

            for(name in obj) {
                value = obj[name];

                if(value instanceof Array) {
                    for(i=0; i<value.length; ++i) {
                        subValue = value[i];
                        fullSubName = name + '[' + i + ']';
                        innerObj = {};
                        innerObj[fullSubName] = subValue;
                        query += param(innerObj) + '&';
                    }
                }
                else if(value instanceof Object) {
                    for(subName in value) {
                        subValue = value[subName];
                        fullSubName = name + '[' + subName + ']';
                        innerObj = {};
                        innerObj[fullSubName] = subValue;
                        query += param(innerObj) + '&';
                    }
                }
                else if(value !== undefined && value !== null)
                    query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
            }

            return query.length ? query.substr(0, query.length - 1) : query;
        };

        self.checkDownloadId = function(){
            if(self.loading)
                return;
            self.loading = true;
            $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";

            $http({ url : 'index.php?option=com_marketingrocket&task=installation.downloadId', data : self.param({download_id : self.downloadId}), method : 'POST'})
                .then(function (res) {
                    if(res.data.data == true){
                        if(showMenuStep)
                            self.step = 2;
                        else {
                            downloadIdIsValid = true;
                            $location.path('/configuration');
                        }
                    }
                    else {
                        self.showAlert("Download Id Is Wrong", "Please Check Your Download Id And Try Again");
                        self.downloadIdIsWrong = true;
                    }
                    self.loading = false;

                }, function () {
                    self.showAlert("Unknown Problem", "Please Try Again");
                    self.loading = false;
                })
        };

        self.showAlert = function(title, desc) {

            $mdDialog.show(
                $mdDialog.alert()
                    // .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(false)
                    .title(title)
                    .textContent(desc)
                    // .ariaLabel('Alert Dialog Demo')
                    .ok('Ok')
                    // .targetEvent(ev)
            );
        };
        self.createMenu = function () {
            if(self.loading)
                return;
            self.loading = true;
            $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";

            $http({ url : 'index.php?option=com_marketingrocket&task=installation.createMenu', data : self.param({menu_name : self.menuName}), method : 'POST'})
                .then(function (res) {
                    downloadIdIsValid = true;
                    if(res.data.data == true){
                        self.menuCreated = true;
                    }
                    else {
                        self.showAlert(res.data.message, '');
                    }
                    self.loading = false;

                }, function () {
                    self.showAlert("Unknown Problem", "Please Try Again");
                    self.loading = false;
                })
        }
        self.skip = function () {
            if(self.step == 2 || showMenuStep == false){
                downloadIdIsValid = true;
                $location.path('/configuration');
            }
            self.step = 2;

        }

   }]
});