'use strict';


angular.
module('configuration').
component('configuration', {
    templateUrl: appBasePath+'configuration/configuration.template.html',

    controller: ['$location', '$http', '$compile', '$scope', function Configuration($location, $http, $compile, $scope) {
        var self = this;
        self.progress = 0;
        self.faild = 0;
        self.valid = 0;
        self.shFixed = 0;
        self.joomlaFixed = false;
        self.steps = [
            {
                name: 'Joomla Version',
                task : 'installation.joomla'
            },
            {
                name: 'SEO Setting',
                task : 'installation.seo'
            },
            {
                name: '3rd Party Apps',
                task : 'installation.apps'
            },
            {
                name: 'Editor Setting',
                task : 'installation.editor'
            }

        ];
        self.currentStep = 0;

        $http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded";



        self.runStep = function(){
            if(self.currentStep == self.steps.length)
                return;
            $http({ url : 'index.php?option=com_marketingrocket&task='+self.steps[self.currentStep].task})
                .then(function (res) {
                    self.progress += (100/self.steps.length);
                    if(res.data.success == false){
                        angular.element(document.getElementById('error_cards')).append($compile(res.data.data)($scope));
                        self.faild++;
                    }
                    else {
                        self.valid++;
                    }
                    self.currentStep++;
                    self.runStep();
                });
        }

        self.showShCard = function () {
            alert(self.shFixed)
            if(self.shFixed == 2)
                return false;
            return true;
        }

        self.fixsh = function () {
            self.shFixed = 1;
            var token = document.getElementById('token_holder').getElementsByTagName('input')[0].getAttribute('name');
            $http({ url : 'index.php?option=com_marketingrocket&task=installation.fixsh&'+token+'=1'})
                .then(function (res) {
                    self.shFixed = 2;

                });
        }

        self.runStep();
        self.recheck = function () {
            self.currentStep = 0;
            self.progress = 0;
            self.faild = 0;
            self.valid = 0;

            document.getElementById('error_cards').innerHTML = '';

            self.runStep();

        }
        self.nextStep = function () {
            $location.path('/complete');
        }
        self.skipJoomla = function () {
            self.faild--;
            self.valid++;
            self.joomlaFixed = true;
        }


    }


   ]
});